/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm;

import com.hazelcast.shaded.org.apache.commons.math3.Retry;
import com.hazelcast.shaded.org.apache.commons.math3.RetryRunner;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.City;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.TravellingSalesmanSolver;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RetryRunner.class)
public class KohonenTrainingTaskTest {
    @Test
    public void testTravellerSalesmanSquareTourSequentialSolver() {
        City[] squareOfCities = new City[]{new City("o0", 0.0, 0.0), new City("o1", 1.0, 0.0), new City("o2", 2.0, 0.0), new City("o3", 3.0, 0.0), new City("o4", 3.0, 1.0), new City("o5", 3.0, 2.0), new City("o6", 3.0, 3.0), new City("o7", 2.0, 3.0), new City("o8", 1.0, 3.0), new City("o9", 0.0, 3.0), new City("i3", 1.0, 2.0), new City("i2", 2.0, 2.0), new City("i1", 2.0, 1.0), new City("i0", 1.0, 1.0)};
        long seed = 1245632379L;
        TravellingSalesmanSolver solver = new TravellingSalesmanSolver(squareOfCities, 2.0, 1245632379L);
        Runnable task = solver.createSequentialTask(15000L);
        task.run();
        Assert.assertEquals((double)solver.getUpdateRatio(), (double)1.0, (double)0.0);
        City[] result = solver.getCityList();
        Assert.assertEquals((long)squareOfCities.length, (long)this.uniqueCities(result).size());
        double ratio = this.computeTravelDistance(squareOfCities) / this.computeTravelDistance(result);
        Assert.assertEquals((double)1.0, (double)ratio, (double)0.1);
    }

    @Test
    @Retry
    public void testTravellerSalesmanSquareTourParallelSolver() throws ExecutionException {
        City[] squareOfCities = new City[]{new City("o0", 0.0, 0.0), new City("o1", 1.0, 0.0), new City("o2", 2.0, 0.0), new City("o3", 3.0, 0.0), new City("o4", 3.0, 1.0), new City("o5", 3.0, 2.0), new City("o6", 3.0, 3.0), new City("o7", 2.0, 3.0), new City("o8", 1.0, 3.0), new City("o9", 0.0, 3.0), new City("i3", 1.0, 2.0), new City("i2", 2.0, 2.0), new City("i1", 2.0, 1.0), new City("i0", 1.0, 1.0)};
        long seed = 534712311L;
        TravellingSalesmanSolver solver = new TravellingSalesmanSolver(squareOfCities, 2.0, 534712311L);
        ExecutorService service = Executors.newCachedThreadPool();
        int numProcs = Runtime.getRuntime().availableProcessors();
        Runnable[] tasks = solver.createParallelTasks(numProcs, 5000L);
        ArrayList execOutput = new ArrayList();
        for (Runnable r : tasks) {
            execOutput.add(service.submit(r));
        }
        try {
            for (Future future : execOutput) {
                future.get();
            }
        }
        catch (InterruptedException i$) {
            // empty catch block
        }
        service.shutdown();
        if (numProcs > 1) {
            Assert.assertTrue((solver.getUpdateRatio() < 1.0 ? 1 : 0) != 0);
        }
        City[] result = solver.getCityList();
        Assert.assertEquals((long)squareOfCities.length, (long)this.uniqueCities(result).size());
        double d = this.computeTravelDistance(squareOfCities) / this.computeTravelDistance(result);
        Assert.assertEquals((double)1.0, (double)d, (double)0.1);
    }

    private String travelCoordinatesTable(TravellingSalesmanSolver solver) {
        StringBuilder s = new StringBuilder();
        for (double[] c : solver.getCoordinatesList()) {
            s.append(c[0]).append(" ").append(c[1]).append(" ");
            City city = solver.getClosestCity(c[0], c[1]);
            double[] cityCoord = city.getCoordinates();
            s.append(cityCoord[0]).append(" ").append(cityCoord[1]).append(" ");
            s.append("   # ").append(city.getName()).append("\n");
        }
        return s.toString();
    }

    private Collection<City> uniqueCities(City[] cityList) {
        HashSet<City> unique = new HashSet<City>();
        for (City c : cityList) {
            unique.add(c);
        }
        return unique;
    }

    private double computeTravelDistance(City[] cityList) {
        double dist = 0.0;
        for (int i = 0; i < cityList.length; ++i) {
            double[] currentCoord = cityList[i].getCoordinates();
            double[] nextCoord = cityList[(i + 1) % cityList.length].getCoordinates();
            double xDiff = currentCoord[0] - nextCoord[0];
            double yDiff = currentCoord[1] - nextCoord[1];
            dist += FastMath.sqrt((double)(xDiff * xDiff + yDiff * yDiff));
        }
        return dist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary(String filename, TravellingSalesmanSolver solver) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(filename);
            out.println(this.travelCoordinatesTable(solver));
            City[] result = solver.getCityList();
            out.println("# Number of unique cities: " + this.uniqueCities(result).size());
            out.println("# Travel distance: " + this.computeTravelDistance(result));
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

