/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnmodifiableRealVectorAbstractTest {
    protected static final int DIM = 100;
    protected static final double EPS = 10.0 * Math.ulp(1.0);
    protected static final Set<String> EXCLUDE = new HashSet<String>();
    protected static final Random RANDOM;

    public static boolean equals(double x, double y) {
        if (x == y) {
            return true;
        }
        if (FastMath.abs((double)x) <= EPS) {
            return FastMath.abs((double)y) <= EPS;
        }
        if (FastMath.abs((double)y) <= EPS) {
            return FastMath.abs((double)x) <= EPS;
        }
        return FastMath.abs((double)(x - y)) <= EPS * FastMath.min((double)FastMath.abs((double)x), (double)FastMath.abs((double)y));
    }

    public static boolean equals(double[] x, double[] y) {
        if (x.length != y.length) {
            return false;
        }
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            if (UnmodifiableRealVectorAbstractTest.equals(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealVector x, RealVector y) {
        if (x.getDimension() != y.getDimension()) {
            return false;
        }
        int n = x.getDimension();
        for (int i = 0; i < n; ++i) {
            if (UnmodifiableRealVectorAbstractTest.equals(x.getEntry(i), y.getEntry(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealVector x, double[] y) {
        if (x.getDimension() != y.length) {
            return false;
        }
        int n = x.getDimension();
        for (int i = 0; i < n; ++i) {
            if (UnmodifiableRealVectorAbstractTest.equals(x.getEntry(i), y[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealMatrix x, RealMatrix y) {
        if (x.getRowDimension() != y.getRowDimension()) {
            return false;
        }
        if (x.getColumnDimension() != y.getColumnDimension()) {
            return false;
        }
        int rows = x.getRowDimension();
        int cols = x.getColumnDimension();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (UnmodifiableRealVectorAbstractTest.equals(x.getEntry(i, j), y.getEntry(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Object x, Object y) {
        if (x instanceof Boolean) {
            if (y instanceof Boolean) {
                return ((Boolean)x).booleanValue() == ((Boolean)y).booleanValue();
            }
            return false;
        }
        if (x instanceof Integer) {
            if (y instanceof Integer) {
                return ((Integer)x).intValue() == ((Integer)y).intValue();
            }
            return false;
        }
        if (x instanceof Double) {
            if (y instanceof Double) {
                return UnmodifiableRealVectorAbstractTest.equals((Double)x, (Double)y);
            }
            return false;
        }
        if (x instanceof double[]) {
            if (y instanceof double[]) {
                return UnmodifiableRealVectorAbstractTest.equals((double[])x, (double[])y);
            }
            if (y instanceof RealVector) {
                return UnmodifiableRealVectorAbstractTest.equals((RealVector)y, (double[])x);
            }
            return false;
        }
        if (x instanceof RealVector) {
            if (y instanceof double[]) {
                return UnmodifiableRealVectorAbstractTest.equals((RealVector)x, (double[])y);
            }
            if (y instanceof RealVector) {
                return UnmodifiableRealVectorAbstractTest.equals((RealVector)x, (RealVector)y);
            }
            return false;
        }
        if (x instanceof RealMatrix) {
            if (y instanceof RealMatrix) {
                return UnmodifiableRealVectorAbstractTest.equals((RealMatrix)x, (RealMatrix)y);
            }
            return false;
        }
        throw new IllegalArgumentException("could not compare " + x + ", " + y);
    }

    public abstract RealVector createVector();

    public Object createParameter(Class<?> c) {
        if (c == Integer.TYPE) {
            return RANDOM.nextInt();
        }
        if (c == Double.TYPE) {
            return RANDOM.nextDouble();
        }
        if (c == double[].class) {
            double[] v = new double[100];
            for (int i = 0; i < 100; ++i) {
                v[i] = RANDOM.nextDouble();
            }
            return v;
        }
        if (c.isAssignableFrom(RealVector.class)) {
            return this.createVector();
        }
        if (c.isAssignableFrom(UnivariateFunction.class)) {
            return new Sin();
        }
        throw new IllegalArgumentException("could not create " + c);
    }

    private void callMethod(Method m, RealVector u, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RealVector uu = u.copy();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u.copy());
        Object exp = m.invoke((Object)u, args);
        if (UnmodifiableRealVectorAbstractTest.equals(uu, u)) {
            Object act = m.invoke((Object)v, args);
            Assert.assertTrue((String)(m.toGenericString() + ", unmodifiable vector has changed"), (boolean)UnmodifiableRealVectorAbstractTest.equals(uu, v));
            Assert.assertTrue((String)(m.toGenericString() + ", wrong result"), (boolean)UnmodifiableRealVectorAbstractTest.equals(exp, act));
        } else {
            boolean flag;
            block4: {
                flag = false;
                try {
                    m.invoke((Object)v, args);
                }
                catch (InvocationTargetException e) {
                    if (!(e.getCause() instanceof MathUnsupportedOperationException)) break block4;
                    flag = true;
                }
            }
            Assert.assertTrue((String)(m.toGenericString() + ", exception should have been thrown"), (boolean)flag);
        }
    }

    @Test
    public void testAllButExcluded() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] method = RealVector.class.getMethods();
        for (int i = 0; i < method.length; ++i) {
            Method m = method[i];
            if (EXCLUDE.contains(m.getName())) continue;
            RealVector u = (RealVector)this.createParameter(RealVector.class);
            Class<?>[] paramType = m.getParameterTypes();
            Object[] param = new Object[paramType.length];
            for (int j = 0; j < paramType.length; ++j) {
                param[j] = this.createParameter(paramType[j]);
            }
            this.callMethod(m, u, param);
        }
    }

    @Test
    public void testGetEntry() {
        RealVector u = this.createVector();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u);
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(u.getEntry(i), v.getEntry(i)));
        }
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testSetEntry() {
        RealVector u = this.createVector();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u);
        for (int i = 0; i < 100; ++i) {
            v.setEntry(i, 0.0);
        }
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testAddToEntry() {
        RealVector u = this.createVector();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u);
        for (int i = 0; i < 100; ++i) {
            v.addToEntry(i, 0.0);
        }
    }

    @Test
    public void testGetSubVector() {
        RealVector u = this.createVector();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u);
        for (int i = 0; i < 100; ++i) {
            for (int n = 1; n < 100 - i; ++n) {
                RealVector exp = u.getSubVector(i, n);
                RealVector act = v.getSubVector(i, n);
                Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(exp, act));
            }
        }
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testSetSubVector() {
        RealVector u = this.createVector();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u);
        v.setSubVector(0, (RealVector)new ArrayRealVector());
    }

    @Test
    public void testIterator() {
        RealVector u = this.createVector();
        Iterator i = u.iterator();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u.copy());
        Iterator j = v.iterator();
        while (i.hasNext()) {
            Assert.assertTrue((boolean)j.hasNext());
            RealVector.Entry exp = (RealVector.Entry)i.next();
            RealVector.Entry act = (RealVector.Entry)j.next();
            Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(exp.getIndex(), act.getIndex()));
            Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(exp.getValue(), act.getValue()));
            exp.setIndex(RANDOM.nextInt(100));
            act.setIndex(RANDOM.nextInt(100));
            boolean flag = false;
            try {
                act.setValue(RANDOM.nextDouble());
            }
            catch (MathUnsupportedOperationException e) {
                flag = true;
            }
            Assert.assertTrue((String)"exception should have been thrown", (boolean)flag);
        }
        Assert.assertFalse((boolean)j.hasNext());
    }

    @Test
    public void testSparseIterator() {
        RealVector u = this.createVector();
        Iterator i = u.sparseIterator();
        RealVector v = RealVector.unmodifiableRealVector((RealVector)u.copy());
        Iterator j = v.sparseIterator();
        while (i.hasNext()) {
            Assert.assertTrue((boolean)j.hasNext());
            RealVector.Entry exp = (RealVector.Entry)i.next();
            RealVector.Entry act = (RealVector.Entry)j.next();
            Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(exp.getIndex(), act.getIndex()));
            Assert.assertTrue((boolean)UnmodifiableRealVectorAbstractTest.equals(exp.getValue(), act.getValue()));
            exp.setIndex(RANDOM.nextInt(100));
            act.setIndex(RANDOM.nextInt(100));
            boolean flag = false;
            try {
                act.setValue(RANDOM.nextDouble());
            }
            catch (MathUnsupportedOperationException e) {
                flag = true;
            }
            Assert.assertTrue((String)"exception should have been thrown", (boolean)flag);
        }
        Assert.assertFalse((boolean)j.hasNext());
    }

    static {
        EXCLUDE.add("getEntry");
        EXCLUDE.add("setEntry");
        EXCLUDE.add("addToEntry");
        EXCLUDE.add("getSubVector");
        EXCLUDE.add("setSubVector");
        EXCLUDE.add("iterator");
        EXCLUDE.add("sparseIterator");
        EXCLUDE.add("walkInDefaultOrder");
        EXCLUDE.add("walkInOptimizedOrder");
        EXCLUDE.add("ebeDivide");
        EXCLUDE.add("ebeMultiply");
        for (Method m : Object.class.getMethods()) {
            EXCLUDE.add(m.getName());
        }
        RANDOM = new Random(20110813L);
    }
}

