/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Abs;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Acos;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Asin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Atan;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cbrt;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Ceil;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cos;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Cosh;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Exp;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Expm1;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Floor;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Log1p;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Power;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Rint;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Signum;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinh;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sqrt;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Tan;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Tanh;
import com.hazelcast.shaded.org.apache.commons.math3.linear.OpenMapRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class SparseRealVectorTest
extends RealVectorAbstractTest {
    public RealVector create(double[] data) {
        return new OpenMapRealVector(data);
    }

    @Test
    public void testConstructors() {
        double[] vec1 = new double[]{1.0, 2.0, 3.0};
        Double[] dvec1 = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        OpenMapRealVector v0 = new OpenMapRealVector();
        Assert.assertEquals((String)"testData len", (long)0L, (long)v0.getDimension());
        OpenMapRealVector v1 = new OpenMapRealVector(7);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v1.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v1.getEntry(6), (double)0.0);
        OpenMapRealVector v3 = new OpenMapRealVector(vec1);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v3.getDimension());
        Assert.assertEquals((String)"testData is 2.0 ", (double)2.0, (double)v3.getEntry(1), (double)0.0);
        OpenMapRealVector v5_i = new OpenMapRealVector(dvec1);
        Assert.assertEquals((String)"testData len", (long)9L, (long)v5_i.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v5_i.getEntry(8), (double)0.0);
        OpenMapRealVector v5 = new OpenMapRealVector(dvec1);
        Assert.assertEquals((String)"testData len", (long)9L, (long)v5.getDimension());
        Assert.assertEquals((String)"testData is 9.0 ", (double)9.0, (double)v5.getEntry(8), (double)0.0);
        OpenMapRealVector v7 = new OpenMapRealVector(v1);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v7.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v7.getEntry(6), (double)0.0);
        RealVectorAbstractTest.RealVectorTestImpl v7_i = new RealVectorAbstractTest.RealVectorTestImpl(vec1);
        OpenMapRealVector v7_2 = new OpenMapRealVector((RealVector)v7_i);
        Assert.assertEquals((String)"testData len", (long)3L, (long)v7_2.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)2.0, (double)v7_2.getEntry(1), (double)0.0);
        OpenMapRealVector v8 = new OpenMapRealVector(v1);
        Assert.assertEquals((String)"testData len", (long)7L, (long)v8.getDimension());
        Assert.assertEquals((String)"testData is 0.0 ", (double)0.0, (double)v8.getEntry(6), (double)0.0);
    }

    @Test
    public void testConcurrentModification() {
        OpenMapRealVector u = new OpenMapRealVector(3, 1.0E-6);
        u.setEntry(0, 1.0);
        u.setEntry(1, 0.0);
        u.setEntry(2, 2.0);
        OpenMapRealVector v1 = new OpenMapRealVector(3, 1.0E-6);
        v1.setEntry(0, 0.0);
        v1.setEntry(1, 3.0);
        v1.setEntry(2, 0.0);
        u.ebeMultiply((RealVector)v1);
        u.ebeDivide((RealVector)v1);
    }

    @Test
    public void testEbeMultiplyMixedTypes() {
        this.doTestEbeBinaryOperation(RealVectorAbstractTest.BinaryOperation.MUL, true, true);
    }

    @Test
    public void testEbeMultiplySameType() {
        this.doTestEbeBinaryOperation(RealVectorAbstractTest.BinaryOperation.MUL, false, true);
    }

    @Test
    public void testEbeDivideSameType() {
        this.doTestEbeBinaryOperation(RealVectorAbstractTest.BinaryOperation.DIV, false, true);
    }

    protected UnivariateFunction[] createFunctions() {
        return new UnivariateFunction[]{new Power(2.0), new Exp(), new Expm1(), new Log1p(), new Cosh(), new Sinh(), new Tanh(), new Cos(), new Sin(), new Tan(), new Acos(), new Asin(), new Atan(), new Abs(), new Sqrt(), new Cbrt(), new Ceil(), new Floor(), new Rint(), new Signum()};
    }
}

