/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import com.hazelcast.shaded.org.apache.commons.math3.linear.EigenDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.EigenDecompositionTest;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVectorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class EigenSolverTest {
    private double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};

    @Test
    public void testNonInvertible() {
        Random r = new Random(9994100315209L);
        RealMatrix m = EigenDecompositionTest.createTestMatrix(r, new double[]{1.0, 0.0, -1.0, -2.0, -3.0});
        DecompositionSolver es = new EigenDecomposition(m).getSolver();
        Assert.assertFalse((boolean)es.isNonSingular());
        try {
            es.getInverse();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testInvertible() {
        Random r = new Random(9994100315209L);
        RealMatrix m = EigenDecompositionTest.createTestMatrix(r, new double[]{1.0, 0.5, -1.0, -2.0, -3.0});
        DecompositionSolver es = new EigenDecomposition(m).getSolver();
        Assert.assertTrue((boolean)es.isNonSingular());
        RealMatrix inverse = es.getInverse();
        RealMatrix error = m.multiply(inverse).subtract(MatrixUtils.createRealIdentityMatrix((int)m.getRowDimension()));
        Assert.assertEquals((double)0.0, (double)error.getNorm(), (double)4.0E-15);
    }

    @Test
    public void testInvertibleTinyValues() {
        double tiny = 1.0E-100;
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 2.0, 4.0}, {2.0, 0.0, 2.0}, {4.0, 2.0, 3.0}});
        m = m.scalarMultiply(1.0E-100);
        EigenDecomposition ed = new EigenDecomposition(m);
        RealMatrix inv = ed.getSolver().getInverse();
        RealMatrix id = m.multiply(inv);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (i == j) {
                    Assert.assertTrue((boolean)Precision.equals((double)1.0, (double)id.getEntry(i, j), (double)1.0E-15));
                    continue;
                }
                Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)id.getEntry(i, j), (double)1.0E-15));
            }
        }
    }

    @Test(expected=SingularMatrixException.class)
    public void testNonInvertibleMath1045() {
        EigenDecomposition eigen = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])this.bigSingular));
        eigen.getSolver().getInverse();
    }

    @Test(expected=SingularMatrixException.class)
    public void testZeroMatrix() {
        EigenDecomposition eigen = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0}}));
        eigen.getSolver().getInverse();
    }

    @Test
    public void testIsNonSingularTinyOutOfOrderEigenvalue() {
        EigenDecomposition eigen = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0E-13, 0.0}, {1.0, 1.0}}));
        Assert.assertFalse((String)"Singular matrix not detected", (boolean)eigen.getSolver().isNonSingular());
    }

    @Test
    public void testSolveDimensionErrors() {
        double[] refValues = new double[]{2.003, 2.002, 2.001, 1.001, 1.0, 0.001};
        RealMatrix matrix = EigenDecompositionTest.createTestMatrix(new Random(35992629946426L), refValues);
        DecompositionSolver es = new EigenDecomposition(matrix).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[2][2]);
        try {
            es.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            es.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            es.solve((RealVector)new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(0)));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolve() {
        int i;
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{91.0, 5.0, 29.0, 32.0, 40.0, 14.0}, {5.0, 34.0, -1.0, 0.0, 2.0, -1.0}, {29.0, -1.0, 12.0, 9.0, 21.0, 8.0}, {32.0, 0.0, 9.0, 14.0, 9.0, 0.0}, {40.0, 2.0, 21.0, 9.0, 51.0, 19.0}, {14.0, -1.0, 8.0, 0.0, 19.0, 14.0}});
        DecompositionSolver es = new EigenDecomposition(m).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{1561.0, 269.0, 188.0}, {69.0, -21.0, 70.0}, {739.0, 108.0, 63.0}, {324.0, 86.0, 59.0}, {1624.0, 194.0, 107.0}, {796.0, 69.0, 36.0}});
        RealMatrix xRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2.0, 1.0}, {2.0, -1.0, 2.0}, {4.0, 2.0, 3.0}, {8.0, -1.0, 0.0}, {16.0, 2.0, 0.0}, {32.0, -1.0, 0.0}});
        RealMatrix solution = es.solve(b);
        Assert.assertEquals((double)0.0, (double)solution.subtract(xRef).getNorm(), (double)2.5E-12);
        for (i = 0; i < b.getColumnDimension(); ++i) {
            Assert.assertEquals((double)0.0, (double)es.solve(b.getColumnVector(i)).subtract(xRef.getColumnVector(i)).getNorm(), (double)2.0E-11);
        }
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVectorAbstractTest.RealVectorTestImpl v = new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(i));
            Assert.assertEquals((double)0.0, (double)es.solve((RealVector)v).subtract(xRef.getColumnVector(i)).getNorm(), (double)2.0E-11);
        }
    }
}

