/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ConjugateGradient;
import com.hazelcast.shaded.org.apache.commons.math3.linear.HilbertMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.InverseHilbertMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.IterativeLinearSolverEvent;
import com.hazelcast.shaded.org.apache.commons.math3.linear.JacobiPreconditioner;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareOperatorException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealLinearOperator;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.IterationEvent;
import com.hazelcast.shaded.org.apache.commons.math3.util.IterationListener;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ConjugateGradientTest {
    @Test(expected=NonSquareOperatorException.class)
    public void testNonSquareOperator() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 3);
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDimensionMismatchRightHandSide() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(3, 3);
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(2);
        ArrayRealVector x = new ArrayRealVector(3);
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDimensionMismatchSolution() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(3, 3);
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(3);
        ArrayRealVector x = new ArrayRealVector(2);
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test(expected=NonPositiveDefiniteOperatorException.class)
    public void testNonPositiveDefiniteLinearOperator() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        a.setEntry(0, 0, -1.0);
        a.setEntry(0, 1, 2.0);
        a.setEntry(1, 0, 3.0);
        a.setEntry(1, 1, 4.0);
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, true);
        ArrayRealVector b = new ArrayRealVector(2);
        b.setEntry(0, -1.0);
        b.setEntry(1, -1.0);
        ArrayRealVector x = new ArrayRealVector(2);
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test
    public void testUnpreconditionedSolution() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealVector)b);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-10 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d]", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testUnpreconditionedInPlaceSolutionWithInitialGuess() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            ArrayRealVector x0 = new ArrayRealVector(5);
            x0.set(1.0);
            RealVector x = solver.solveInPlace((RealLinearOperator)a, (RealVector)b, (RealVector)x0);
            Assert.assertSame((String)"x should be a reference to x0", (Object)x0, (Object)x);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-10 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d)", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testUnpreconditionedSolutionWithInitialGuess() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            ArrayRealVector x0 = new ArrayRealVector(5);
            x0.set(1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x0);
            Assert.assertNotSame((String)"x should not be a reference to x0", (Object)x0, (Object)x);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-10 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d]", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
                Assert.assertEquals((String)msg, (double)x0.getEntry(i), (double)1.0, (double)Math.ulp(1.0));
            }
        }
    }

    @Test
    public void testUnpreconditionedResidual() {
        int n = 10;
        int maxIterations = 10;
        HilbertMatrix a = new HilbertMatrix(10);
        ConjugateGradient solver = new ConjugateGradient(10, 1.0E-15, true);
        ArrayRealVector r = new ArrayRealVector(10);
        ArrayRealVector x = new ArrayRealVector(10);
        IterationListener listener = new IterationListener((RealVector)r, (RealVector)x){
            final /* synthetic */ RealVector val$r;
            final /* synthetic */ RealVector val$x;
            {
                this.val$r = realVector;
                this.val$x = realVector2;
            }

            public void terminationPerformed(IterationEvent e) {
            }

            public void iterationStarted(IterationEvent e) {
            }

            public void iterationPerformed(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector v = evt.getResidual();
                this.val$r.setSubVector(0, v);
                v = evt.getSolution();
                this.val$x.setSubVector(0, v);
            }

            public void initializationPerformed(IterationEvent e) {
            }
        };
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(10);
        for (int j = 0; j < 10; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            boolean caught = false;
            try {
                solver.solve((RealLinearOperator)a, (RealVector)b);
            }
            catch (MaxCountExceededException e) {
                caught = true;
                RealVector y = a.operate((RealVector)x);
                for (int i = 0; i < 10; ++i) {
                    double actual = b.getEntry(i) - y.getEntry(i);
                    double expected = r.getEntry(i);
                    double delta = 1.0E-6 * FastMath.abs((double)expected);
                    String msg = String.format("column %d, residual %d", i, j);
                    Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
                }
            }
            Assert.assertTrue((String)"MaxCountExceededException should have been caught", (boolean)caught);
        }
    }

    @Test(expected=NonSquareOperatorException.class)
    public void testNonSquarePreconditioner() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                throw new UnsupportedOperationException();
            }

            public int getRowDimension() {
                return 2;
            }

            public int getColumnDimension() {
                return 3;
            }
        };
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testMismatchedOperatorDimensions() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                throw new UnsupportedOperationException();
            }

            public int getRowDimension() {
                return 3;
            }

            public int getColumnDimension() {
                return 3;
            }
        };
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test(expected=NonPositiveDefiniteOperatorException.class)
    public void testNonPositiveDefinitePreconditioner() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        a.setEntry(0, 0, 1.0);
        a.setEntry(0, 1, 2.0);
        a.setEntry(1, 0, 3.0);
        a.setEntry(1, 1, 4.0);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                ArrayRealVector y = new ArrayRealVector(2);
                y.setEntry(0, -x.getEntry(0));
                y.setEntry(1, x.getEntry(1));
                return y;
            }

            public int getRowDimension() {
                return 2;
            }

            public int getColumnDimension() {
                return 2;
            }
        };
        ConjugateGradient solver = new ConjugateGradient(10, 0.0, true);
        ArrayRealVector b = new ArrayRealVector(2);
        b.setEntry(0, -1.0);
        b.setEntry(1, -1.0);
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test
    public void testPreconditionedSolution() {
        int n = 8;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(8);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(8);
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-15, true);
        ArrayRealVector b = new ArrayRealVector(8);
        for (int j = 0; j < 8; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
            for (int i = 0; i < 8; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                String msg = String.format("coefficient (%d, %d)", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testPreconditionedResidual() {
        int n = 10;
        int maxIterations = 10;
        HilbertMatrix a = new HilbertMatrix(10);
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        ConjugateGradient solver = new ConjugateGradient(10, 1.0E-15, true);
        ArrayRealVector r = new ArrayRealVector(10);
        ArrayRealVector x = new ArrayRealVector(10);
        IterationListener listener = new IterationListener((RealVector)r, (RealVector)x){
            final /* synthetic */ RealVector val$r;
            final /* synthetic */ RealVector val$x;
            {
                this.val$r = realVector;
                this.val$x = realVector2;
            }

            public void terminationPerformed(IterationEvent e) {
            }

            public void iterationStarted(IterationEvent e) {
            }

            public void iterationPerformed(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector v = evt.getResidual();
                this.val$r.setSubVector(0, v);
                v = evt.getSolution();
                this.val$x.setSubVector(0, v);
            }

            public void initializationPerformed(IterationEvent e) {
            }
        };
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(10);
        for (int j = 0; j < 10; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            boolean caught = false;
            try {
                solver.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
            }
            catch (MaxCountExceededException e) {
                caught = true;
                RealVector y = a.operate((RealVector)x);
                for (int i = 0; i < 10; ++i) {
                    double actual = b.getEntry(i) - y.getEntry(i);
                    double expected = r.getEntry(i);
                    double delta = 1.0E-6 * FastMath.abs((double)expected);
                    String msg = String.format("column %d, residual %d", i, j);
                    Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
                }
            }
            Assert.assertTrue((String)"MaxCountExceededException should have been caught", (boolean)caught);
        }
    }

    @Test
    public void testPreconditionedSolution2() {
        int n = 100;
        int maxIterations = 100000;
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(100, 100);
        double daux = 1.0;
        for (int i = 0; i < 100; ++i) {
            a.setEntry(i, i, daux);
            daux *= 1.2;
            for (int j = i + 1; j < 100; ++j) {
                if (i == j) continue;
                double value = 1.0;
                a.setEntry(i, j, 1.0);
                a.setEntry(j, i, 1.0);
            }
        }
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        ConjugateGradient pcg = new ConjugateGradient(100000, 1.0E-6, true);
        ConjugateGradient cg = new ConjugateGradient(100000, 1.0E-6, true);
        ArrayRealVector b = new ArrayRealVector(100);
        String pattern = "preconditioned gradient (%d iterations) should have been faster than unpreconditioned (%d iterations)";
        for (int j = 0; j < 1; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector px = pcg.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
            RealVector x = cg.solve((RealLinearOperator)a, (RealVector)b);
            int npcg = pcg.getIterationManager().getIterations();
            int ncg = cg.getIterationManager().getIterations();
            String msg = String.format("preconditioned gradient (%d iterations) should have been faster than unpreconditioned (%d iterations)", npcg, ncg);
            Assert.assertTrue((String)msg, (npcg < ncg ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                msg = String.format("row %d, column %d", i, j);
                double expected = x.getEntry(i);
                double actual = px.getEntry(i);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testEventManagement() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        final int[] count = new int[]{0, 0, 0, 0};
        IterationListener listener = new IterationListener(){

            private void doTestVectorsAreUnmodifiable(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                try {
                    evt.getResidual().set(0.0);
                    Assert.fail((String)"r is modifiable");
                }
                catch (MathUnsupportedOperationException mathUnsupportedOperationException) {
                    // empty catch block
                }
                try {
                    evt.getRightHandSideVector().set(0.0);
                    Assert.fail((String)"b is modifiable");
                }
                catch (MathUnsupportedOperationException mathUnsupportedOperationException) {
                    // empty catch block
                }
                try {
                    evt.getSolution().set(0.0);
                    Assert.fail((String)"x is modifiable");
                }
                catch (MathUnsupportedOperationException mathUnsupportedOperationException) {
                    // empty catch block
                }
            }

            public void initializationPerformed(IterationEvent e) {
                count[0] = count[0] + 1;
                this.doTestVectorsAreUnmodifiable(e);
            }

            public void iterationPerformed(IterationEvent e) {
                count[2] = count[2] + 1;
                Assert.assertEquals((String)"iteration performed", (long)count[2], (long)(e.getIterations() - 1));
                this.doTestVectorsAreUnmodifiable(e);
            }

            public void iterationStarted(IterationEvent e) {
                count[1] = count[1] + 1;
                Assert.assertEquals((String)"iteration started", (long)count[1], (long)(e.getIterations() - 1));
                this.doTestVectorsAreUnmodifiable(e);
            }

            public void terminationPerformed(IterationEvent e) {
                count[3] = count[3] + 1;
                this.doTestVectorsAreUnmodifiable(e);
            }
        };
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            Arrays.fill(count, 0);
            b.set(0.0);
            b.setEntry(j, 1.0);
            solver.solve((RealLinearOperator)a, (RealVector)b);
            String msg = String.format("column %d (initialization)", j);
            Assert.assertEquals((String)msg, (long)1L, (long)count[0]);
            msg = String.format("column %d (finalization)", j);
            Assert.assertEquals((String)msg, (long)1L, (long)count[3]);
        }
    }

    @Test
    public void testUnpreconditionedNormOfResidual() {
        int n = 5;
        int maxIterations = 100;
        final HilbertMatrix a = new HilbertMatrix(5);
        IterationListener listener = new IterationListener(){

            private void doTestNormOfResidual(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector x = evt.getSolution();
                RealVector b = evt.getRightHandSideVector();
                RealVector r = b.subtract(a.operate(x));
                double rnorm = r.getNorm();
                Assert.assertEquals((String)"iteration performed (residual)", (double)rnorm, (double)evt.getNormOfResidual(), (double)FastMath.max((double)(1.0E-5 * rnorm), (double)1.0E-10));
            }

            public void initializationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationStarted(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void terminationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }
        };
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            solver.solve((RealLinearOperator)a, (RealVector)b);
        }
    }

    @Test
    public void testPreconditionedNormOfResidual() {
        int n = 5;
        int maxIterations = 100;
        final HilbertMatrix a = new HilbertMatrix(5);
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        IterationListener listener = new IterationListener(){

            private void doTestNormOfResidual(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector x = evt.getSolution();
                RealVector b = evt.getRightHandSideVector();
                RealVector r = b.subtract(a.operate(x));
                double rnorm = r.getNorm();
                Assert.assertEquals((String)"iteration performed (residual)", (double)rnorm, (double)evt.getNormOfResidual(), (double)FastMath.max((double)(1.0E-5 * rnorm), (double)1.0E-10));
            }

            public void initializationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationStarted(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void terminationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }
        };
        ConjugateGradient solver = new ConjugateGradient(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            solver.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
        }
    }
}

