/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.linear.BiDiagonalTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class BiDiagonalTransformerTest {
    private double[][] testSquare = new double[][]{{0.96, 1.72}, {2.28, 0.96}};
    private double[][] testNonSquare = new double[][]{{-0.864, 1.5408, -0.3456}, {-2.768, -1.1904, 1.6128}, {-1.152, 2.0544, -0.4608}, {-0.576, 0.3072, 2.8096}};

    @Test
    public void testDimensions() {
        this.checkdimensions(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        this.checkdimensions(MatrixUtils.createRealMatrix((double[][])this.testNonSquare));
        this.checkdimensions(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose());
    }

    private void checkdimensions(RealMatrix matrix) {
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        BiDiagonalTransformer transformer = new BiDiagonalTransformer(matrix);
        Assert.assertEquals((long)m, (long)transformer.getU().getRowDimension());
        Assert.assertEquals((long)m, (long)transformer.getU().getColumnDimension());
        Assert.assertEquals((long)m, (long)transformer.getB().getRowDimension());
        Assert.assertEquals((long)n, (long)transformer.getB().getColumnDimension());
        Assert.assertEquals((long)n, (long)transformer.getV().getRowDimension());
        Assert.assertEquals((long)n, (long)transformer.getV().getColumnDimension());
    }

    @Test
    public void testAEqualUSVt() {
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testNonSquare));
        this.checkAEqualUSVt(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose());
    }

    private void checkAEqualUSVt(RealMatrix matrix) {
        BiDiagonalTransformer transformer = new BiDiagonalTransformer(matrix);
        RealMatrix u = transformer.getU();
        RealMatrix b = transformer.getB();
        RealMatrix v = transformer.getV();
        double norm = u.multiply(b).multiply(v.transpose()).subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-14);
    }

    @Test
    public void testUOrthogonal() {
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getU());
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).getU());
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).getU());
    }

    @Test
    public void testVOrthogonal() {
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getV());
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).getV());
        this.checkOrthogonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).getV());
    }

    private void checkOrthogonal(RealMatrix m) {
        RealMatrix mTm = m.transpose().multiply(m);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)mTm.getRowDimension());
        Assert.assertEquals((double)0.0, (double)mTm.subtract(id).getNorm(), (double)1.0E-14);
    }

    @Test
    public void testBBiDiagonal() {
        this.checkBiDiagonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare)).getB());
        this.checkBiDiagonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).getB());
        this.checkBiDiagonal(new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).getB());
    }

    private void checkBiDiagonal(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (rows < cols) {
                    if (i >= j && i <= j + 1) continue;
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)1.0E-16);
                    continue;
                }
                if (i >= j - 1 && i <= j) continue;
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)1.0E-16);
            }
        }
    }

    @Test
    public void testSingularMatrix() {
        BiDiagonalTransformer transformer = new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 3.0, 4.0}, {3.0, 5.0, 7.0}}));
        double s3 = FastMath.sqrt((double)3.0);
        double s14 = FastMath.sqrt((double)14.0);
        double s1553 = FastMath.sqrt((double)1553.0);
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-1.0 / s14, 5.0 / (s3 * s14), 1.0 / s3}, {-2.0 / s14, -4.0 / (s3 * s14), 1.0 / s3}, {-3.0 / s14, 1.0 / (s3 * s14), -1.0 / s3}});
        RealMatrix bRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-s14, s1553 / s14, 0.0}, {0.0, -87.0 * s3 / (s14 * s1553), -s3 * s14 / s1553}, {0.0, 0.0, 0.0}});
        RealMatrix vRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -23.0 / s1553, 32.0 / s1553}, {0.0, -32.0 / s1553, -23.0 / s1553}});
        RealMatrix u = transformer.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-14);
        RealMatrix b = transformer.getB();
        Assert.assertEquals((double)0.0, (double)b.subtract(bRef).getNorm(), (double)1.0E-14);
        RealMatrix v = transformer.getV();
        Assert.assertEquals((double)0.0, (double)v.subtract(vRef).getNorm(), (double)1.0E-14);
        Assert.assertTrue((u == transformer.getU() ? 1 : 0) != 0);
        Assert.assertTrue((b == transformer.getB() ? 1 : 0) != 0);
        Assert.assertTrue((v == transformer.getV() ? 1 : 0) != 0);
    }

    @Test
    public void testMatricesValues() {
        BiDiagonalTransformer transformer = new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare));
        double s17 = FastMath.sqrt((double)17.0);
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-8.0 / (5.0 * s17), 19.0 / (5.0 * s17)}, {-19.0 / (5.0 * s17), -8.0 / (5.0 * s17)}});
        RealMatrix bRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{-3.0 * s17 / 5.0, 32.0 * s17 / 85.0}, {0.0, -5.0 * s17 / 17.0}});
        RealMatrix vRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, -1.0}});
        RealMatrix u = transformer.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-14);
        RealMatrix b = transformer.getB();
        Assert.assertEquals((double)0.0, (double)b.subtract(bRef).getNorm(), (double)1.0E-14);
        RealMatrix v = transformer.getV();
        Assert.assertEquals((double)0.0, (double)v.subtract(vRef).getNorm(), (double)1.0E-14);
        Assert.assertTrue((u == transformer.getU() ? 1 : 0) != 0);
        Assert.assertTrue((b == transformer.getB() ? 1 : 0) != 0);
        Assert.assertTrue((v == transformer.getV() ? 1 : 0) != 0);
    }

    @Test
    public void testUpperOrLower() {
        Assert.assertTrue((boolean)new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare)).isUpperBiDiagonal());
        Assert.assertTrue((boolean)new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare)).isUpperBiDiagonal());
        Assert.assertFalse((boolean)new BiDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testNonSquare).transpose()).isUpperBiDiagonal());
    }
}

