/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.WeibullDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.special.Gamma;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class WeibullDistributionTest
extends RealDistributionAbstractTest {
    public WeibullDistribution makeDistribution() {
        return new WeibullDistribution(1.2, 2.1);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.00664355180993, 0.0454328283309, 0.0981162737374, 0.176713524579, 0.321946865392, 10.5115496887, 7.4976304671, 6.23205600701, 5.23968436955, 4.2079028257};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.180535929306, 0.262801138133, 0.301905425199, 0.330899152971, 0.353441418887, 7.88590320203E-4, 0.00737060094841, 0.0177576041516, 0.0343043442574, 0.065664589369};
    }

    @Test
    public void testInverseCumulativeProbabilitySmallPAccuracy() {
        WeibullDistribution dist = new WeibullDistribution(2.0, 3.0);
        double t = dist.inverseCumulativeProbability(1.0E-17);
        Assert.assertEquals((double)9.48683298050514E-9, (double)t, (double)1.0E-17);
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{0.0, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testAlpha() {
        WeibullDistribution dist = new WeibullDistribution(1.0, 2.0);
        Assert.assertEquals((double)1.0, (double)dist.getShape(), (double)0.0);
        try {
            new WeibullDistribution(0.0, 2.0);
            Assert.fail((String)"NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testBeta() {
        WeibullDistribution dist = new WeibullDistribution(1.0, 2.0);
        Assert.assertEquals((double)2.0, (double)dist.getScale(), (double)0.0);
        try {
            new WeibullDistribution(1.0, 0.0);
            Assert.fail((String)"NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        WeibullDistribution dist = new WeibullDistribution(2.5, 3.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)(3.5 * FastMath.exp((double)Gamma.logGamma((double)1.4))), (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)(12.25 * FastMath.exp((double)Gamma.logGamma((double)1.8)) - dist.getNumericalMean() * dist.getNumericalMean()), (double)1.0E-9);
        dist = new WeibullDistribution(10.4, 2.222);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)(2.222 * FastMath.exp((double)Gamma.logGamma((double)1.0961538461538463))), (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)(4.937284 * FastMath.exp((double)Gamma.logGamma((double)1.1923076923076923)) - dist.getNumericalMean() * dist.getNumericalMean()), (double)1.0E-9);
    }
}

