/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.LogisticDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class LogisticsDistributionTest
extends RealDistributionAbstractTest {
    @Test
    public void testParameters() {
        LogisticDistribution d = this.makeDistribution();
        Assert.assertEquals((double)2.0, (double)d.getLocation(), (double)Precision.EPSILON);
        Assert.assertEquals((double)5.0, (double)d.getScale(), (double)Precision.EPSILON);
    }

    @Test
    public void testSupport() {
        LogisticDistribution d = this.makeDistribution();
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportLowerBound()));
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportUpperBound()));
        Assert.assertTrue((boolean)d.isSupportConnected());
    }

    public LogisticDistribution makeDistribution() {
        return new LogisticDistribution(2.0, 5.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.03173698, 0.03557889, 0.03932239, 0.04278194, 0.04575685, 0.04805215, 0.04950331, 0.05, 0.04950331, 0.04805215, 0.04575685};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.1978161, 0.2314752, 0.2689414, 0.3100255, 0.3543437, 0.4013123, 0.450166, 0.5, 0.549834, 0.5986877, 0.6456563};
    }
}

