/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Expm1;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.RiddersSolver;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class RiddersSolverTest {
    @Test
    public void testSinFunction() {
        Sin f = new Sin();
        RiddersSolver solver = new RiddersSolver();
        double min = 3.0;
        double max = 4.0;
        double expected = Math.PI;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -1.0;
        max = 1.5;
        expected = 0.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        QuinticFunction f = new QuinticFunction();
        RiddersSolver solver = new RiddersSolver();
        double min = -0.4;
        double max = 0.2;
        double expected = 0.0;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = 0.75;
        max = 1.5;
        expected = 1.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -0.9;
        max = -0.2;
        expected = -0.5;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testExpm1Function() {
        Expm1 f = new Expm1();
        RiddersSolver solver = new RiddersSolver();
        double min = -1.0;
        double max = 2.0;
        double expected = 0.0;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -20.0;
        max = 10.0;
        expected = 0.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -50.0;
        max = 100.0;
        expected = 0.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testParameters() {
        Sin f = new Sin();
        RiddersSolver solver = new RiddersSolver();
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, -1.0);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad interval");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 2.0, 3.0);
            Assert.fail((String)"Expecting NoBracketingException - no bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
    }
}

