/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class LaguerreSolverTest {
    @Test
    public void testLinearFunction() {
        double[] coefficients = new double[]{-1.0, 4.0};
        PolynomialFunction f = new PolynomialFunction(coefficients);
        LaguerreSolver solver = new LaguerreSolver();
        double min = 0.0;
        double max = 1.0;
        double expected = 0.25;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuadraticFunction() {
        double[] coefficients = new double[]{-3.0, 5.0, 2.0};
        PolynomialFunction f = new PolynomialFunction(coefficients);
        LaguerreSolver solver = new LaguerreSolver();
        double min = 0.0;
        double max = 2.0;
        double expected = 0.5;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -4.0;
        max = -1.0;
        expected = -3.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        double[] coefficients = new double[]{-12.0, -1.0, 1.0, -12.0, -1.0, 1.0};
        PolynomialFunction f = new PolynomialFunction(coefficients);
        LaguerreSolver solver = new LaguerreSolver();
        double min = -2.0;
        double max = 2.0;
        double expected = -1.0;
        double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        double result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -5.0;
        max = -2.5;
        expected = -3.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = 3.0;
        max = 6.0;
        expected = 4.0;
        tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * solver.getRelativeAccuracy())));
        result = solver.solve(100, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuinticFunction2() {
        double[] coefficients = new double[]{4.0, 0.0, 1.0, 4.0, 0.0, 1.0};
        LaguerreSolver solver = new LaguerreSolver();
        Complex[] result = solver.solveAllComplex(coefficients, 0.0);
        for (Complex expected : new Complex[]{new Complex(0.0, -2.0), new Complex(0.0, 2.0), new Complex(0.5, 0.5 * FastMath.sqrt((double)3.0)), new Complex(-1.0, 0.0), new Complex(0.5, -0.5 * FastMath.sqrt((double)3.0))}) {
            double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected.abs() * solver.getRelativeAccuracy())));
            TestUtils.assertContains(result, expected, tolerance);
        }
    }

    @Test
    public void testParameters() {
        double[] coefficients = new double[]{-3.0, 5.0, 2.0};
        PolynomialFunction f = new PolynomialFunction(coefficients);
        LaguerreSolver solver = new LaguerreSolver();
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, -1.0);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad interval");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 2.0, 3.0);
            Assert.fail((String)"Expecting NoBracketingException - no bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
    }

    @Test(expected=NoDataException.class)
    public void testEmptyCoefficients() {
        double[] coefficients = new double[]{};
        LaguerreSolver solver = new LaguerreSolver();
        solver.solveComplex(coefficients, 0.0);
    }

    @Test(expected=NullArgumentException.class)
    public void testNullCoefficients() {
        LaguerreSolver solver = new LaguerreSolver();
        solver.solveComplex(null, 0.0);
    }

    @Test
    public void testTooManyEvaluations() {
        double[] coefficients = new double[]{1.0, 0.0, 0.0, 1.0};
        double tol = 1.0E-12;
        LaguerreSolver solver = new LaguerreSolver(1.0E-12);
        Complex[] expected = new Complex[]{new Complex(0.5, FastMath.sqrt((double)3.0) / 2.0), new Complex(-1.0, 0.0), new Complex(0.5, -FastMath.sqrt((double)3.0) / 2.0)};
        Complex[] roots = solver.solveAllComplex(coefficients, 0.0);
        for (Complex expectedRoot : expected) {
            double tolerance = FastMath.max((double)solver.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expectedRoot.abs() * solver.getRelativeAccuracy())));
            TestUtils.assertContains(roots, expectedRoot, tolerance);
        }
        try {
            solver.solveAllComplex(coefficients, 1000.0, 2);
            Assert.fail((String)"Expecting TooManyEvaluationsException");
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }
}

