/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.FunctionUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MonitoredFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Constant;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Inverse;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sqrt;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.BrentSolver;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.junit.Assert;
import org.junit.Test;

public final class BrentSolverTest {
    @Test
    public void testSinZero() {
        Sin f = new Sin();
        BrentSolver solver = new BrentSolver();
        double result = solver.solve(100, (UnivariateFunction)f, 3.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 7 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 1.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 8 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticZero() {
        QuinticFunction f = new QuinticFunction();
        BrentSolver solver = new BrentSolver();
        double result = solver.solve(100, (UnivariateFunction)f, -0.2, 0.2);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 3 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, -0.1, 0.3);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 7 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, -0.3, 0.45);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 8 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.3, 0.7);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 9 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.2, 0.6);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 10 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.05, 0.95);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 11 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 1.25);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 11 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.8, 1.2);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 11 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 1.75);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 13 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.55, 1.45);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 10 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 5.0);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 15 ? 1 : 0) != 0);
        try {
            result = solver.solve(5, (UnivariateFunction)f, 0.85, 5.0);
            Assert.fail((String)"Expected TooManyEvaluationsException");
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testRootEndpoints() {
        Sin f = new Sin();
        BrentSolver solver = new BrentSolver();
        double result = solver.solve(100, (UnivariateFunction)f, Math.PI, 4.0);
        Assert.assertEquals((double)Math.PI, (double)result, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 3.0, Math.PI);
        Assert.assertEquals((double)Math.PI, (double)result, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, Math.PI, 4.0, 3.5);
        Assert.assertEquals((double)Math.PI, (double)result, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 3.0, Math.PI, 3.07);
        Assert.assertEquals((double)Math.PI, (double)result, (double)solver.getAbsoluteAccuracy());
    }

    @Test
    public void testBadEndpoints() {
        Sin f = new Sin();
        BrentSolver solver = new BrentSolver();
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, -1.0);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad interval");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, 1.5);
            Assert.fail((String)"Expecting NoBracketingException - non-bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, 1.5, 1.2);
            Assert.fail((String)"Expecting NoBracketingException - non-bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
    }

    @Test
    public void testInitialGuess() {
        MonitoredFunction f = new MonitoredFunction((UnivariateFunction)new QuinticFunction());
        BrentSolver solver = new BrentSolver();
        double result = solver.solve(100, (UnivariateFunction)f, 0.6, 7.0);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        int referenceCallsCount = f.getCallsCount();
        Assert.assertTrue((referenceCallsCount >= 13 ? 1 : 0) != 0);
        try {
            result = solver.solve(100, (UnivariateFunction)f, 0.6, 7.0, 0.0);
            Assert.fail((String)"a NumberIsTooLargeException was expected");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        f.setCallsCount(0);
        result = solver.solve(100, (UnivariateFunction)f, 0.6, 7.0, 0.61);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((f.getCallsCount() > referenceCallsCount ? 1 : 0) != 0);
        f.setCallsCount(0);
        result = solver.solve(100, (UnivariateFunction)f, 0.6, 7.0, 0.999999);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((f.getCallsCount() < referenceCallsCount ? 1 : 0) != 0);
        f.setCallsCount(0);
        result = solver.solve(100, (UnivariateFunction)f, 0.6, 7.0, 1.0);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertEquals((long)1L, (long)solver.getEvaluations());
        Assert.assertEquals((long)1L, (long)f.getCallsCount());
    }

    @Test
    public void testMath832() {
        UnivariateFunction f = new UnivariateFunction(){
            private final UnivariateDifferentiableFunction sqrt = new Sqrt();
            private final UnivariateDifferentiableFunction inv = new Inverse();
            private final UnivariateDifferentiableFunction func = FunctionUtils.add((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Constant(100.0), this.sqrt}), FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Constant(1000000.0), this.inv}), FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Constant(10000.0), FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{this.inv, this.sqrt})})});

            public double value(double x) {
                return this.func.value(new DerivativeStructure(1, 1, 0, x)).getPartialDerivative(new int[]{1});
            }
        };
        BrentSolver solver = new BrentSolver();
        double result = solver.solve(99, f, 1.0, 1.0E30, 1.0000000001);
        Assert.assertEquals((double)804.9355825, (double)result, (double)1.0E-8);
    }
}

