/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.HarmonicOscillator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class HarmonicOscillatorTest {
    private final double EPS = Math.ulp(1.0);

    @Test
    public void testSomeValues() {
        double a = -1.2;
        double w = 0.34;
        double p = 5.6;
        HarmonicOscillator f = new HarmonicOscillator(-1.2, 0.34, 5.6);
        double d = 0.12345;
        for (int i = 0; i < 10; ++i) {
            double v = (double)i * 0.12345;
            Assert.assertEquals((double)(-1.2 * FastMath.cos((double)(0.34 * v + 5.6))), (double)f.value(v), (double)0.0);
        }
    }

    @Test
    public void testDerivative() {
        double a = -1.2;
        double w = 0.34;
        double p = 5.6;
        HarmonicOscillator f = new HarmonicOscillator(-1.2, 0.34, 5.6);
        for (int maxOrder = 0; maxOrder < 6; ++maxOrder) {
            double d = 0.12345;
            for (int i = 0; i < 10; ++i) {
                double v = (double)i * 0.12345;
                DerivativeStructure h = f.value(new DerivativeStructure(1, maxOrder, 0, v));
                for (int k = 0; k <= maxOrder; ++k) {
                    double trigo;
                    switch (k % 4) {
                        case 0: {
                            trigo = FastMath.cos((double)(0.34 * v + 5.6));
                            break;
                        }
                        case 1: {
                            trigo = -FastMath.sin((double)(0.34 * v + 5.6));
                            break;
                        }
                        case 2: {
                            trigo = -FastMath.cos((double)(0.34 * v + 5.6));
                            break;
                        }
                        default: {
                            trigo = FastMath.sin((double)(0.34 * v + 5.6));
                        }
                    }
                    Assert.assertEquals((double)(-1.2 * FastMath.pow((double)0.34, (int)k) * trigo), (double)h.getPartialDerivative(new int[]{k}), (double)Precision.EPSILON);
                }
            }
        }
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage1() {
        HarmonicOscillator.Parametric g = new HarmonicOscillator.Parametric();
        g.value(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage2() {
        HarmonicOscillator.Parametric g = new HarmonicOscillator.Parametric();
        g.value(0.0, new double[]{0.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage3() {
        HarmonicOscillator.Parametric g = new HarmonicOscillator.Parametric();
        g.gradient(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage4() {
        HarmonicOscillator.Parametric g = new HarmonicOscillator.Parametric();
        g.gradient(0.0, new double[]{0.0});
    }

    @Test
    public void testParametricValue() {
        double amplitude = 2.0;
        double omega = 3.0;
        double phase = 4.0;
        HarmonicOscillator f = new HarmonicOscillator(2.0, 3.0, 4.0);
        HarmonicOscillator.Parametric g = new HarmonicOscillator.Parametric();
        Assert.assertEquals((double)f.value(-1.0), (double)g.value(-1.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
        Assert.assertEquals((double)f.value(0.0), (double)g.value(0.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
        Assert.assertEquals((double)f.value(2.0), (double)g.value(2.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
    }

    @Test
    public void testParametricGradient() {
        double amplitude = 2.0;
        double omega = 3.0;
        double phase = 4.0;
        HarmonicOscillator.Parametric f = new HarmonicOscillator.Parametric();
        double x = 1.0;
        double[] grad = f.gradient(1.0, new double[]{2.0, 3.0, 4.0});
        double xTimesOmegaPlusPhase = 7.0;
        double a = FastMath.cos((double)7.0);
        Assert.assertEquals((double)a, (double)grad[0], (double)this.EPS);
        double w = -2.0 * FastMath.sin((double)7.0);
        Assert.assertEquals((double)w, (double)grad[1], (double)this.EPS);
        double p = -2.0 * FastMath.sin((double)7.0);
        Assert.assertEquals((double)p, (double)grad[2], (double)this.EPS);
    }
}

