/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinc;

public class SumSincFunction
implements MultivariateFunction {
    private static final UnivariateFunction sinc = new Sinc();
    private final double factor;

    public SumSincFunction(double factor) {
        this.factor = factor;
    }

    public double value(double[] point) {
        double sum = 0.0;
        for (double x : point) {
            double v = sinc.value(x);
            sum += v;
        }
        return this.factor * sum;
    }
}

