/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.binary;

import com.hazelcast.shaded.org.apache.commons.codec.binary.BaseNCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BaseNCodecTest {
    BaseNCodec codec;

    BaseNCodecTest() {
    }

    private static void assertEnsureBufferSizeExpandsToMaxBufferSize(boolean exceedMaxBufferSize) {
        boolean length = false;
        long presumableFreeMemory = BaseNCodecTest.getPresumableFreeMemory();
        long estimatedMemory = 0x80008000L;
        Assumptions.assumeTrue((presumableFreeMemory > 0x80008000L ? 1 : 0) != 0, (String)"Not enough free memory for the test");
        int max = 0x7FFFFFF7;
        if (exceedMaxBufferSize) {
            BaseNCodecTest.assumeCanAllocateBufferSize(0x7FFFFFF8);
            System.gc();
        }
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        context.buffer = new byte[0];
        context.pos = 0;
        int extra = 0x7FFFFFF7;
        if (exceedMaxBufferSize) {
            ++extra;
        }
        ncodec.ensureBufferSize(extra, context);
        Assertions.assertTrue((context.buffer.length >= 0 + extra ? 1 : 0) != 0);
    }

    private static void assumeCanAllocateBufferSize(int size) {
        byte[] bytes = null;
        try {
            bytes = new byte[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Assumptions.assumeTrue((bytes != null ? 1 : 0) != 0, (String)("Cannot allocate array of size: " + size));
    }

    static long getPresumableFreeMemory() {
        System.gc();
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return Runtime.getRuntime().maxMemory() - allocatedMemory;
    }

    @BeforeEach
    public void setUp() {
        this.codec = new BaseNCodec(0, 0, 0, 0){

            void decode(byte[] array, int i, int length, BaseNCodec.Context context) {
            }

            void encode(byte[] array, int i, int length, BaseNCodec.Context context) {
            }

            protected boolean isInAlphabet(byte b) {
                return b == 79 || b == 75;
            }
        };
    }

    @Test
    void testBaseNCodec() {
        Assertions.assertNotNull((Object)this.codec);
    }

    @Test
    void testContainsAlphabetOrPad() {
        Assertions.assertFalse((boolean)this.codec.containsAlphabetOrPad(null));
        Assertions.assertFalse((boolean)this.codec.containsAlphabetOrPad(new byte[0]));
        Assertions.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK".getBytes()));
        Assertions.assertTrue((boolean)this.codec.containsAlphabetOrPad("OK ".getBytes()));
        Assertions.assertFalse((boolean)this.codec.containsAlphabetOrPad("ok ".getBytes()));
        Assertions.assertTrue((boolean)this.codec.containsAlphabetOrPad(new byte[]{this.codec.pad}));
    }

    @Test
    void testContextToString() {
        BaseNCodec.Context context = new BaseNCodec.Context();
        context.buffer = new byte[3];
        context.currentLinePos = 13;
        context.eof = true;
        context.ibitWorkArea = 777;
        context.lbitWorkArea = 999L;
        context.modulus = 5;
        context.pos = 42;
        context.readPos = 981;
        String text = context.toString();
        Assertions.assertTrue((boolean)text.contains("[0, 0, 0]"));
        Assertions.assertTrue((boolean)text.contains("13"));
        Assertions.assertTrue((boolean)text.contains("true"));
        Assertions.assertTrue((boolean)text.contains("777"));
        Assertions.assertTrue((boolean)text.contains("999"));
        Assertions.assertTrue((boolean)text.contains("5"));
        Assertions.assertTrue((boolean)text.contains("42"));
        Assertions.assertTrue((boolean)text.contains("981"));
    }

    @Test
    void testEnsureBufferSize() {
        int length;
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        Assertions.assertNull((Object)context.buffer, (String)"Initial buffer should be null");
        context.pos = 76979;
        context.readPos = 273;
        ncodec.ensureBufferSize(0, context);
        Assertions.assertNotNull((Object)context.buffer, (String)"buffer should be initialized");
        Assertions.assertEquals((int)ncodec.getDefaultBufferSize(), (int)context.buffer.length, (String)"buffer should be initialized to default size");
        Assertions.assertEquals((int)0, (int)context.pos, (String)"context position");
        Assertions.assertEquals((int)0, (int)context.readPos, (String)"context read position");
        ncodec.ensureBufferSize(1, context);
        Assertions.assertEquals((int)ncodec.getDefaultBufferSize(), (int)context.buffer.length, (String)"buffer should not expand unless required");
        context.pos = length = context.buffer.length;
        int extra = 1;
        ncodec.ensureBufferSize(extra, context);
        Assertions.assertTrue((context.buffer.length >= length + extra ? 1 : 0) != 0, (String)"buffer should expand");
        context.pos = length = context.buffer.length;
        extra = length * 10;
        ncodec.ensureBufferSize(extra, context);
        Assertions.assertTrue((context.buffer.length >= length + extra ? 1 : 0) != 0, (String)"buffer should expand beyond double capacity");
    }

    @Test
    void testEnsureBufferSizeExpandsToBeyondMaxBufferSize() {
        BaseNCodecTest.assertEnsureBufferSizeExpandsToMaxBufferSize(true);
    }

    @Test
    void testEnsureBufferSizeExpandsToMaxBufferSize() {
        BaseNCodecTest.assertEnsureBufferSizeExpandsToMaxBufferSize(false);
    }

    @Test
    void testEnsureBufferSizeThrowsOnOverflow() {
        NoOpBaseNCodec ncodec = new NoOpBaseNCodec();
        BaseNCodec.Context context = new BaseNCodec.Context();
        int length = 10;
        context.buffer = new byte[10];
        context.pos = 10;
        int extra = Integer.MAX_VALUE;
        Assertions.assertThrows(OutOfMemoryError.class, () -> ncodec.ensureBufferSize(Integer.MAX_VALUE, context));
    }

    @Test
    void testIsInAlphabetByte() {
        Assertions.assertFalse((boolean)this.codec.isInAlphabet((byte)0));
        Assertions.assertFalse((boolean)this.codec.isInAlphabet((byte)97));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet((byte)79));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet((byte)75));
    }

    @Test
    void testIsInAlphabetByteArrayBoolean() {
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], false));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, false));
        Assertions.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, false));
        Assertions.assertFalse((boolean)this.codec.isInAlphabet(new byte[]{32}, false));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[0], true));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79}, true));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{79, 32}, true));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet(new byte[]{32}, true));
    }

    @Test
    void testIsInAlphabetString() {
        Assertions.assertTrue((boolean)this.codec.isInAlphabet("OK"));
        Assertions.assertTrue((boolean)this.codec.isInAlphabet("O=K= \t\n\r"));
    }

    @Test
    void testIsWhiteSpace() {
        Assertions.assertTrue((boolean)Character.isWhitespace(32));
        Assertions.assertTrue((boolean)Character.isWhitespace(10));
        Assertions.assertTrue((boolean)Character.isWhitespace(13));
        Assertions.assertTrue((boolean)Character.isWhitespace(9));
        Assertions.assertTrue((boolean)Character.isWhitespace(12));
        Assertions.assertTrue((boolean)Character.isWhitespace(11));
        for (int b = -128; b < 127; b = (int)((byte)(b + 1))) {
            int byteToCheck = b;
            Assertions.assertEquals((Object)Character.isWhitespace(b), (Object)Character.isWhitespace(byteToCheck));
        }
    }

    @Test
    void testProvidePaddingByte() {
        this.codec = new BaseNCodec(0, 0, 0, 0, 37){

            void decode(byte[] array, int i, int length, BaseNCodec.Context context) {
            }

            void encode(byte[] array, int i, int length, BaseNCodec.Context context) {
            }

            protected boolean isInAlphabet(byte b) {
                return b == 79 || b == 75;
            }
        };
        byte actualPaddingByte = this.codec.pad;
        Assertions.assertEquals((int)37, (int)actualPaddingByte);
    }

    private static final class NoOpBaseNCodec
    extends BaseNCodec {
        NoOpBaseNCodec() {
            super(0, 0, 0, 0);
        }

        void decode(byte[] array, int i, int length, BaseNCodec.Context context) {
        }

        void encode(byte[] array, int i, int length, BaseNCodec.Context context) {
        }

        protected boolean isInAlphabet(byte value) {
            return false;
        }
    }
}

