/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastTypeUtilsTest {
    @Test
    public void testHazelcastToCalcite() {
        Assert.assertSame((Object)SqlTypeName.VARCHAR, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.VARCHAR));
        Assert.assertSame((Object)SqlTypeName.BOOLEAN, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.BOOLEAN));
        Assert.assertSame((Object)SqlTypeName.TINYINT, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.TINYINT));
        Assert.assertSame((Object)SqlTypeName.SMALLINT, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.SMALLINT));
        Assert.assertSame((Object)SqlTypeName.INTEGER, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.INT));
        Assert.assertSame((Object)SqlTypeName.BIGINT, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.BIGINT));
        Assert.assertSame((Object)SqlTypeName.DECIMAL, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.DECIMAL));
        Assert.assertSame((Object)SqlTypeName.REAL, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.REAL));
        Assert.assertSame((Object)SqlTypeName.DOUBLE, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.DOUBLE));
        Assert.assertSame((Object)SqlTypeName.DATE, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.DATE));
        Assert.assertSame((Object)SqlTypeName.TIME, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.TIME));
        Assert.assertSame((Object)SqlTypeName.TIMESTAMP, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.TIMESTAMP));
        Assert.assertSame((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Object)HazelcastTypeUtils.toCalciteType((QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME));
    }

    @Test
    public void testCalciteToHazelcast() {
        Assert.assertSame((Object)QueryDataType.JSON, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)HazelcastJsonType.TYPE));
        Assert.assertSame((Object)QueryDataType.JSON, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)HazelcastJsonType.TYPE_NULLABLE));
        Assert.assertSame((Object)QueryDataType.VARCHAR, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.VARCHAR)));
        Assert.assertSame((Object)QueryDataType.BOOLEAN, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.BOOLEAN)));
        Assert.assertSame((Object)QueryDataType.TINYINT, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.TINYINT)));
        Assert.assertSame((Object)QueryDataType.SMALLINT, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.SMALLINT)));
        Assert.assertSame((Object)QueryDataType.INT, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.INTEGER)));
        Assert.assertSame((Object)QueryDataType.BIGINT, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.BIGINT)));
        Assert.assertSame((Object)QueryDataType.DECIMAL, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.DECIMAL)));
        Assert.assertSame((Object)QueryDataType.REAL, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.REAL)));
        Assert.assertSame((Object)QueryDataType.DOUBLE, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.DOUBLE)));
        Assert.assertSame((Object)QueryDataType.DATE, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.DATE)));
        Assert.assertSame((Object)QueryDataType.TIME, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.TIME)));
        Assert.assertSame((Object)QueryDataType.TIMESTAMP, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.TIMESTAMP)));
        Assert.assertSame((Object)QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, (Object)HazelcastTypeUtils.toHazelcastType((RelDataType)this.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)));
    }

    private RelDataType type(SqlTypeName typeName) {
        return HazelcastTypeFactory.INSTANCE.createSqlType(typeName);
    }
}

