/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelJVMTest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={NightlyTest.class, ParallelJVMTest.class})
public class RowAssignmentTypeCoercionTest
extends SqlTestSupport {
    private static final LocalDate TODAY = LocalDate.now();
    private static final LocalDate TOMORROW = TODAY.plusDays(1L);
    @Parameterized.Parameter
    public TestParams testParams;
    private final SqlService sqlService = RowAssignmentTypeCoercionTest.instance().getSql();

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{TestParams.passingCase(1001, QueryDataTypeFamily.NULL, QueryDataTypeFamily.VARCHAR, "null", null, new Object[]{null}), TestParams.passingCase(1002, QueryDataTypeFamily.NULL, QueryDataTypeFamily.BOOLEAN, "null", null, new Object[]{null}), TestParams.passingCase(1003, QueryDataTypeFamily.NULL, QueryDataTypeFamily.TINYINT, "null", null, new Object[]{null}), TestParams.passingCase(1004, QueryDataTypeFamily.NULL, QueryDataTypeFamily.SMALLINT, "null", null, new Object[]{null}), TestParams.passingCase(1005, QueryDataTypeFamily.NULL, QueryDataTypeFamily.INTEGER, "null", null, new Object[]{null}), TestParams.passingCase(1006, QueryDataTypeFamily.NULL, QueryDataTypeFamily.BIGINT, "null", null, new Object[]{null}), TestParams.passingCase(1007, QueryDataTypeFamily.NULL, QueryDataTypeFamily.DECIMAL, "null", null, new Object[]{null}), TestParams.passingCase(1008, QueryDataTypeFamily.NULL, QueryDataTypeFamily.REAL, "null", null, new Object[]{null}), TestParams.passingCase(1009, QueryDataTypeFamily.NULL, QueryDataTypeFamily.DOUBLE, "null", null, new Object[]{null}), TestParams.passingCase(1010, QueryDataTypeFamily.NULL, QueryDataTypeFamily.TIME, "null", null, new Object[]{null}), TestParams.passingCase(1011, QueryDataTypeFamily.NULL, QueryDataTypeFamily.DATE, "null", null, new Object[]{null}), TestParams.passingCase(1012, QueryDataTypeFamily.NULL, QueryDataTypeFamily.TIMESTAMP, "null", null, new Object[]{null}), TestParams.passingCase(1013, QueryDataTypeFamily.NULL, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, null, null, new Object[]{null}), TestParams.passingCase(1014, QueryDataTypeFamily.NULL, QueryDataTypeFamily.OBJECT, "null", null, new Object[]{null}), TestParams.passingCase(1101, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.VARCHAR, "'foo'", "foo", "foo"), TestParams.failingCase(1102, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BOOLEAN, "'true'", "true").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but VARCHAR was found"), TestParams.failingCase(1103, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, "'42'", "42").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but VARCHAR was found"), TestParams.failingCase(1104, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, "'420'", "420").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but VARCHAR was found"), TestParams.failingCase(1105, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but VARCHAR was found"), TestParams.failingCase(1106, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.SMALLINT, "'42'", "42").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but VARCHAR was found"), TestParams.failingCase(1107, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.SMALLINT, "'42000'", "42000").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but VARCHAR was found"), TestParams.failingCase(1108, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.SMALLINT, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but VARCHAR was found"), TestParams.failingCase(1109, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER, "'42'", "42").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but VARCHAR was found"), TestParams.failingCase(1110, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER, "'4200000000'", "4200000000").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but VARCHAR was found"), TestParams.failingCase(1111, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but VARCHAR was found"), TestParams.failingCase(1112, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BIGINT, "'42'", "42").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but VARCHAR was found"), TestParams.failingCase(1113, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BIGINT, "'9223372036854775808000'", "9223372036854775808000").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but VARCHAR was found"), TestParams.failingCase(1114, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BIGINT, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but VARCHAR was found"), TestParams.failingCase(1115, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DECIMAL, "'1.5'", "1.5").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but VARCHAR was found"), TestParams.failingCase(1116, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DECIMAL, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but VARCHAR was found"), TestParams.failingCase(1117, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.REAL, "'1.5'", "1.5").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but VARCHAR was found"), TestParams.failingCase(1118, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.REAL, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but VARCHAR was found"), TestParams.failingCase(1119, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DOUBLE, "'1.5'", "1.5").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but VARCHAR was found"), TestParams.failingCase(1120, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DOUBLE, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type VARCHAR").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but VARCHAR was found"), TestParams.passingCase(1121, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, "'01:42:01'", "01:42:01", LocalTime.of(1, 42, 1)).withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but VARCHAR was found"), TestParams.failingCase(1122, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot parse VARCHAR value to TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but VARCHAR was found"), TestParams.passingCase(1123, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DATE, "'2020-12-30'", "2020-12-30", LocalDate.of(2020, 12, 30)).withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but VARCHAR was found"), TestParams.failingCase(1124, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.DATE, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot parse VARCHAR value to DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but VARCHAR was found").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type VARCHAR"), TestParams.passingCase(1125, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP, "'2020-12-30T01:42:00'", "2020-12-30T01:42:00", LocalDateTime.of(2020, 12, 30, 1, 42)).withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but VARCHAR was found"), TestParams.failingCase(1126, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot parse VARCHAR value to TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but VARCHAR was found"), TestParams.passingCase(1127, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "'2020-12-30T01:42:00-05:00'", "2020-12-30T01:42:00-05:00", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but VARCHAR was found"), TestParams.failingCase(1128, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "'foo'", "foo").withExpectedLiteralFailureRegex("Cannot parse VARCHAR value to TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type VARCHAR").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but VARCHAR was found"), TestParams.passingCase(1129, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.OBJECT, "'foo'", "foo", "foo"), TestParams.passingCase(1130, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.JSON, "'foo'", "foo", new HazelcastJsonValue("foo")), TestParams.failingCase(1201, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.VARCHAR, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but BOOLEAN was found"), TestParams.passingCase(1202, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.BOOLEAN, "true", true, true), TestParams.failingCase(1203, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but BOOLEAN was found"), TestParams.failingCase(1204, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.SMALLINT, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but BOOLEAN was found"), TestParams.failingCase(1205, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.INTEGER, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but BOOLEAN was found"), TestParams.failingCase(1206, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.BIGINT, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but BOOLEAN was found"), TestParams.failingCase(1207, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.DECIMAL, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but BOOLEAN was found"), TestParams.failingCase(1208, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.REAL, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but BOOLEAN was found"), TestParams.failingCase(1209, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.DOUBLE, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but BOOLEAN was found"), TestParams.failingCase(1210, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TIME, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but BOOLEAN was found"), TestParams.failingCase(1211, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.DATE, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but BOOLEAN was found"), TestParams.failingCase(1212, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TIMESTAMP, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but BOOLEAN was found"), TestParams.failingCase(1213, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but BOOLEAN was found"), TestParams.passingCase(1214, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.OBJECT, "true", true, true), TestParams.failingCase(1215, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.JSON, "true", true).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '(EXPR\\$\\d|v)' of type BOOLEAN").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but BOOLEAN was found"), TestParams.failingCase(1301, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.VARCHAR, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but TINYINT was found"), TestParams.failingCase(1302, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.BOOLEAN, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but TINYINT was found"), TestParams.passingCase(1303, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.TINYINT, "cast(42 as tinyint)", (byte)42, (byte)42), TestParams.passingCase(1304, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, "cast(42 as tinyint)", (byte)42, (short)42), TestParams.passingCase(1305, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.INTEGER, "cast(42 as tinyint)", (byte)42, 42), TestParams.passingCase(1306, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.BIGINT, "cast(42 as tinyint)", (byte)42, 42L), TestParams.passingCase(1307, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.DECIMAL, "cast(42 as tinyint)", (byte)42, BigDecimal.valueOf(42L)), TestParams.passingCase(1308, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.REAL, "cast(42 as tinyint)", (byte)42, Float.valueOf(42.0f)), TestParams.passingCase(1309, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.DOUBLE, "cast(42 as tinyint)", (byte)42, 42.0), TestParams.failingCase(1310, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.TIME, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but TINYINT was found"), TestParams.failingCase(1311, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.DATE, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but TINYINT was found"), TestParams.failingCase(1312, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.TIMESTAMP, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but TINYINT was found"), TestParams.failingCase(1313, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but TINYINT was found"), TestParams.passingCase(1314, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.OBJECT, "cast(42 as tinyint)", (byte)42, (byte)42), TestParams.failingCase(1315, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.JSON, "cast(42 as tinyint)", (byte)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TINYINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but TINYINT was found"), TestParams.failingCase(1401, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.VARCHAR, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but SMALLINT was found"), TestParams.failingCase(1402, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.BOOLEAN, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but SMALLINT was found"), TestParams.passingCase(1403, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.TINYINT, "cast(42 as smallint)", (short)42, (byte)42), TestParams.failingCase(1404, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.TINYINT, "420", (short)420).withExpectedFailureRegex("Numeric overflow while converting SMALLINT to TINYINT"), TestParams.passingCase(1405, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.SMALLINT, "cast(42 as smallint)", (short)42, (short)42), TestParams.passingCase(1406, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, "cast(42 as smallint)", (short)42, 42), TestParams.passingCase(1407, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.BIGINT, "cast(42 as smallint)", (short)42, 42L), TestParams.passingCase(1408, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.DECIMAL, "cast(42 as smallint)", (short)42, BigDecimal.valueOf(42L)), TestParams.passingCase(1409, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.REAL, "cast(42 as smallint)", (short)42, Float.valueOf(42.0f)), TestParams.passingCase(1410, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.DOUBLE, "cast(42 as smallint)", (short)42, 42.0), TestParams.failingCase(1411, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.TIME, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but SMALLINT was found"), TestParams.failingCase(1412, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.DATE, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but SMALLINT was found"), TestParams.failingCase(1413, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.TIMESTAMP, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but SMALLINT was found"), TestParams.failingCase(1414, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but SMALLINT was found"), TestParams.passingCase(1415, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.OBJECT, "cast(42 as smallint)", (short)42, (short)42), TestParams.failingCase(1416, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.JSON, "cast(42 as smallint)", (short)42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type SMALLINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but SMALLINT was found"), TestParams.failingCase(1501, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but INTEGER was found"), TestParams.failingCase(1502, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BOOLEAN, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but INTEGER was found"), TestParams.passingCase(1503, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TINYINT, "cast(42 as integer)", 42, (byte)42), TestParams.failingCase(1504, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TINYINT, "42000", 42000).withExpectedFailureRegex("Numeric overflow while converting INTEGER to TINYINT"), TestParams.passingCase(1505, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.SMALLINT, "cast(42 as integer)", 42, (short)42), TestParams.failingCase(1506, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.SMALLINT, "42000", 42000).withExpectedFailureRegex("Numeric overflow while converting INTEGER to SMALLINT"), TestParams.passingCase(1507, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.INTEGER, "cast(42 as integer)", 42, 42), TestParams.passingCase(1508, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, "cast(42 as integer)", 42, 42L), TestParams.passingCase(1509, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.DECIMAL, "cast(42 as integer)", 42, BigDecimal.valueOf(42L)), TestParams.passingCase(1510, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.REAL, "cast(42 as integer)", 42, Float.valueOf(42.0f)), TestParams.passingCase(1511, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.DOUBLE, "cast(42 as integer)", 42, 42.0), TestParams.failingCase(1512, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIME, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but INTEGER was found"), TestParams.failingCase(1513, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.DATE, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but INTEGER was found"), TestParams.failingCase(1514, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but INTEGER was found"), TestParams.failingCase(1515, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but INTEGER was found"), TestParams.passingCase(1516, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.OBJECT, "cast(42 as integer)", 42, 42), TestParams.failingCase(1517, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.JSON, "cast(42 as integer)", 42).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type INTEGER").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but INTEGER was found"), TestParams.failingCase(1601, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.VARCHAR, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but BIGINT was found"), TestParams.failingCase(1602, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.BOOLEAN, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but BIGINT was found"), TestParams.passingCase(1603, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.TINYINT, "cast(42 as bigint)", 42L, (byte)42), TestParams.failingCase(1604, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.TINYINT, "4200000000", 4200000000L).withExpectedFailureRegex("Numeric overflow while converting BIGINT to TINYINT"), TestParams.passingCase(1605, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.SMALLINT, "cast(42 as bigint)", 42L, (short)42), TestParams.failingCase(1606, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.SMALLINT, "4200000000", 4200000000L).withExpectedFailureRegex("Numeric overflow while converting BIGINT to SMALLINT"), TestParams.passingCase(1607, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.INTEGER, "cast(42 as bigint)", 42L, 42), TestParams.failingCase(1608, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.INTEGER, "4200000000", 4200000000L).withExpectedFailureRegex("Numeric overflow while converting BIGINT to INTEGER"), TestParams.passingCase(1609, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.BIGINT, "cast(42 as bigint)", 42L, 42L), TestParams.passingCase(1610, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, "cast(42 as bigint)", 42L, BigDecimal.valueOf(42L)), TestParams.passingCase(1611, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.REAL, "cast(42 as bigint)", 42L, Float.valueOf(42.0f)), TestParams.passingCase(1612, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DOUBLE, "cast(42 as bigint)", 42L, 42.0), TestParams.failingCase(1613, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.TIME, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but BIGINT was found"), TestParams.failingCase(1614, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DATE, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but BIGINT was found"), TestParams.failingCase(1615, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.TIMESTAMP, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but BIGINT was found"), TestParams.failingCase(1616, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but BIGINT was found"), TestParams.passingCase(1617, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.OBJECT, "cast(42 as bigint)", 42L, 42L), TestParams.failingCase(1618, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.JSON, "cast(42 as bigint)", 42L).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type BIGINT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but BIGINT was found"), TestParams.failingCase(1701, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.VARCHAR, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but DECIMAL was found"), TestParams.failingCase(1702, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.BOOLEAN, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but DECIMAL was found"), TestParams.passingCase(1703, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.TINYINT, "cast(42 as decimal)", new BigDecimal("42"), (byte)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but DECIMAL was found"), TestParams.failingCase(1704, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.TINYINT, "9223372036854775809", new BigDecimal("9223372036854775809")).withExpectedLiteralFailureRegex("Numeric overflow while converting DECIMAL to TINYINT").withExpectedColumnFailureRegex("Numeric overflow while converting DECIMAL to TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but DECIMAL was found"), TestParams.passingCase(1705, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.SMALLINT, "cast(42 as decimal)", new BigDecimal("42"), (short)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but DECIMAL was found"), TestParams.failingCase(1706, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.SMALLINT, "9223372036854775809", new BigDecimal("9223372036854775809")).withExpectedLiteralFailureRegex("Numeric overflow while converting DECIMAL to SMALLINT").withExpectedColumnFailureRegex("Numeric overflow while converting DECIMAL to SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but DECIMAL was found"), TestParams.passingCase(1707, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.INTEGER, "cast(42 as decimal)", new BigDecimal("42"), 42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but DECIMAL was found"), TestParams.failingCase(1708, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.INTEGER, "9223372036854775809", new BigDecimal("9223372036854775809")).withExpectedLiteralFailureRegex("Numeric overflow while converting DECIMAL to INTEGER").withExpectedColumnFailureRegex("Numeric overflow while converting DECIMAL to INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but DECIMAL was found"), TestParams.passingCase(1709, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.BIGINT, "cast(42 as decimal)", new BigDecimal("42"), 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DECIMAL was found"), TestParams.passingCase(1710, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.BIGINT, "cast(42.1 as decimal)", new BigDecimal("42.1"), 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DECIMAL was found"), TestParams.failingCase(1711, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.BIGINT, "9223372036854775809", new BigDecimal("9223372036854775809")).withExpectedLiteralFailureRegex("Numeric overflow while converting DECIMAL to BIGINT").withExpectedColumnFailureRegex("Numeric overflow while converting DECIMAL to BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DECIMAL was found"), TestParams.passingCase(1712, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.DECIMAL, "cast(42 as decimal)", new BigDecimal("42"), BigDecimal.valueOf(42L)), TestParams.passingCase(1713, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, "cast(42 as decimal)", new BigDecimal("42"), Float.valueOf(42.0f)), TestParams.passingCase(1714, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.DOUBLE, "cast(42 as decimal)", new BigDecimal("42"), 42.0), TestParams.failingCase(1715, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.TIME, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DECIMAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DECIMAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but DECIMAL was found"), TestParams.failingCase(1716, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.DATE, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type DECIMAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type DECIMAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but DECIMAL was found"), TestParams.failingCase(1717, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.TIMESTAMP, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but DECIMAL was found"), TestParams.failingCase(1718, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type DECIMAL\\(76, 38\\)").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but DECIMAL was found"), TestParams.passingCase(1719, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.OBJECT, "cast(42 as decimal)", new BigDecimal("42"), BigDecimal.valueOf(42L)), TestParams.failingCase(1720, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.JSON, "cast(42 as decimal)", new BigDecimal("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DECIMAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DECIMAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but DECIMAL was found"), TestParams.failingCase(1801, QueryDataTypeFamily.REAL, QueryDataTypeFamily.VARCHAR, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but REAL was found"), TestParams.failingCase(1802, QueryDataTypeFamily.REAL, QueryDataTypeFamily.BOOLEAN, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but REAL was found"), TestParams.passingCase(1803, QueryDataTypeFamily.REAL, QueryDataTypeFamily.TINYINT, "cast(42 as real)", Float.valueOf(42.0f), (byte)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but REAL was found"), TestParams.failingCase(1804, QueryDataTypeFamily.REAL, QueryDataTypeFamily.TINYINT, "cast(420 as real)", Float.valueOf(420.0f)).withExpectedLiteralFailureRegex("Numeric overflow while converting REAL to TINYINT").withExpectedColumnFailureRegex("Numeric overflow while converting REAL to TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but REAL was found"), TestParams.passingCase(1805, QueryDataTypeFamily.REAL, QueryDataTypeFamily.SMALLINT, "cast(42 as real)", Float.valueOf(42.0f), (short)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but REAL was found"), TestParams.failingCase(1806, QueryDataTypeFamily.REAL, QueryDataTypeFamily.SMALLINT, "cast(420000 as real)", Float.valueOf(420000.0f)).withExpectedLiteralFailureRegex("Numeric overflow while converting REAL to SMALLINT").withExpectedColumnFailureRegex("Numeric overflow while converting REAL to SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but REAL was found"), TestParams.passingCase(1807, QueryDataTypeFamily.REAL, QueryDataTypeFamily.INTEGER, "cast(42 as real)", Float.valueOf(42.0f), 42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but REAL was found"), TestParams.failingCase(1808, QueryDataTypeFamily.REAL, QueryDataTypeFamily.INTEGER, "cast(4200000000 as real)", Float.valueOf(4.2E9f)).withExpectedLiteralFailureRegex("Numeric overflow while converting REAL to INTEGER").withExpectedColumnFailureRegex("Numeric overflow while converting REAL to INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but REAL was found"), TestParams.passingCase(1809, QueryDataTypeFamily.REAL, QueryDataTypeFamily.BIGINT, "cast(42 as real)", Float.valueOf(42.0f), 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but REAL was found"), TestParams.passingCase(1810, QueryDataTypeFamily.REAL, QueryDataTypeFamily.BIGINT, "cast(42.1 as real)", Float.valueOf(42.1f), 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but REAL was found").withExpectedLiteralFailureRegex("For input string: \"42.1\""), TestParams.failingCase(1811, QueryDataTypeFamily.REAL, QueryDataTypeFamily.BIGINT, "cast(18223372036854775808000 as real)", Float.valueOf(1.8223372E22f)).withExpectedLiteralFailureRegex("Numeric overflow while converting REAL to BIGINT").withExpectedColumnFailureRegex("Numeric overflow while converting REAL to BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but REAL was found"), TestParams.passingCase(1812, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DECIMAL, "cast(42 as real)", Float.valueOf(42.0f), BigDecimal.valueOf(42L)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but REAL was found"), TestParams.passingCase(1813, QueryDataTypeFamily.REAL, QueryDataTypeFamily.REAL, "cast(42 as real)", Float.valueOf(42.0f), Float.valueOf(42.0f)), TestParams.passingCase(1814, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, "cast(42 as real)", Float.valueOf(42.0f), 42.0), TestParams.failingCase(1815, QueryDataTypeFamily.REAL, QueryDataTypeFamily.TIME, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but REAL was found"), TestParams.failingCase(1816, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DATE, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but REAL was found"), TestParams.failingCase(1817, QueryDataTypeFamily.REAL, QueryDataTypeFamily.TIMESTAMP, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but REAL was found"), TestParams.failingCase(1818, QueryDataTypeFamily.REAL, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but REAL was found"), TestParams.passingCase(1819, QueryDataTypeFamily.REAL, QueryDataTypeFamily.OBJECT, "cast(42 as real)", Float.valueOf(42.0f), Float.valueOf(42.0f)), TestParams.failingCase(1820, QueryDataTypeFamily.REAL, QueryDataTypeFamily.JSON, "cast(42 as real)", Float.valueOf(42.0f)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type REAL").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but REAL was found"), TestParams.failingCase(1901, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.VARCHAR, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but DOUBLE was found"), TestParams.failingCase(1902, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.BOOLEAN, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but DOUBLE was found"), TestParams.passingCase(1903, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TINYINT, "cast(42 as double)", 42.0, (byte)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but DOUBLE was found"), TestParams.failingCase(1904, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TINYINT, "cast(420 as double)", 420.0).withExpectedLiteralFailureRegex("Numeric overflow while converting DOUBLE to TINYINT").withExpectedColumnFailureRegex("Numeric overflow while converting DOUBLE to TINYINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but DOUBLE was found"), TestParams.passingCase(1905, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.SMALLINT, "cast(42 as double)", 42.0, (short)42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but DOUBLE was found"), TestParams.failingCase(1906, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.SMALLINT, "cast(420000 as double)", 420000.0).withExpectedLiteralFailureRegex("Numeric overflow while converting DOUBLE to SMALLINT").withExpectedColumnFailureRegex("Numeric overflow while converting DOUBLE to SMALLINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but DOUBLE was found"), TestParams.passingCase(1907, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.INTEGER, "cast(42 as double)", 42.0, 42).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but DOUBLE was found"), TestParams.failingCase(1908, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.INTEGER, "cast(4200000000 as double)", 4.2E9).withExpectedLiteralFailureRegex("Numeric overflow while converting DOUBLE to INTEGER").withExpectedColumnFailureRegex("Numeric overflow while converting DOUBLE to INTEGER").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but DOUBLE was found"), TestParams.passingCase(1909, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.BIGINT, "cast(42 as double)", 42.0, 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DOUBLE was found"), TestParams.failingCase(1910, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.BIGINT, "cast(19223372036854775808000 as double)", 1.9223372036854776E22).withExpectedLiteralFailureRegex("Numeric overflow while converting DOUBLE to BIGINT").withExpectedColumnFailureRegex("Numeric overflow while converting DOUBLE to BIGINT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DOUBLE was found"), TestParams.passingCase(1911, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.DECIMAL, "cast(42 as double)", 42.0, BigDecimal.valueOf(42L)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but DOUBLE was found"), TestParams.passingCase(1912, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.REAL, "cast(42 as double)", 42.0, Float.valueOf(42.0f)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but DOUBLE was found"), TestParams.passingCase(1913, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.BIGINT, "cast(42.1 as double)", 42.1, 42L).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DOUBLE was found").withExpectedLiteralFailureRegex("For input string: \"42.1\""), TestParams.failingCase(1914, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.REAL, "cast(42e42 as double)", 4.2E43).withExpectedLiteralFailureRegex("Numeric overflow while converting DOUBLE to REAL").withExpectedColumnFailureRegex("Numeric overflow while converting DOUBLE to REAL").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but DOUBLE was found"), TestParams.passingCase(1915, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.DOUBLE, "cast(42 as double)", 42.0, 42.0), TestParams.failingCase(1916, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but DOUBLE was found"), TestParams.failingCase(1917, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.DATE, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but DOUBLE was found"), TestParams.failingCase(1918, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIMESTAMP, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but DOUBLE was found"), TestParams.failingCase(1919, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but DOUBLE was found"), TestParams.passingCase(1920, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT, "cast(42 as double)", 42.0, 42.0), TestParams.failingCase(1921, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.JSON, "cast(42 as double)", 42.0).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DOUBLE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DOUBLE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but DOUBLE was found"), TestParams.failingCase(2001, QueryDataTypeFamily.TIME, QueryDataTypeFamily.VARCHAR, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but TIME was found"), TestParams.failingCase(2002, QueryDataTypeFamily.TIME, QueryDataTypeFamily.BOOLEAN, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but TIME was found"), TestParams.failingCase(2003, QueryDataTypeFamily.TIME, QueryDataTypeFamily.TINYINT, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but TIME was found"), TestParams.failingCase(2004, QueryDataTypeFamily.TIME, QueryDataTypeFamily.SMALLINT, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but TIME was found"), TestParams.failingCase(2005, QueryDataTypeFamily.TIME, QueryDataTypeFamily.INTEGER, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but TIME was found"), TestParams.failingCase(2006, QueryDataTypeFamily.TIME, QueryDataTypeFamily.BIGINT, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but TIME was found"), TestParams.failingCase(2007, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DECIMAL, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but TIME was found"), TestParams.failingCase(2008, QueryDataTypeFamily.TIME, QueryDataTypeFamily.REAL, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but TIME was found"), TestParams.failingCase(2009, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DOUBLE, "cast('1:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but TIME was found"), TestParams.passingCase(2010, QueryDataTypeFamily.TIME, QueryDataTypeFamily.TIME, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0), LocalTime.of(1, 42)), TestParams.failingCase(2011, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but TIME was found"), TestParams.passingCase(2012, QueryDataTypeFamily.TIME, QueryDataTypeFamily.TIMESTAMP, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0), LocalDateTime.of(TODAY, LocalTime.of(1, 42)), LocalDateTime.of(TOMORROW, LocalTime.of(1, 42))), TestParams.passingCase(2013, QueryDataTypeFamily.TIME, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0), ZonedDateTime.of(LocalDateTime.of(TODAY, LocalTime.of(1, 42)), AbstractTemporalConverter.DEFAULT_ZONE).toOffsetDateTime(), ZonedDateTime.of(LocalDateTime.of(TOMORROW, LocalTime.of(1, 42)), AbstractTemporalConverter.DEFAULT_ZONE).toOffsetDateTime()), TestParams.passingCase(2014, QueryDataTypeFamily.TIME, QueryDataTypeFamily.OBJECT, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0), LocalTime.of(1, 42)), TestParams.failingCase(2015, QueryDataTypeFamily.TIME, QueryDataTypeFamily.JSON, "cast('01:42:00' as time)", LocalTime.of(1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIME").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIME").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but TIME was found"), TestParams.failingCase(2101, QueryDataTypeFamily.DATE, QueryDataTypeFamily.VARCHAR, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but DATE was found"), TestParams.failingCase(2102, QueryDataTypeFamily.DATE, QueryDataTypeFamily.BOOLEAN, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but DATE was found"), TestParams.failingCase(2103, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TINYINT, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but DATE was found"), TestParams.failingCase(2104, QueryDataTypeFamily.DATE, QueryDataTypeFamily.SMALLINT, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but DATE was found"), TestParams.failingCase(2105, QueryDataTypeFamily.DATE, QueryDataTypeFamily.INTEGER, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but DATE was found"), TestParams.failingCase(2106, QueryDataTypeFamily.DATE, QueryDataTypeFamily.BIGINT, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but DATE was found"), TestParams.failingCase(2107, QueryDataTypeFamily.DATE, QueryDataTypeFamily.DECIMAL, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but DATE was found"), TestParams.failingCase(2108, QueryDataTypeFamily.DATE, QueryDataTypeFamily.REAL, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but DATE was found"), TestParams.failingCase(2109, QueryDataTypeFamily.DATE, QueryDataTypeFamily.DOUBLE, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but DATE was found"), TestParams.failingCase(2110, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIME, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but DATE was found"), TestParams.passingCase(2111, QueryDataTypeFamily.DATE, QueryDataTypeFamily.DATE, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30), LocalDate.of(2020, 12, 30)), TestParams.passingCase(2112, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30), LocalDateTime.of(2020, 12, 30, 0, 0)), TestParams.passingCase(2113, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30), ZonedDateTime.of(2020, 12, 30, 0, 0, 0, 0, AbstractTemporalConverter.DEFAULT_ZONE).toOffsetDateTime()), TestParams.passingCase(2114, QueryDataTypeFamily.DATE, QueryDataTypeFamily.OBJECT, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30), LocalDate.of(2020, 12, 30)), TestParams.failingCase(2021, QueryDataTypeFamily.DATE, QueryDataTypeFamily.JSON, "cast('2020-12-30' as date)", LocalDate.of(2020, 12, 30)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DATE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type DATE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but DATE was found"), TestParams.failingCase(2201, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.VARCHAR, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but TIMESTAMP was found"), TestParams.failingCase(2202, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.BOOLEAN, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but TIMESTAMP was found"), TestParams.failingCase(2203, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TINYINT, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but TIMESTAMP was found"), TestParams.failingCase(2204, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.SMALLINT, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but TIMESTAMP was found"), TestParams.failingCase(2205, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.INTEGER, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but TIMESTAMP was found"), TestParams.failingCase(2206, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.BIGINT, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but TIMESTAMP was found"), TestParams.failingCase(2207, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.DECIMAL, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but TIMESTAMP was found"), TestParams.failingCase(2208, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.REAL, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but TIMESTAMP was found"), TestParams.failingCase(2209, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.DOUBLE, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but TIMESTAMP was found"), TestParams.passingCase(2210, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIME, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0), LocalTime.of(1, 42)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but TIMESTAMP was found"), TestParams.passingCase(2211, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.DATE, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0), LocalDate.of(2020, 12, 30)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but TIMESTAMP was found"), TestParams.passingCase(2212, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0), LocalDateTime.of(2020, 12, 30, 1, 42)), TestParams.passingCase(2213, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0), ZonedDateTime.of(2020, 12, 30, 1, 42, 0, 0, AbstractTemporalConverter.DEFAULT_ZONE).toOffsetDateTime()), TestParams.passingCase(2214, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0), LocalDateTime.of(2020, 12, 30, 1, 42)), TestParams.failingCase(2215, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.JSON, "cast('2020-12-30T01:42:00' as timestamp)", LocalDateTime.of(2020, 12, 30, 1, 42, 0)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIMESTAMP").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIMESTAMP").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but TIMESTAMP was found"), TestParams.failingCase(2301, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2302, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.BOOLEAN, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2303, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.TINYINT, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2304, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.SMALLINT, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2305, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2306, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.BIGINT, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2307, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.DECIMAL, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2308, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.REAL, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2309, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.DOUBLE, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.passingCase(2310, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.TIME, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5)), LocalTime.of(1, 42)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.passingCase(2311, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.DATE, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5)), LocalDate.of(2020, 12, 30)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.passingCase(2312, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.TIMESTAMP, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5)), LocalDateTime.of(2020, 12, 30, 1, 42)).withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.passingCase(2313, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5)), OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))), TestParams.passingCase(2314, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5)), OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))), TestParams.failingCase(2315, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.JSON, "cast('2020-12-30T01:42:00-05:00' as timestamp with time zone)", OffsetDateTime.of(2020, 12, 30, 1, 42, 0, 0, ZoneOffset.ofHours(-5))).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field '.+' of type TIMESTAMP WITH TIME ZONE").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but TIMESTAMP WITH TIME ZONE was found"), TestParams.failingCase(2401, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.VARCHAR, "cast('foo' as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type VARCHAR from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but OBJECT was found"), TestParams.failingCase(2402, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.BOOLEAN, "cast(true as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but OBJECT was found"), TestParams.failingCase(2403, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.TINYINT, "cast(42 as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but OBJECT was found"), TestParams.failingCase(2404, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.SMALLINT, "cast(420 as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but OBJECT was found"), TestParams.failingCase(2405, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.INTEGER, "cast(420000 as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but OBJECT was found"), TestParams.failingCase(2406, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.BIGINT, "cast(4200000000 as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but OBJECT was found"), TestParams.failingCase(2407, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.DECIMAL, "cast(cast(1.5 as decimal) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but OBJECT was found"), TestParams.failingCase(2408, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.REAL, "cast(cast(1.5 as real) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but OBJECT was found"), TestParams.failingCase(2409, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.DOUBLE, "cast(cast(1.5 as double) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but OBJECT was found"), TestParams.failingCase(2410, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.TIME, "cast(cast('01:42:00' as time) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but OBJECT was found"), TestParams.failingCase(2411, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.DATE, "cast(cast('2020-12-30' as date) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but OBJECT was found"), TestParams.failingCase(2412, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.TIMESTAMP, "cast(cast('2020-12-30T01:42:00' as timestamp) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but OBJECT was found"), TestParams.failingCase(2413, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "cast(cast('2020-12-30T01:42:00-05:00' as timestamp with time zone) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but OBJECT was found"), TestParams.passingCase(2414, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.OBJECT, "cast('foo' as object)", "foo", "foo"), TestParams.failingCase(2415, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.JSON, "cast(cast('2020-12-30T01:42:00-05:00' as timestamp with time zone) as object)", new Value(42)).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type JSON from source field 'EXPR\\$\\d' of type OBJECT").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type JSON from source field 'EXPR\\$\\d' of type OBJECT").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of JSON type, but OBJECT was found"), TestParams.passingCase(2501, QueryDataTypeFamily.JSON, QueryDataTypeFamily.VARCHAR, "CAST('\"foo\"' AS JSON)", new HazelcastJsonValue("\"foo\""), "\"foo\"").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of VARCHAR type, but JSON was found"), TestParams.failingCase(2502, QueryDataTypeFamily.JSON, QueryDataTypeFamily.BOOLEAN, "CAST('true' AS JSON)", new HazelcastJsonValue("true")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BOOLEAN from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BOOLEAN type, but JSON was found"), TestParams.failingCase(2503, QueryDataTypeFamily.JSON, QueryDataTypeFamily.TINYINT, "CAST('42' AS JSON)", new HazelcastJsonValue("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TINYINT from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TINYINT type, but JSON was found"), TestParams.failingCase(2506, QueryDataTypeFamily.JSON, QueryDataTypeFamily.SMALLINT, "CAST('42' AS JSON)", new HazelcastJsonValue("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type SMALLINT from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of SMALLINT type, but JSON was found"), TestParams.failingCase(2509, QueryDataTypeFamily.JSON, QueryDataTypeFamily.INTEGER, "CAST('42' AS JSON)", new HazelcastJsonValue("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type INTEGER from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of INTEGER type, but JSON was found"), TestParams.failingCase(2512, QueryDataTypeFamily.JSON, QueryDataTypeFamily.BIGINT, "CAST('42' AS JSON)", new HazelcastJsonValue("42")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type BIGINT from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of BIGINT type, but JSON was found"), TestParams.failingCase(2515, QueryDataTypeFamily.JSON, QueryDataTypeFamily.DECIMAL, "CAST('1.5' AS JSON)", new HazelcastJsonValue("1.5")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DECIMAL\\(76, 38\\) from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DECIMAL type, but JSON was found"), TestParams.failingCase(2517, QueryDataTypeFamily.JSON, QueryDataTypeFamily.REAL, "CAST('1.5' AS JSON)", new HazelcastJsonValue("1.5")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type REAL from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of REAL type, but JSON was found"), TestParams.failingCase(2519, QueryDataTypeFamily.JSON, QueryDataTypeFamily.DOUBLE, "CAST('1.5' AS JSON)", new HazelcastJsonValue("1.5")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DOUBLE from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DOUBLE type, but JSON was found"), TestParams.failingCase(2521, QueryDataTypeFamily.JSON, QueryDataTypeFamily.TIME, "CAST('\"01:42:01\"' AS JSON)", new HazelcastJsonValue("\"01:42:01\"")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIME from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIME type, but JSON was found"), TestParams.failingCase(2523, QueryDataTypeFamily.JSON, QueryDataTypeFamily.DATE, "CAST('\"2020-12-30\"' AS JSON)", new HazelcastJsonValue("\"2020-12-30\"")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type DATE from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of DATE type, but JSON was found"), TestParams.failingCase(2525, QueryDataTypeFamily.JSON, QueryDataTypeFamily.TIMESTAMP, "CAST('\"2020-12-30T01:42:00\"' AS JSON)", new HazelcastJsonValue("\"2020-12-30T01:42:00\"")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP type, but JSON was found"), TestParams.failingCase(2527, QueryDataTypeFamily.JSON, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "CAST('\"2020-12-30T01:42:00-05:00\"' AS JSON)", new HazelcastJsonValue("\"2020-12-30T01:42:00-05:00\"")).withExpectedLiteralFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type JSON").withExpectedColumnFailureRegex("Cannot assign to target field 'field1' of type TIMESTAMP WITH TIME ZONE from source field '.+' of type JSON").withExpectedDynamicParameterFailureRegex("Parameter at position 0 must be of TIMESTAMP WITH TIME ZONE type, but JSON was found"), TestParams.passingCase(2529, QueryDataTypeFamily.JSON, QueryDataTypeFamily.OBJECT, "CAST('\"foo\"' AS JSON)", new HazelcastJsonValue("\"foo\""), new HazelcastJsonValue("\"foo\"")), TestParams.passingCase(2530, QueryDataTypeFamily.JSON, QueryDataTypeFamily.JSON, "CAST('{\"k\":\"v\"}' AS JSON)", new HazelcastJsonValue("{\"k\":\"v\"}"), new HazelcastJsonValue("{\"k\":\"v\"}"))};
    }

    @BeforeClass
    public static void beforeClass() {
        RowAssignmentTypeCoercionTest.initialize((int)1, null);
    }

    @Test
    public void test_insertValues() {
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        this.execute("CREATE MAPPING m type IMap OPTIONS('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        try {
            this.execute("SINK INTO m VALUES(0, " + this.testParams.srcLiteral + ", 0)", new Object[0]);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedLiteralFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("m", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedLiteralFailureRegex);
        }
    }

    @Test
    public void test_insertSelect() {
        Assume.assumeFalse((this.testParams.srcType == QueryDataTypeFamily.OBJECT || this.testParams.srcType == QueryDataTypeFamily.NULL ? 1 : 0) != 0);
        Assume.assumeFalse((boolean)(this.testParams.srcValue instanceof HazelcastJsonValue));
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        TestBatchSqlConnector.create(this.sqlService, "src", Collections.singletonList("v"), Collections.singletonList(this.testParams.srcType), Collections.singletonList(new String[]{String.valueOf(this.testParams.srcValue)}));
        this.execute("CREATE MAPPING target TYPE IMap OPTIONS('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        try {
            this.execute("SINK INTO target SELECT 0, v, 0 FROM src", new Object[0]);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedColumnFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("target", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedColumnFailureRegex);
        }
    }

    @Test
    public void test_insertSelect_withLiteral() {
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        TestBatchSqlConnector.create(this.sqlService, "src", 1);
        this.execute("CREATE MAPPING target TYPE IMap OPTIONS('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        try {
            this.execute("SINK INTO target SELECT 0, " + this.testParams.srcLiteral + ", 0 FROM src", new Object[0]);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedLiteralFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("target", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedLiteralFailureRegex);
        }
    }

    @Test
    public void test_insertDynamicParameters() {
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        this.execute("CREATE MAPPING m type IMap OPTIONS('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        try {
            this.execute("SINK INTO m VALUES(0, ?, 0)", this.testParams.srcValue);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedDynamicParameterFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("m", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedDynamicParameterFailureRegex);
        }
    }

    @Test
    public void test_update_literals() {
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        this.execute("CREATE MAPPING m type IMap OPTIONS ('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        RowAssignmentTypeCoercionTest.instance().getMap("m").put((Object)0, ExpressionValue.create(targetClassName));
        try {
            this.execute("UPDATE m SET field1 = " + this.testParams.srcLiteral, new Object[0]);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedLiteralFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("m", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedLiteralFailureRegex);
        }
    }

    @Test
    public void test_update_columns() {
        Assume.assumeFalse((this.testParams.srcType == QueryDataTypeFamily.NULL ? 1 : 0) != 0);
        Class<? extends ExpressionBiValue> valueClass = ExpressionBiValue.biClassForType(this.testParams.targetType, this.testParams.srcType);
        this.execute("CREATE MAPPING m TYPE IMap OPTIONS('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + valueClass.getName() + "')", new Object[0]);
        RowAssignmentTypeCoercionTest.instance().getMap("m").put((Object)0, ExpressionBiValue.createBiValue(valueClass, null, this.testParams.srcValue));
        try {
            this.execute("UPDATE m SET field1 = field2", new Object[0]);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedColumnFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("m", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedColumnFailureRegex);
        }
    }

    @Test
    public void test_update_dynamicParameters() {
        String targetClassName = ExpressionValue.classForType(this.testParams.targetType);
        this.execute("CREATE MAPPING m type IMap OPTIONS ('keyFormat'='int', 'valueFormat'='java', 'valueJavaClass'='" + targetClassName + "')", new Object[0]);
        RowAssignmentTypeCoercionTest.instance().getMap("m").put((Object)0, ExpressionValue.create(targetClassName));
        try {
            this.execute("UPDATE m SET field1 = ?", this.testParams.srcValue);
            RowAssignmentTypeCoercionTest.throwIfFailureWasExpected(this.testParams.expectedDynamicParameterFailureRegex);
            Assertions.assertThat((Object)RowAssignmentTypeCoercionTest.extractValue("m", "field1")).isIn(this.testParams.expectedTargetValues);
        }
        catch (Exception e) {
            RowAssignmentTypeCoercionTest.assertExceptionMatches(e, this.testParams.expectedDynamicParameterFailureRegex);
        }
    }

    private void execute(String sql, Object ... arguments) {
        this.logger.info(sql);
        SqlResult ignored = this.sqlService.execute(sql, arguments);
        if (ignored != null) {
            ignored.close();
        }
    }

    private static void throwIfFailureWasExpected(Pattern pattern) {
        if (pattern != null) {
            Assertions.fail((String)("Expected to fail with \"" + String.valueOf(pattern) + "\", but no exception was thrown"));
        }
    }

    private static void assertExceptionMatches(Exception e, Pattern pattern) {
        if (pattern == null) {
            throw new AssertionError("The query failed unexpectedly: " + String.valueOf(e), e);
        }
        if (!pattern.matcher(e.getMessage()).find()) {
            throw new AssertionError("\n'" + e.getMessage() + "'\ndidn't contain \n'" + String.valueOf(pattern) + "'", e);
        }
    }

    private static Object extractValue(String mapName, String fieldName) throws Exception {
        Object valueWrapper = RowAssignmentTypeCoercionTest.instance().getMap(mapName).get((Object)0);
        return valueWrapper.getClass().getField(fieldName).get(valueWrapper);
    }

    private static final class TestParams {
        private final int testId;
        private final QueryDataTypeFamily srcType;
        private final QueryDataTypeFamily targetType;
        private final String srcLiteral;
        private final Object srcValue;
        private final List<Object> expectedTargetValues;
        private Pattern expectedLiteralFailureRegex;
        private Pattern expectedColumnFailureRegex;
        private Pattern expectedDynamicParameterFailureRegex;

        private TestParams(int testId, QueryDataTypeFamily srcType, QueryDataTypeFamily targetType, String srcLiteral, Object srcValue, List<Object> expectedTargetValues) {
            this.testId = testId;
            this.srcType = srcType;
            this.targetType = targetType;
            this.srcLiteral = srcLiteral;
            this.srcValue = srcValue;
            this.expectedTargetValues = expectedTargetValues;
        }

        static TestParams passingCase(int testId, QueryDataTypeFamily srcType, QueryDataTypeFamily targetType, String valueLiteral, Object value, Object ... targetValues) {
            return new TestParams(testId, srcType, targetType, valueLiteral, value, Arrays.asList(targetValues));
        }

        static TestParams failingCase(int testId, QueryDataTypeFamily srcType, QueryDataTypeFamily targetType, String valueLiteral, Object value) {
            return new TestParams(testId, srcType, targetType, valueLiteral, value, null);
        }

        private TestParams withExpectedLiteralFailureRegex(String failureRegex) {
            this.expectedLiteralFailureRegex = Pattern.compile(failureRegex);
            return this;
        }

        private TestParams withExpectedColumnFailureRegex(String failureRegex) {
            this.expectedColumnFailureRegex = Pattern.compile(failureRegex);
            return this;
        }

        private TestParams withExpectedDynamicParameterFailureRegex(String failureRegex) {
            this.expectedDynamicParameterFailureRegex = Pattern.compile(failureRegex);
            return this;
        }

        private TestParams withExpectedFailureRegex(String failureRegex) {
            this.expectedColumnFailureRegex = this.expectedDynamicParameterFailureRegex = Pattern.compile(failureRegex);
            this.expectedLiteralFailureRegex = this.expectedDynamicParameterFailureRegex;
            return this;
        }

        public String toString() {
            return "TestParams{id=" + this.testId + ", srcType=" + String.valueOf(this.srcType) + ", targetType=" + String.valueOf(this.targetType) + ", srcValue=" + String.valueOf(this.srcValue) + "}";
        }
    }

    private static class Value
    implements Serializable {
        public int value;

        private Value(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return this.value == value1.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

