/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.QueryParser;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryParserTest {
    @InjectMocks
    private QueryParser parser;
    @Mock
    private HazelcastSqlValidator sqlValidator;
    @Mock
    private SqlNode validatedNode;
    private AutoCloseable openMocks;

    @Before
    public void setUp() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    public void unsupportedKeywordTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parser.parse("show tables")).isInstanceOf(QueryException.class)).hasMessageContaining("Encountered \"show tables\" at line 1, column 1.");
    }

    @Test
    public void test_trailingSemicolon() {
        BDDMockito.given((Object)this.sqlValidator.validate((SqlNode)ArgumentMatchers.isA(SqlNode.class))).willReturn((Object)this.validatedNode);
        this.parser.parse("SELECT * FROM t;");
        this.parser.parse("SELECT * FROM t;;");
    }

    @Test
    public void test_noFrom() {
        BDDMockito.given((Object)this.sqlValidator.validate((SqlNode)ArgumentMatchers.isA(SqlNode.class))).willReturn((Object)this.validatedNode);
        this.parser.parse("SELECT 1");
        this.parser.parse("SELECT 'test'");
        this.parser.parse("SELECT TO_TIMESTAMP_TZ(1)");
        this.parser.parse("SELECT rand()");
    }

    @Test
    public void when_multipleStatements_then_fails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parser.parse("SELECT * FROM t; SELECT * FROM t")).isInstanceOf(QueryException.class)).hasMessage("The command must contain a single statement");
    }
}

