/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PojoUpsertTargetDescriptorTest {
    private static final InternalSerializationService SERIALIZATION_SERVICE = new DefaultSerializationServiceBuilder().build();

    @Test
    public void test_create() {
        PojoUpsertTargetDescriptor descriptor = new PojoUpsertTargetDescriptor(Object.class.getName(), Collections.emptyMap());
        ExpressionEvalContext evalContextMock = (ExpressionEvalContext)Mockito.mock((Answer)Answers.RETURNS_MOCKS, (Object[])new ExpressionEvalContext[0]);
        NodeEngine nodeEngine = (NodeEngine)Mockito.mock((Answer)Answers.RETURNS_MOCKS, (Object[])new NodeEngine[0]);
        Mockito.when((Object)evalContextMock.getNodeEngine()).thenReturn((Object)nodeEngine);
        UpsertTarget target = descriptor.create(evalContextMock);
        Assertions.assertThat((Object)target).isInstanceOf(PojoUpsertTarget.class);
    }

    @Test
    public void test_serialization() {
        PojoUpsertTargetDescriptor original = new PojoUpsertTargetDescriptor("com.hazelcast.class", Map.of("field", Integer.TYPE.getName()));
        PojoUpsertTargetDescriptor serialized = (PojoUpsertTargetDescriptor)SERIALIZATION_SERVICE.toObject((Object)SERIALIZATION_SERVICE.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

