/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.index;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.index.IndexFilterTestSupport;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IndexEqualsFilterTest {
    @Test
    public void testContent() {
        IndexFilterValue value = IndexFilterTestSupport.intValue(1, true);
        IndexEqualsFilter filter = new IndexEqualsFilter(value);
        Assert.assertSame((Object)value, (Object)filter.getValue());
    }

    @Test
    public void testEquals() {
        IndexEqualsFilter filter = new IndexEqualsFilter(IndexFilterTestSupport.intValue(1, true));
        SqlTestSupport.checkEquals(filter, new IndexEqualsFilter(IndexFilterTestSupport.intValue(1, true)), true);
        SqlTestSupport.checkEquals(filter, new IndexEqualsFilter(IndexFilterTestSupport.intValue(2, true)), false);
    }

    @Test
    public void testSerialization() {
        IndexEqualsFilter original = new IndexEqualsFilter(IndexFilterTestSupport.intValue(1, true));
        IndexEqualsFilter restored = (IndexEqualsFilter)SqlTestSupport.serializeAndCheck(original, 28);
        SqlTestSupport.checkEquals(original, restored, true);
    }

    @Test
    public void testComparable() {
        ExpressionEvalContext evalContext = SqlTestSupport.createExpressionEvalContext(new Object[0]);
        Assert.assertEquals((Object)1, (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValue(1, false)).getComparable(evalContext));
        Assert.assertEquals((Object)AbstractIndex.NULL, (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValue(null, true)).getComparable(evalContext));
        Assert.assertNull((Object)new IndexEqualsFilter(IndexFilterTestSupport.intValue(null, false)).getComparable(evalContext));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(Integer.valueOf(1), Integer.valueOf(2)), (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(1, true, 2, true)).getComparable(evalContext));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(new Comparable[]{Integer.valueOf(1), AbstractIndex.NULL}), (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(1, true, null, true)).getComparable(evalContext));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(new Comparable[]{AbstractIndex.NULL, Integer.valueOf(2)}), (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(null, true, 2, true)).getComparable(evalContext));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(new Comparable[]{AbstractIndex.NULL, AbstractIndex.NULL}), (Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(null, true, null, true)).getComparable(evalContext));
        Assert.assertNull((Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(1, true, null, false)).getComparable(evalContext));
        Assert.assertNull((Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(null, false, 2, true)).getComparable(evalContext));
        Assert.assertNull((Object)new IndexEqualsFilter(IndexFilterTestSupport.intValues(null, false, null, false)).getComparable(evalContext));
    }
}

