/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.jet.sql.impl.extract.AvroQueryTarget;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AvroQueryTargetTest {
    @Test
    public void test_get() {
        AvroQueryTarget target = new AvroQueryTarget();
        QueryExtractor topExtractor = target.createExtractor(null, QueryDataType.OBJECT);
        QueryExtractor nonExistingExtractor = target.createExtractor("nonExisting", QueryDataType.OBJECT);
        QueryExtractor stringExtractor = target.createExtractor("string", QueryDataType.VARCHAR);
        QueryExtractor booleanExtractor = target.createExtractor("boolean", QueryDataType.BOOLEAN);
        QueryExtractor byteExtractor = target.createExtractor("byte", QueryDataType.TINYINT);
        QueryExtractor shortExtractor = target.createExtractor("short", QueryDataType.SMALLINT);
        QueryExtractor intExtractor = target.createExtractor("int", QueryDataType.INT);
        QueryExtractor longExtractor = target.createExtractor("long", QueryDataType.BIGINT);
        QueryExtractor floatExtractor = target.createExtractor("float", QueryDataType.REAL);
        QueryExtractor doubleExtractor = target.createExtractor("double", QueryDataType.DOUBLE);
        QueryExtractor decimalExtractor = target.createExtractor("decimal", QueryDataType.DECIMAL);
        QueryExtractor timeExtractor = target.createExtractor("time", QueryDataType.TIME);
        QueryExtractor dateExtractor = target.createExtractor("date", QueryDataType.DATE);
        QueryExtractor timestampExtractor = target.createExtractor("timestamp", QueryDataType.TIMESTAMP);
        QueryExtractor timestampTzExtractor = target.createExtractor("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        QueryExtractor nullExtractor = target.createExtractor("null", QueryDataType.OBJECT);
        QueryExtractor objectExtractor = target.createExtractor("object", QueryDataType.OBJECT);
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"name").fields().name("string").type().stringType().noDefault().name("boolean").type().booleanType().noDefault().name("byte").type().intType().noDefault().name("short").type().intType().noDefault().name("int").type().intType().noDefault().name("long").type().longType().noDefault().name("float").type().floatType().noDefault().name("double").type().doubleType().noDefault().name("decimal").type().stringType().noDefault().name("time").type().stringType().noDefault().name("date").type().stringType().noDefault().name("timestamp").type().stringType().noDefault().name("timestampTz").type().stringType().noDefault().name("null").type().nullable().record("nul").fields().endRecord()).noDefault().name("object").type().record("object").fields().endRecord()).noDefault().endRecord();
        target.setTarget((Object)new GenericRecordBuilder(schema).set("string", (Object)"string").set("boolean", (Object)true).set("byte", (Object)127).set("short", (Object)Short.MAX_VALUE).set("int", (Object)Integer.MAX_VALUE).set("long", (Object)Long.MAX_VALUE).set("float", (Object)Float.valueOf(1.234568E9f)).set("double", (Object)1.234512345678901E14).set("decimal", (Object)"9223372036854775.123").set("time", (Object)"12:23:34").set("date", (Object)"2020-09-09").set("timestamp", (Object)"2020-09-09T12:23:34.1").set("timestampTz", (Object)"2020-09-09T12:23:34.2Z").set("null", null).set("object", (Object)new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"name").fields().endRecord()).build()).build(), null);
        Assertions.assertThat((Object)topExtractor.get()).isInstanceOf(GenericRecord.class);
        Assertions.assertThat((Object)nonExistingExtractor.get()).isNull();
        Assertions.assertThat((Object)stringExtractor.get()).isEqualTo((Object)"string");
        Assertions.assertThat((Object)booleanExtractor.get()).isEqualTo((Object)true);
        Assertions.assertThat((Object)byteExtractor.get()).isEqualTo((Object)127);
        Assertions.assertThat((Object)shortExtractor.get()).isEqualTo((Object)Short.MAX_VALUE);
        Assertions.assertThat((Object)intExtractor.get()).isEqualTo((Object)Integer.MAX_VALUE);
        Assertions.assertThat((Object)longExtractor.get()).isEqualTo((Object)Long.MAX_VALUE);
        Assertions.assertThat((Object)floatExtractor.get()).isEqualTo((Object)Float.valueOf(1.234568E9f));
        Assertions.assertThat((Object)doubleExtractor.get()).isEqualTo((Object)1.234512345678901E14);
        Assertions.assertThat((Object)decimalExtractor.get()).isEqualTo((Object)new BigDecimal("9223372036854775.123"));
        Assertions.assertThat((Object)timeExtractor.get()).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((Object)dateExtractor.get()).isEqualTo((Object)LocalDate.of(2020, 9, 9));
        Assertions.assertThat((Object)timestampExtractor.get()).isEqualTo((Object)LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000));
        Assertions.assertThat((Object)timestampTzExtractor.get()).isEqualTo((Object)OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Assertions.assertThat((Object)nullExtractor.get()).isNull();
        Assertions.assertThat((Object)objectExtractor.get()).isNotNull();
    }
}

