/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.string.TrimFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class TrimFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test2Arg() {
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(LEADING field1) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(TRAILING field1) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(BOTH field1) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(" abc ", "SELECT TRIM(LEADING this) FROM map", SqlColumnType.VARCHAR, "abc ", new Object[0]);
        this.putAndCheckValue(" abc ", "SELECT TRIM(TRAILING this) FROM map", SqlColumnType.VARCHAR, " abc", new Object[0]);
        this.putAndCheckValue(" abc ", "SELECT TRIM(BOTH this) FROM map", SqlColumnType.VARCHAR, "abc", new Object[0]);
        this.putAndCheckFailure(true, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure((byte)1, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure((short)1, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(1, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(1L, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(1.0f), "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(1.0, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, "SELECT TRIM(LEADING this) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.OBJECT), new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING null) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(TRAILING null) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(BOTH null) FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING ' abc ') FROM map", SqlColumnType.VARCHAR, "abc ", new Object[0]);
        this.checkValue0("SELECT TRIM(TRAILING ' abc ') FROM map", SqlColumnType.VARCHAR, " abc", new Object[0]);
        this.checkValue0("SELECT TRIM(BOTH ' abc ') FROM map", SqlColumnType.VARCHAR, "abc", new Object[0]);
        this.checkFailure0("SELECT TRIM(LEADING 1) FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TINYINT), new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING ?) FROM map", SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkValue0("SELECT TRIM(TRAILING ?) FROM map", SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkValue0("SELECT TRIM(BOTH ?) FROM map", SqlColumnType.VARCHAR, null, new Object[]{null});
        this.checkValue0("SELECT TRIM(LEADING ?) FROM map", SqlColumnType.VARCHAR, "abc ", " abc ");
        this.checkValue0("SELECT TRIM(TRAILING ?) FROM map", SqlColumnType.VARCHAR, " abc", " abc ");
        this.checkValue0("SELECT TRIM(BOTH ?) FROM map", SqlColumnType.VARCHAR, "abc", " abc ");
        this.checkFailure0("SELECT TRIM(LEADING ?) FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.INTEGER), 1);
    }

    @Test
    public void test3Arg() {
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(LEADING field1 FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(TRAILING field1 FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), "SELECT TRIM(BOTH field1 FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("ab", "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_abab", new Object[0]);
        this.putAndCheckValue("ab", "SELECT TRIM(TRAILING this FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "abab_c_", new Object[0]);
        this.putAndCheckValue("ab", "SELECT TRIM(BOTH this FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_", new Object[0]);
        this.putAndCheckFailure(true, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure((byte)1, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TINYINT, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure((short)1, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.SMALLINT, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(1, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.INTEGER, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(1L, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.BIGINT, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(1.0f), "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.REAL, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(1.0, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DATE, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIME, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIMESTAMP, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, "SELECT TRIM(LEADING this FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.OBJECT, SqlColumnType.VARCHAR), new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING null FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(TRAILING null FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(BOTH null FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING 'ab' FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_abab", new Object[0]);
        this.checkValue0("SELECT TRIM(TRAILING 'ab' FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "abab_c_", new Object[0]);
        this.checkValue0("SELECT TRIM(BOTH 'ab' FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_", new Object[0]);
        this.checkFailure0("SELECT TRIM(LEADING true FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0("SELECT TRIM(LEADING 1 FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.TINYINT, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0("SELECT TRIM(LEADING 1.1 FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0("SELECT TRIM(LEADING 1.1E1 FROM 'abab_c_abab') FROM map", 1008, TrimFunctionIntegrationTest.signatureErrorFunction("TRIM", SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), new Object[0]);
        this.checkValue0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_abab", "ab");
        this.checkValue0("SELECT TRIM(TRAILING ? FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "abab_c_", "ab");
        this.checkValue0("SELECT TRIM(BOTH ? FROM 'abab_c_abab') FROM map", SqlColumnType.VARCHAR, "_c_", "ab");
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN), true);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TINYINT), (byte)1);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.SMALLINT), (short)1);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.INTEGER), 1);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.BIGINT), 1L);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DOUBLE), 1.0);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0("SELECT TRIM(LEADING ? FROM 'abab_c_abab') FROM map", 2000, TrimFunctionIntegrationTest.parameterError(0, SqlColumnType.VARCHAR, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testEquals() {
        ConstantExpression<?> input1 = this.constant("a");
        ConstantExpression<?> input2 = this.constant("b");
        ConstantExpression<?> characters1 = this.constant("c");
        ConstantExpression<?> characters2 = this.constant("d");
        boolean leading1 = true;
        boolean leading2 = false;
        boolean trailing1 = true;
        boolean trailing2 = false;
        TrimFunction function = TrimFunction.create(input1, characters1, (boolean)leading1, (boolean)trailing1);
        TrimFunctionIntegrationTest.checkEquals(function, TrimFunction.create(input1, characters1, (boolean)leading1, (boolean)trailing1), true);
        TrimFunctionIntegrationTest.checkEquals(function, TrimFunction.create(input2, characters1, (boolean)leading1, (boolean)trailing1), false);
        TrimFunctionIntegrationTest.checkEquals(function, TrimFunction.create(input1, characters2, (boolean)leading1, (boolean)trailing1), false);
        TrimFunctionIntegrationTest.checkEquals(function, TrimFunction.create(input1, characters1, (boolean)leading2, (boolean)trailing1), false);
        TrimFunctionIntegrationTest.checkEquals(function, TrimFunction.create(input1, characters1, (boolean)leading1, (boolean)trailing2), false);
    }

    @Test
    public void testSerialization() {
        TrimFunction original = TrimFunction.create(this.constant("a"), this.constant("b"), (boolean)true, (boolean)true);
        TrimFunction restored = (TrimFunction)TrimFunctionIntegrationTest.serializeAndCheck(original, 65);
        TrimFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testSimplification() {
        TrimFunction function = TrimFunction.create(this.constant("a"), this.constant("b"), (boolean)true, (boolean)true);
        Assert.assertEquals((Object)ConstantExpression.create((Object)"b", (QueryDataType)QueryDataType.VARCHAR), (Object)function.getCharacters());
        function = TrimFunction.create(this.constant("a"), this.constant(" "), (boolean)true, (boolean)true);
        Assert.assertNull((Object)function.getCharacters());
        function = TrimFunction.create(this.constant("a"), null, (boolean)true, (boolean)true);
        Assert.assertNull((Object)function.getCharacters());
    }

    private ConstantExpression<?> constant(String value) {
        return ConstantExpression.create((Object)value, (QueryDataType)QueryDataType.VARCHAR);
    }
}

