/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.PositionFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PositionFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test() {
        this.put("XYZ");
        this.check(this.sql("'ABCD'", "'BC'"), 2, new Object[0]);
        this.check(this.sql("'ABCD'", "''"), 1, new Object[0]);
        this.check(this.sql("'ABCD'", "'NO_MATCH'"), 0, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 0), 0, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 1), 2, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 2), 2, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 3), 0, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 4), 0, new Object[0]);
        this.check(this.sql("'ABCD'", "'BC'", 5), 0, new Object[0]);
        this.check(this.sql("'ABAB'", "'AB'", 1), 1, new Object[0]);
        this.check(this.sql("'ABAB'", "'AB'", 2), 3, new Object[0]);
    }

    @Test
    public void test_null() {
        this.put("XYZ");
        this.check(this.sql("'BC'", "NULL"), null, new Object[0]);
        this.check(this.sql("NULL", "'BC'"), null, new Object[0]);
        this.check(this.sql("NULL", "NULL"), null, new Object[0]);
        this.check(this.sql("NULL", "NULL", 1), null, new Object[0]);
        this.check(this.sql("'ABC'", "'ABC'", "NULL"), null, new Object[0]);
    }

    @Test
    public void test_parameter() {
        this.put("XYZ");
        this.check(this.sql("?", "'BC'"), 2, "ABCD");
        this.check(this.sql("'ABCD'", "?"), 2, "BC");
        this.check(this.sql("?", "?"), 2, "BC", "ABCD");
        this.check(this.sql("?", "?", "?"), 2, "BC", "ABCD", 1);
        this.check(this.sql("?", "?", "?"), 0, "BC", "ABCD", 3);
    }

    @Test
    public void test_wrong_type() {
        this.put("XYZ");
        this.checkError(this.sql("123", "23"), "Cannot apply 'POSITION' function to [TINYINT, TINYINT] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("'123'", "23"), "Cannot apply 'POSITION' function to [TINYINT, VARCHAR] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("123", "'23'"), "Cannot apply 'POSITION' function to [VARCHAR, TINYINT] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("TRUE", "FALSE"), "Cannot apply 'POSITION' function to [BOOLEAN, BOOLEAN] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("'ABC'", "TRUE"), "Cannot apply 'POSITION' function to [BOOLEAN, VARCHAR] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("TRUE", "'ABC'"), "Cannot apply 'POSITION' function to [VARCHAR, BOOLEAN] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("'ABCD'", "'BC'", "'CC'"), "Cannot apply 'POSITION' function to [VARCHAR, VARCHAR, VARCHAR] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("'ABCD'", "'BC'", "TRUE"), "Cannot apply 'POSITION' function to [VARCHAR, VARCHAR, BOOLEAN] (consider adding an explicit CAST)", new Object[0]);
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but INTEGER was found (consider adding an explicit CAST)", 1, 1);
        this.checkError(this.sql("?", "?"), "Parameter at position 1 must be of VARCHAR type, but INTEGER was found (consider adding an explicit CAST)", "foo", 1);
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but INTEGER was found (consider adding an explicit CAST)", 1, "foo");
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but BOOLEAN was found (consider adding an explicit CAST)", true, true);
        this.checkError(this.sql("?", "?"), "Parameter at position 1 must be of VARCHAR type, but BOOLEAN was found (consider adding an explicit CAST)", "foo", true);
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but BOOLEAN was found (consider adding an explicit CAST)", true, "foo");
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but TIMESTAMP WITH TIME ZONE was found (consider adding an explicit CAST)", OFFSET_DATE_TIME_VAL, OFFSET_DATE_TIME_VAL);
        this.checkError(this.sql("?", "?"), "Parameter at position 1 must be of VARCHAR type, but TIMESTAMP WITH TIME ZONE was found (consider adding an explicit CAST)", "foo", OFFSET_DATE_TIME_VAL);
        this.checkError(this.sql("?", "?"), "Parameter at position 0 must be of VARCHAR type, but TIMESTAMP WITH TIME ZONE was found (consider adding an explicit CAST)", OFFSET_DATE_TIME_VAL, "foo");
        this.checkError(this.sql("?", "?", "?"), "Parameter at position 2 must be of INTEGER type, but VARCHAR was found (consider adding an explicit CAST)", "foo", "foo", "foo");
        this.checkError(this.sql("?", "?", "?"), "Parameter at position 2 must be of INTEGER type, but BOOLEAN was found (consider adding an explicit CAST)", "foo", "foo", true);
        this.checkError(this.sql("?", "?", "?"), "Parameter at position 2 must be of INTEGER type, but TIMESTAMP WITH TIME ZONE was found (consider adding an explicit CAST)", "foo", "foo", OFFSET_DATE_TIME_VAL);
    }

    @Test
    public void test_equality() {
        PositionFunction f = this.createFunctionWithoutStart("AB", "ABCD");
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunctionWithoutStart("AB", "ABCD"), true);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunctionWithoutStart("AB", "ABC"), false);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunctionWithoutStart("ABC", "ABCD"), false);
        f = this.createFunction("AB", "ABCD", 2);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunction("AB", "ABCD", 2), true);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunction("AB", "ABC", 2), false);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunction("ABC", "ABCD", 3), false);
        PositionFunctionIntegrationTest.checkEquals(f, this.createFunctionWithoutStart("AB", "ABCD"), false);
    }

    @Test
    public void test_serialization() {
        PositionFunction f = this.createFunctionWithoutStart("AB", "ABCD");
        PositionFunction deserialized = (PositionFunction)PositionFunctionIntegrationTest.serializeAndCheck(f, 69);
        PositionFunctionIntegrationTest.checkEquals(f, deserialized, true);
        f = this.createFunction("AB", "ABCD", 2);
        deserialized = (PositionFunction)PositionFunctionIntegrationTest.serializeAndCheck(f, 69);
        PositionFunctionIntegrationTest.checkEquals(f, deserialized, true);
    }

    private void check(String sql, Integer expectedResult, Object ... parameters) {
        List<SqlRow> rows = PositionFunctionIntegrationTest.execute(sql, parameters);
        Assert.assertEquals((String)"size", (long)1L, (long)rows.size());
        SqlRow row = rows.get(0);
        Assert.assertEquals((Object)SqlColumnType.INTEGER, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)expectedResult, (Object)row.getObject(0));
    }

    private void checkError(String sql, String expectedError, Object ... parameters) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            PositionFunctionIntegrationTest.execute(sql, parameters);
            Assert.fail((String)"did not throw exception");
        }).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining(expectedError);
    }

    private String sql(Object text, Object search) {
        return String.format("SELECT POSITION(%s IN %s) FROM map", search, text);
    }

    private String sql(Object text, Object search, Object start) {
        return String.format("SELECT POSITION(%s IN %s FROM %s) FROM map", search, text, start);
    }

    private PositionFunction createFunction(String search, String text, int start) {
        return PositionFunction.create((Expression)ConstantExpression.create((Object)search, (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)text, (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)start, (QueryDataType)QueryDataType.INT));
    }

    private PositionFunction createFunctionWithoutStart(String search, String text) {
        return PositionFunction.create((Expression)ConstantExpression.create((Object)search, (QueryDataType)QueryDataType.VARCHAR), (Expression)ConstantExpression.create((Object)text, (QueryDataType)QueryDataType.VARCHAR), null);
    }
}

