/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.string.LikeFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class LikeFunctionIntegrationTest
extends ExpressionTestSupport {
    private static final ConstantExpression<?> CONST_1 = ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR);
    private static final ConstantExpression<?> CONST_2 = ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR);
    private static final ConstantExpression<?> CONST_3 = ConstantExpression.create((Object)"3", (QueryDataType)QueryDataType.VARCHAR);
    private static final ConstantExpression<?> CONST_OTHER = ConstantExpression.create((Object)"100", (QueryDataType)QueryDataType.VARCHAR);
    @Parameterized.Parameter
    public boolean negated;

    @Parameterized.Parameters(name="mode:{0}")
    public static List<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    @Test
    public void test_wildcards() {
        this.put("abcde");
        this.check(this.sql("this", "'abcd'"), false, new Object[0]);
        this.check(this.sql("this", "'bcde'"), false, new Object[0]);
        this.check(this.sql("this", "'bcd'"), false, new Object[0]);
        this.check(this.sql("this", "'abcde'"), true, new Object[0]);
        this.check(this.sql("this", "'abcdef'"), false, new Object[0]);
        this.check(this.sql("this", "'abcd'"), false, new Object[0]);
        this.check(this.sql("this", "'bcde'"), false, new Object[0]);
        this.check(this.sql("this", "'_bcde'"), true, new Object[0]);
        this.check(this.sql("this", "'abcd_'"), true, new Object[0]);
        this.check(this.sql("this", "'ab_de'"), true, new Object[0]);
        this.check(this.sql("this", "'_b_d_'"), true, new Object[0]);
        this.check(this.sql("this", "'abcde_'"), false, new Object[0]);
        this.check(this.sql("this", "'_abcde'"), false, new Object[0]);
        this.check(this.sql("this", "'_abcde_'"), false, new Object[0]);
        this.check(this.sql("this", "'_ab_de_'"), false, new Object[0]);
        this.check(this.sql("this", "'_____'"), true, new Object[0]);
        this.check(this.sql("this", "'______'"), false, new Object[0]);
        this.check(this.sql("this", "'%bcde'"), true, new Object[0]);
        this.check(this.sql("this", "'%cde'"), true, new Object[0]);
        this.check(this.sql("this", "'abcd%'"), true, new Object[0]);
        this.check(this.sql("this", "'abc%'"), true, new Object[0]);
        this.check(this.sql("this", "'ab%de'"), true, new Object[0]);
        this.check(this.sql("this", "'a%e'"), true, new Object[0]);
        this.check(this.sql("this", "'%b%d%'"), true, new Object[0]);
        this.check(this.sql("this", "'%c%'"), true, new Object[0]);
        this.check(this.sql("this", "'abcde%'"), true, new Object[0]);
        this.check(this.sql("this", "'%abcde'"), true, new Object[0]);
        this.check(this.sql("this", "'%abcde%'"), true, new Object[0]);
        this.check(this.sql("this", "'%ab%de%'"), true, new Object[0]);
        this.check(this.sql("this", "'%'"), true, new Object[0]);
        this.check(this.sql("this", "'_bcde%'"), true, new Object[0]);
        this.check(this.sql("this", "'_bcd%'"), true, new Object[0]);
        this.check(this.sql("this", "'%b_d%'"), true, new Object[0]);
        this.check(this.sql("this", "'%b__d%'"), false, new Object[0]);
        this.check(this.sql("this", "'____%'"), true, new Object[0]);
        this.check(this.sql("this", "'_____%'"), true, new Object[0]);
        this.check(this.sql("this", "'______%'"), false, new Object[0]);
    }

    @Test
    public void test_escape() {
        this.put("te_t");
        this.check(this.sql("this", "'te!_t'", "'!'"), true, new Object[0]);
        this.check(this.sql("this", "'te!_t'", "null"), null, new Object[0]);
        this.put("te%t");
        this.check(this.sql("this", "'te!%t'", "'!'"), true, new Object[0]);
        this.put("te_t");
        this.checkFailure(this.sql("this", "'te\\_t'", "''"), -1, "ESCAPE parameter must be a single character", new Object[0]);
        this.checkFailure(this.sql("this", "'te\\_t'", "'!!'"), -1, "ESCAPE parameter must be a single character", new Object[0]);
        this.checkFailure(this.sql("this", "'te_!t'", "'!'"), -1, "Only '_', '%' and the escape character can be escaped", new Object[0]);
        this.checkFailure(this.sql("this", "'te_t!'", "'!'"), -1, "Only '_', '%' and the escape character can be escaped", new Object[0]);
    }

    @Test
    public void test_parameter() {
        this.put("te_t");
        this.check(this.sql("?", "this"), true, "test");
        this.check(this.sql("?", "this"), null, new Object[]{null});
        this.put("test");
        this.check(this.sql("this", "?"), true, "te_t");
        this.check(this.sql("this", "?"), null, new Object[]{null});
        this.put("foo");
        this.check(this.sql("?", "?"), true, "test", "te_t");
        this.put("te_t");
        this.check(this.sql("?", "?", "?"), true, "te_t", "te\\__", "\\");
        this.check(this.sql("?", "?", "?"), false, "te_t", "te\\_", "\\");
    }

    @Test
    public void test_literals() {
        this.put("abcde");
        this.checkFailure(this.sql("20", "2"), 1008, LikeFunctionIntegrationTest.signatureErrorOperator(this.name(), SqlColumnType.TINYINT, SqlColumnType.TINYINT), new Object[0]);
        this.checkFailure(this.sql("20", "'2'"), 1008, LikeFunctionIntegrationTest.signatureErrorOperator(this.name(), SqlColumnType.TINYINT, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure(this.sql("'20'", "2"), 1008, LikeFunctionIntegrationTest.signatureErrorOperator(this.name(), SqlColumnType.VARCHAR, SqlColumnType.TINYINT), new Object[0]);
        this.check(this.sql("'20'", "'2_'"), true, new Object[0]);
        this.check(this.sql("null", "'2_'"), null, new Object[0]);
        this.check(this.sql("'20'", "null"), null, new Object[0]);
    }

    @Test
    public void test_newline() {
        this.put("\n");
        this.check(this.sql("this", "'_'"), true, new Object[0]);
        this.check(this.sql("this", "'%'"), true, new Object[0]);
        this.put("\n\n");
        this.check(this.sql("this", "'_'"), false, new Object[0]);
        this.check(this.sql("this", "'__'"), true, new Object[0]);
        this.check(this.sql("this", "'%'"), true, new Object[0]);
    }

    @Test
    public void test_special_char_escaping() {
        this.put("[({|^+*?-$\\.abc})]");
        this.check(this.sql("this", "'[({|^+*?-$\\.___})]'"), true, new Object[0]);
        this.check(this.sql("this", "'[({|^+*?-$\\.%})]'"), true, new Object[0]);
    }

    private void check(String sql, Boolean expectedResult, Object ... params) {
        if (this.negated && expectedResult != null) {
            expectedResult = expectedResult == false;
        }
        List<SqlRow> rows = LikeFunctionIntegrationTest.execute(sql, params);
        Assert.assertEquals((long)1L, (long)rows.size());
        SqlRow row = rows.get(0);
        Assert.assertEquals((long)1L, (long)row.getMetadata().getColumnCount());
        Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)expectedResult, (Object)row.getObject(0));
    }

    private void checkFailure(String sql, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        try {
            LikeFunctionIntegrationTest.execute(sql, params);
            Assert.fail((String)"Must fail");
        }
        catch (HazelcastSqlException e) {
            Assert.assertEquals((String)(expectedErrorCode + ": " + e.getMessage()), (long)expectedErrorCode, (long)e.getCode());
            Assert.assertFalse((boolean)expectedErrorMessage.isEmpty());
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(expectedErrorMessage));
        }
    }

    private String sql(Object operand1, Object operand2) {
        return "SELECT " + String.valueOf(operand1) + " " + this.name() + " " + String.valueOf(operand2) + " FROM map";
    }

    private String sql(Object operand1, Object operand2, Object operand3) {
        return "SELECT " + String.valueOf(operand1) + " " + this.name() + " " + String.valueOf(operand2) + " ESCAPE " + String.valueOf(operand3) + " FROM map";
    }

    private String name() {
        return this.negated ? "NOT LIKE" : "LIKE";
    }

    @Test
    public void testEquals() {
        LikeFunction function = LikeFunction.create(CONST_1, CONST_2, CONST_3, (boolean)this.negated);
        LikeFunctionIntegrationTest.checkEquals(function, LikeFunction.create(CONST_1, CONST_2, CONST_3, (boolean)this.negated), true);
        LikeFunctionIntegrationTest.checkEquals(function, LikeFunction.create(CONST_OTHER, CONST_2, CONST_3, (boolean)this.negated), false);
        LikeFunctionIntegrationTest.checkEquals(function, LikeFunction.create(CONST_1, CONST_OTHER, CONST_3, (boolean)this.negated), false);
        LikeFunctionIntegrationTest.checkEquals(function, LikeFunction.create(CONST_1, CONST_2, CONST_OTHER, (boolean)this.negated), false);
        LikeFunctionIntegrationTest.checkEquals(function, LikeFunction.create(CONST_1, CONST_2, CONST_3, (!this.negated ? 1 : 0) != 0), false);
    }

    @Test
    public void testSerialization() {
        LikeFunction original = LikeFunction.create(CONST_1, CONST_2, CONST_3, (boolean)this.negated);
        LikeFunction restored = (LikeFunction)LikeFunctionIntegrationTest.serializeAndCheck(original, 63);
        LikeFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

