/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class BetweenOperatorIntegrationTest
extends ExpressionTestSupport {
    static final ExpressionType<?>[] TESTED_TYPES = ExpressionTypes.allExcept(new ExpressionType[0]);

    @Test
    public void basicBetweenPredicateNumericTest() {
        this.putAll(0, 1, 25, 30);
        this.checkValues(this.sqlQuery("BETWEEN 2 AND 2"), SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN 0 AND 25"), SqlColumnType.INTEGER, new Integer[]{0, 1, 25}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT BETWEEN 25 AND 40"), SqlColumnType.INTEGER, new Integer[]{0, 1}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN ? AND ?"), SqlColumnType.INTEGER, new Integer[]{1, 25}, 1, 25);
        this.checkValues(this.sqlQuery("NOT BETWEEN ? AND ?"), SqlColumnType.INTEGER, new Integer[]{0, 30}, 1, 25);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC 25 AND 0"), SqlColumnType.INTEGER, new Integer[]{0, 1, 25}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC 0 AND 25"), SqlColumnType.INTEGER, new Integer[]{0, 1, 25}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT BETWEEN SYMMETRIC 25 AND 0"), SqlColumnType.INTEGER, new Integer[]{30}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT BETWEEN SYMMETRIC 0 AND 25"), SqlColumnType.INTEGER, new Integer[]{30}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN ? AND ?"), SqlColumnType.INTEGER, new Integer[]{0, 1, 25}, 0, 25);
        this.checkValues(this.sqlQuery("NOT BETWEEN ? AND ?"), SqlColumnType.INTEGER, new Integer[]{0, 1, 25, 30}, 25, 0);
    }

    @Test
    public void betweenPredicateNullTest() {
        this.putAll(new Person(null));
        this.checkValues("SELECT name FROM map WHERE name BETWEEN NULL AND NULL", SqlColumnType.OBJECT, new Object[0], new Object[0]);
        this.checkValues("SELECT name FROM map WHERE name BETWEEN 2 AND NULL", SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues("SELECT name FROM map WHERE name BETWEEN NULL AND 2", SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues("SELECT name FROM map WHERE name BETWEEN 'abc' AND NULL", SqlColumnType.VARCHAR, new String[0], new Object[0]);
        this.checkValues("SELECT name FROM map WHERE name BETWEEN NULL AND 'bcd'", SqlColumnType.VARCHAR, new String[0], new Object[0]);
        this.putAll(0, 1, 25, 30);
        this.checkValues(this.sqlQuery("BETWEEN NULL AND 2"), SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN 2 AND NULL"), SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN NULL AND 2"), SqlColumnType.INTEGER, new Integer[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN 'abc' AND NULL"), SqlColumnType.VARCHAR, new String[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN NULL AND 'bcd'"), SqlColumnType.VARCHAR, new String[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC CAST('2020-01-01' AS DATE) AND NULL"), SqlColumnType.DATE, new LocalDate[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC CAST('20:00:00' AS TIME) AND NULL"), SqlColumnType.TIME, new LocalTime[0], new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC CAST('2000-01-01T08:00:00' AS TIMESTAMP) AND NULL"), SqlColumnType.TIME, new LocalDateTime[0], new Object[0]);
    }

    @Test
    public void betweenPredicateAllowedImplicitCastsTest() {
        this.putAll("1", "2", "3");
        this.checkValues(this.sqlQuery("BETWEEN 1 AND 3"), SqlColumnType.VARCHAR, new String[]{"1", "2", "3"}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC 3 AND 1"), SqlColumnType.VARCHAR, new String[]{"1", "2", "3"}, new Object[0]);
        this.putAll("1.5", "2.5", "3.25");
        this.checkValues(this.sqlQuery("BETWEEN 1.0 AND 4"), SqlColumnType.VARCHAR, new String[]{"1.5", "2.5", "3.25"}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC 4 AND 1.0"), SqlColumnType.VARCHAR, new String[]{"1.5", "2.5", "3.25"}, new Object[0]);
        this.putAll(1, 2, 3);
        this.checkValues(this.sqlQuery("BETWEEN '1' AND '3'"), SqlColumnType.INTEGER, new Integer[]{1, 2, 3}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC '3' AND '1'"), SqlColumnType.INTEGER, new Integer[]{1, 2, 3}, new Object[0]);
        this.putAll(1.5, 2.5, 3.5);
        this.checkValues(this.sqlQuery("BETWEEN '0.99' AND '3.51'"), SqlColumnType.DOUBLE, new Double[]{1.5, 2.5, 3.5}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC '3.51' AND '0.99'"), SqlColumnType.DOUBLE, new Double[]{1.5, 2.5, 3.5}, new Object[0]);
        this.putAll(1L, 10L, 100L);
        this.checkValues(this.sqlQuery("BETWEEN '1' AND '300'"), SqlColumnType.BIGINT, new Long[]{1L, 10L, 100L}, new Object[0]);
        this.checkValues(this.sqlQuery("BETWEEN SYMMETRIC '300' AND '1'"), SqlColumnType.BIGINT, new Long[]{1L, 10L, 100L}, new Object[0]);
    }

    @Test
    public void betweenAsymmetricPredicateTypeCheckTest() {
        for (ExpressionType<?> fieldType : TESTED_TYPES) {
            this.putAll(fieldType.nonNullValues().toArray());
            for (ExpressionType<?> lowerBoundType : TESTED_TYPES) {
                for (ExpressionType<?> upperBoundType : TESTED_TYPES) {
                    Object biValue = ExpressionBiValue.createBiValue(lowerBoundType.valueFrom(), upperBoundType.valueTo());
                    Tuple2<List<SqlRow>, HazelcastSqlException> comparisonEquivalentResult = this.executePossiblyFailingQuery("SELECT this FROM map WHERE this >=      ? AND this <= ?  ORDER BY this", fieldType.getFieldConverterType().getTypeFamily().getPublicType(), ((ExpressionValue)biValue).field1(), ((ExpressionBiValue)biValue).field2());
                    try {
                        this.checkSuccessOrFailure("SELECT this FROM map WHERE this BETWEEN ? AND         ?  ORDER BY this", comparisonEquivalentResult, ((ExpressionValue)biValue).field1(), ((ExpressionBiValue)biValue).field2());
                    }
                    catch (Throwable e) {
                        throw new AssertionError("For [" + String.valueOf(fieldType) + ", " + String.valueOf(lowerBoundType) + ", " + String.valueOf(upperBoundType) + "]: " + String.valueOf(e), e);
                    }
                }
            }
        }
    }

    @Test
    public void betweenSymmetricPredicateTypeCheckTest() {
        int cycleCounter = 0;
        for (ExpressionType<?> fieldType : TESTED_TYPES) {
            this.putAll(fieldType.nonNullValues().toArray());
            for (ExpressionType<?> lowerBoundType : TESTED_TYPES) {
                for (ExpressionType<?> upperBoundType : TESTED_TYPES) {
                    ++cycleCounter;
                    Object biValue = ExpressionBiValue.createBiValue(lowerBoundType.valueFrom(), upperBoundType.valueTo());
                    Tuple2<List<SqlRow>, HazelcastSqlException> comparisonEquivalentResult = this.executePossiblyFailingQuery("SELECT this FROM map WHERE (this >=     ? AND this <= ?) OR (this >= ? AND this <= ?) ORDER BY this", fieldType.getFieldConverterType().getTypeFamily().getPublicType(), ((ExpressionValue)biValue).field1(), ((ExpressionBiValue)biValue).field2(), ((ExpressionBiValue)biValue).field2(), ((ExpressionValue)biValue).field1());
                    try {
                        this.checkSuccessOrFailure("SELECT this FROM map WHERE this BETWEEN SYMMETRIC ? AND         ?  ORDER BY this", comparisonEquivalentResult, ((ExpressionValue)biValue).field1(), ((ExpressionBiValue)biValue).field2());
                    }
                    catch (Throwable e) {
                        throw new AssertionError("For [" + String.valueOf(fieldType) + ", " + String.valueOf(lowerBoundType) + ", " + String.valueOf(upperBoundType) + "]: " + String.valueOf(e), e);
                    }
                }
            }
        }
        Assert.assertEquals((long)(TESTED_TYPES.length * TESTED_TYPES.length * TESTED_TYPES.length), (long)cycleCounter);
    }

    @Test
    @Ignore(value="Un-ignore after ROW() function implementation")
    public void rowNumericBetweenPredicateTest() {
        this.putAll(0, 1, 5, 10, 15, 25, 30);
        this.checkValues("SELECT * FROM map WHERE this BETWEEN ROW(0, 0) AND ROW(3, 10)", SqlColumnType.INTEGER, (Object[])new Integer[][]{{0, 0}, {1, 1}, {2, 5}, {3, 10}}, new Object[0]);
    }

    protected void checkValues(String sql, SqlColumnType expectedType, Object[] expectedResults, Object ... params) {
        List<SqlRow> rows = BetweenOperatorIntegrationTest.execute(sql, params);
        Assert.assertEquals((long)expectedResults.length, (long)rows.size());
        if (rows.isEmpty()) {
            return;
        }
        if (rows.get(0).getObject(0) instanceof Integer) {
            rows.sort(Comparator.comparingInt(a -> (Integer)a.getObject(0)));
        } else if (rows.get(0).getObject(0) instanceof Comparable) {
            rows.sort((a, b) -> ((Comparable)a.getObject(0)).compareTo(b.getObject(0)));
        }
        for (int i = 0; i < expectedResults.length; ++i) {
            SqlRow row = rows.get(i);
            Assert.assertEquals((Object)expectedType, (Object)row.getMetadata().getColumn(0).getType());
            Assert.assertEquals((Object)expectedResults[i], (Object)row.getObject(0));
        }
    }

    protected void checkSuccessOrFailure(String sql, Tuple2<List<SqlRow>, HazelcastSqlException> expectedOutcome, Object ... params) {
        try {
            List<SqlRow> rows = BetweenOperatorIntegrationTest.execute(sql, params);
            Assert.assertNull((Object)expectedOutcome.f1());
            Assert.assertEquals((long)((List)expectedOutcome.f0()).size(), (long)rows.size());
            List expectedResultsList = (List)expectedOutcome.f0();
            for (int i = 0; i < rows.size(); ++i) {
                SqlColumnType expectedType = ((SqlRow)expectedResultsList.get(i)).getMetadata().getColumn(0).getType();
                SqlColumnType actualType = rows.get(i).getMetadata().getColumn(0).getType();
                Assert.assertEquals((Object)expectedType, (Object)actualType);
                Object actualObject = rows.get(i).getObject(0);
                Object expectedObject = ((SqlRow)expectedResultsList.get(i)).getObject(0);
                Assert.assertEquals((Object)expectedObject, (Object)actualObject);
            }
        }
        catch (HazelcastSqlException e) {
            Assert.assertNotNull((Object)expectedOutcome.f1());
            int startIndex = e.getMessage().indexOf("Parameter");
            if (startIndex == -1) {
                startIndex = e.getMessage().indexOf("Cannot compare");
            }
            Assert.assertEquals((Object)((HazelcastSqlException)((Object)expectedOutcome.f1())).getMessage().substring(startIndex), (Object)e.getMessage().substring(startIndex));
        }
    }

    protected Tuple2<List<SqlRow>, HazelcastSqlException> executePossiblyFailingQuery(String sql, SqlColumnType firstColumnExpectedType, Object ... params) {
        try {
            SqlResult result = BetweenOperatorIntegrationTest.instance().getSql().execute(sql, params);
            ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
            for (SqlRow row : result) {
                Assert.assertEquals((Object)firstColumnExpectedType, (Object)row.getMetadata().getColumn(0).getType());
                rows.add(row);
            }
            return Tuple2.tuple2(rows, null);
        }
        catch (HazelcastSqlException e) {
            return Tuple2.tuple2(Collections.emptyList(), (Object)((Object)e));
        }
    }

    private String sqlQuery(String betweenClause) {
        return "SELECT this FROM map WHERE this " + betweenClause;
    }

    static class Person
    implements Serializable {
        public final String name;

        Person(String name) {
            this.name = name;
        }
    }
}

