/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.math.ArithmeticOperatorIntegrationTest;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.PlusFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PlusOperatorIntegrationTest
extends ArithmeticOperatorIntegrationTest {
    @Override
    protected String operator() {
        return "+";
    }

    @Test
    public void testTinyint() {
        this.putAndCheckValue((byte)0, this.sql("this", "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, this.sql("null", "this"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkFieldsCommute((byte)0, (byte)1, SqlColumnType.SMALLINT, (short)1);
        this.checkFieldsCommute((byte)1, (byte)127, SqlColumnType.SMALLINT, (short)128);
        this.checkFieldsCommute((byte)-1, (byte)-128, SqlColumnType.SMALLINT, (short)-129);
        this.checkFieldsCommute((byte)127, (byte)127, SqlColumnType.SMALLINT, (short)254);
        this.checkFieldsCommute((byte)-128, (byte)-128, SqlColumnType.SMALLINT, (short)-256);
        this.checkFieldsCommute((byte)0, (short)1, SqlColumnType.INTEGER, 1);
        this.checkFieldsCommute((byte)1, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 32768);
        this.checkFieldsCommute((byte)-1, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, -32769);
        this.checkFieldsCommute((byte)127, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 32894);
        this.checkFieldsCommute((byte)-128, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, -32896);
        this.checkFieldsCommute((byte)0, 1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute((byte)1, Integer.MAX_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFieldsCommute((byte)-1, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147483649L);
        this.checkFieldsCommute((byte)127, Integer.MAX_VALUE, SqlColumnType.BIGINT, 2147483774L);
        this.checkFieldsCommute((byte)-128, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147483776L);
        this.checkFieldsCommute((byte)0, 1L, SqlColumnType.BIGINT, 1L);
        this.checkErrorCommute((byte)1, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((byte)-1, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((byte)127, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((byte)-128, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute((byte)0, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1"));
        this.checkFieldsCommute((byte)0, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute((byte)0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute((byte)0, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1L);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testSmallint() {
        this.putAndCheckValue((short)0, this.sql("this", "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue((short)0, this.sql("null", "this"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkFieldsCommute((short)0, (byte)1, SqlColumnType.INTEGER, 1);
        this.checkFieldsCommute((short)1, (byte)127, SqlColumnType.INTEGER, 128);
        this.checkFieldsCommute((short)-1, (byte)-128, SqlColumnType.INTEGER, -129);
        this.checkFieldsCommute((short)Short.MAX_VALUE, (byte)127, SqlColumnType.INTEGER, 32894);
        this.checkFieldsCommute((short)Short.MIN_VALUE, (byte)-128, SqlColumnType.INTEGER, -32896);
        this.checkFieldsCommute((short)0, (short)1, SqlColumnType.INTEGER, 1);
        this.checkFieldsCommute((short)1, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 32768);
        this.checkFieldsCommute((short)-1, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, -32769);
        this.checkFieldsCommute((short)Short.MAX_VALUE, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 65534);
        this.checkFieldsCommute((short)Short.MIN_VALUE, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, -65536);
        this.checkFieldsCommute((short)0, 1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute((short)1, Integer.MAX_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFieldsCommute((short)-1, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147483649L);
        this.checkFieldsCommute((short)Short.MAX_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, 2147516414L);
        this.checkFieldsCommute((short)Short.MIN_VALUE, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147516416L);
        this.checkFieldsCommute((short)0, 1L, SqlColumnType.BIGINT, 1L);
        this.checkErrorCommute((short)1, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((short)-1, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((short)Short.MAX_VALUE, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute((short)Short.MIN_VALUE, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute((short)0, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1"));
        this.checkFieldsCommute((short)0, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute((short)0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute((short)0, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1L);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testInteger() {
        this.putAndCheckValue(0, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFieldsCommute(0, (byte)1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1, (byte)127, SqlColumnType.BIGINT, 128L);
        this.checkFieldsCommute(-1, (byte)-128, SqlColumnType.BIGINT, -129L);
        this.checkFieldsCommute(Integer.MAX_VALUE, (byte)127, SqlColumnType.BIGINT, 2147483774L);
        this.checkFieldsCommute(Integer.MIN_VALUE, (byte)-128, SqlColumnType.BIGINT, -2147483776L);
        this.checkFieldsCommute(0, (short)1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1, (short)Short.MAX_VALUE, SqlColumnType.BIGINT, 32768L);
        this.checkFieldsCommute(-1, (short)Short.MIN_VALUE, SqlColumnType.BIGINT, -32769L);
        this.checkFieldsCommute(Integer.MAX_VALUE, (short)Short.MAX_VALUE, SqlColumnType.BIGINT, 2147516414L);
        this.checkFieldsCommute(Integer.MIN_VALUE, (short)Short.MIN_VALUE, SqlColumnType.BIGINT, -2147516416L);
        this.checkFieldsCommute(0, 1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1, Integer.MAX_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFieldsCommute(-1, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147483649L);
        this.checkFieldsCommute(Integer.MAX_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, 0xFFFFFFFEL);
        this.checkFieldsCommute(Integer.MIN_VALUE, Integer.MIN_VALUE, SqlColumnType.BIGINT, -4294967296L);
        this.checkFieldsCommute(0, 1L, SqlColumnType.BIGINT, 1L);
        this.checkErrorCommute(1, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(-1, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Integer.MAX_VALUE, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Integer.MIN_VALUE, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(0, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1"));
        this.checkFieldsCommute(0, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute(0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute(0, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1L);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testBigint() {
        this.putAndCheckValue(0L, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0L, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFieldsCommute(0L, (byte)1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1L, (byte)127, SqlColumnType.BIGINT, 128L);
        this.checkFieldsCommute(-1L, (byte)-128, SqlColumnType.BIGINT, -129L);
        this.checkErrorCommute(Long.MAX_VALUE, (byte)127, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Long.MIN_VALUE, (byte)-128, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(0L, (short)1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1L, (short)Short.MAX_VALUE, SqlColumnType.BIGINT, 32768L);
        this.checkFieldsCommute(-1L, (short)Short.MIN_VALUE, SqlColumnType.BIGINT, -32769L);
        this.checkErrorCommute(Long.MAX_VALUE, (short)Short.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Long.MIN_VALUE, (short)Short.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(0, 1, SqlColumnType.BIGINT, 1L);
        this.checkFieldsCommute(1, Integer.MAX_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFieldsCommute(-1, Integer.MIN_VALUE, SqlColumnType.BIGINT, -2147483649L);
        this.checkErrorCommute(Long.MAX_VALUE, Integer.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Long.MIN_VALUE, Integer.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(0, 1L, SqlColumnType.BIGINT, 1L);
        this.checkErrorCommute(1, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(-1, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Long.MAX_VALUE, Long.MAX_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkErrorCommute(Long.MIN_VALUE, Long.MIN_VALUE, 2000, PlusOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(0L, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1"));
        this.checkFieldsCommute(0L, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute(0L, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute(0L, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 1L);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigInteger() {
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFieldsCommute(BigInteger.ZERO, (byte)1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigInteger.ONE, (byte)127, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(128));
        this.checkFieldsCommute(BigInteger.ONE.negate(), (byte)-128, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-129));
        this.checkFieldsCommute(BigInteger.ZERO, (short)1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigInteger.ONE, (short)Short.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(32768));
        this.checkFieldsCommute(BigInteger.ONE.negate(), (short)Short.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-32769));
        this.checkFieldsCommute(BigInteger.ZERO, 1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigInteger.ONE, Integer.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(0x80000000L));
        this.checkFieldsCommute(BigInteger.ONE.negate(), Integer.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-2147483649L));
        this.checkFieldsCommute(BigInteger.ZERO, 1L, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigInteger.ONE, Long.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(Long.MAX_VALUE).add(PlusOperatorIntegrationTest.decimal(1)));
        this.checkFieldsCommute(BigInteger.ONE.negate(), Long.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(Long.MIN_VALUE).add(PlusOperatorIntegrationTest.decimal(-1)));
        this.checkFieldsCommute(BigInteger.ZERO, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigInteger.ZERO, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute(BigInteger.ZERO, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute(BigInteger.ZERO, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), (byte)1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), (short)1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), 1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), 1L);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), BigInteger.ONE);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"), PlusOperatorIntegrationTest.decimal("1.1"));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigDecimal() {
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFieldsCommute(BigDecimal.ZERO, (byte)1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigDecimal.ONE, (byte)127, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(128));
        this.checkFieldsCommute(BigDecimal.ONE.negate(), (byte)-128, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-129));
        this.checkFieldsCommute(BigDecimal.ZERO, (short)1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigDecimal.ONE, (short)Short.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(32768));
        this.checkFieldsCommute(BigDecimal.ONE.negate(), (short)Short.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-32769));
        this.checkFieldsCommute(BigDecimal.ZERO, 1, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigDecimal.ONE, Integer.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(0x80000000L));
        this.checkFieldsCommute(BigDecimal.ONE.negate(), Integer.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(-2147483649L));
        this.checkFieldsCommute(BigDecimal.ZERO, 1L, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigDecimal.ONE, Long.MAX_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(Long.MAX_VALUE).add(PlusOperatorIntegrationTest.decimal(1)));
        this.checkFieldsCommute(BigDecimal.ONE.negate(), Long.MIN_VALUE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(Long.MIN_VALUE).add(PlusOperatorIntegrationTest.decimal(-1)));
        this.checkFieldsCommute(BigDecimal.ZERO, BigInteger.ONE, SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1));
        this.checkFieldsCommute(BigDecimal.ZERO, PlusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"));
        this.checkFieldsCommute(BigDecimal.ZERO, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFieldsCommute(BigDecimal.ZERO, 1.0, SqlColumnType.DOUBLE, 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), (byte)1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), (short)1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), 1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), 1L);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal(1), BigInteger.ONE);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, PlusOperatorIntegrationTest.decimal("1.1"), PlusOperatorIntegrationTest.decimal("1.1"));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testReal() {
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("this", "null"), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("null", "this"), SqlColumnType.REAL, null, new Object[0]);
        this.checkFieldsCommute(Float.valueOf(1.0f), Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(3.0f));
        this.checkFieldsCommute(Float.valueOf(1.0f), 2.0, SqlColumnType.DOUBLE, 3.0);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.0f), (byte)2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.0f), (short)2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.0f), 2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.0f), 2L);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(2.0f), BigInteger.ONE);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.1f), PlusOperatorIntegrationTest.decimal("2.1"));
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(3.1f), Float.valueOf(2.1f));
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDouble() {
        this.putAndCheckValue(0.0, this.sql("this", "null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(0.0, this.sql("null", "this"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkFieldsCommute(1.0, 2.0, SqlColumnType.DOUBLE, 3.0);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.0, (byte)2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.0, (short)2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.0, 2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.0, 2L);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 2.0, BigInteger.ONE);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.1, PlusOperatorIntegrationTest.decimal("2.1"));
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.0, Float.valueOf(2.0f));
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 3.1, 2.1);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    @Parameters(method="dates")
    public void testDate(LocalDate date) {
        this.putAndCheckValue(date, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(date, this.sql("INTERVAL '1' SECOND", null), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(date, this.sql("this", null), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(date, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.DAYS).plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(ONE_YEAR_AND_ONE_MONTH), new Object[0]);
        this.putAndCheckValue(date, this.sql("INTERVAL '1' SECOND", "this"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(date, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.SECONDS), date);
        this.putAndCheckValue(date, this.sql("INTERVAL '1' SECOND", "?"), SqlColumnType.TIMESTAMP, date.atStartOfDay().plus(1L, ChronoUnit.SECONDS), date);
        this.putAndCheckFailure(date, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(date, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
    }

    @Test
    @Parameters(method="times")
    public void testTime(LocalTime time) {
        this.putAndCheckValue(time, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(time, this.sql("INTERVAL '1' SECOND", null), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(time, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(time, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIME, time.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIME, time.plus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIME, time.plus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIME, time.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("INTERVAL '1' SECOND", "this"), SqlColumnType.TIME, time.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(time, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, time.atDate(LocalDate.now()).plus(1L, ChronoUnit.SECONDS), time);
        this.putAndCheckValue(time, this.sql("INTERVAL '1' SECOND", "?"), SqlColumnType.TIMESTAMP, time.atDate(LocalDate.now()).plus(1L, ChronoUnit.SECONDS), time);
        this.putAndCheckFailure(time, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(time, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
    }

    @Test
    @Parameters(method="dateTimes")
    public void testTimestamp(LocalDateTime timestamp) {
        this.putAndCheckValue(timestamp, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("INTERVAL '1' SECOND", null), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.DAYS).plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP, timestamp.plus(ONE_YEAR_AND_ONE_MONTH), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("INTERVAL '1' SECOND", "this"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.SECONDS), timestamp);
        this.putAndCheckValue(timestamp, this.sql("INTERVAL '1' SECOND", "?"), SqlColumnType.TIMESTAMP, timestamp.plus(1L, ChronoUnit.SECONDS), timestamp);
        this.putAndCheckFailure(timestamp, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
    }

    @Test
    @Parameters(method="dateTimes")
    public void testTimestampWithTimezone(LocalDateTime date) {
        OffsetDateTime timestamp = date.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        this.putAndCheckValue(timestamp, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("INTERVAL '1' SECOND", null), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.DAYS).plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(ONE_YEAR_AND_ONE_MONTH), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("INTERVAL '1' SECOND", "this"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.plus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "INTERVAL '1' SECOND"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), timestamp);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", "?"), 2000, PlusOperatorIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), timestamp);
        this.putAndCheckFailure(timestamp, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
    }

    @Test
    public void testEquality() {
        PlusOperatorIntegrationTest.checkEquals(PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        PlusOperatorIntegrationTest.checkEquals(PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        PlusOperatorIntegrationTest.checkEquals(PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)100, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testSerialization() {
        Expression original = PlusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        Expression restored = (Expression)PlusOperatorIntegrationTest.serializeAndCheck(original, 40);
        PlusOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private static String overflowError() {
        return "BIGINT overflow in '+' operator (consider adding explicit CAST to DECIMAL)";
    }
}

