/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.math.ArithmeticOperatorIntegrationTest;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MultiplyOperatorIntegrationTest
extends ArithmeticOperatorIntegrationTest {
    @Override
    protected String operator() {
        return "*";
    }

    @Test
    public void testTinyint() {
        this.putAndCheckValue((byte)0, this.sql("this", "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, this.sql("null", "this"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkFieldsCommute((byte)2, (byte)3, SqlColumnType.SMALLINT, (short)6);
        this.checkFieldsCommute((byte)127, (byte)127, SqlColumnType.SMALLINT, (short)16129);
        this.checkFieldsCommute((byte)2, (short)3, SqlColumnType.INTEGER, 6);
        this.checkFieldsCommute((byte)127, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 4161409);
        this.checkFieldsCommute((byte)2, 3, SqlColumnType.BIGINT, 6L);
        this.checkFieldsCommute((byte)127, Integer.MAX_VALUE, SqlColumnType.BIGINT, 272730423169L);
        this.checkFieldsCommute((byte)2, 3L, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute((byte)127, Long.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute((byte)2, new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6"));
        this.checkFieldsCommute((byte)2, MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute((byte)2, Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute((byte)2, 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((byte)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (byte)3);
        this.putAndCheckValue((byte)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (short)3);
        this.putAndCheckValue((byte)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3);
        this.putAndCheckValue((byte)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3L);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testSmallint() {
        this.putAndCheckValue((short)0, this.sql("this", "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue((short)0, this.sql("null", "this"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkFieldsCommute((short)2, (byte)3, SqlColumnType.INTEGER, 6);
        this.checkFieldsCommute((short)Short.MAX_VALUE, (byte)127, SqlColumnType.INTEGER, 4161409);
        this.checkFieldsCommute((short)2, (short)3, SqlColumnType.INTEGER, 6);
        this.checkFieldsCommute((short)Short.MAX_VALUE, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, 1073676289);
        this.checkFieldsCommute((short)2, 3, SqlColumnType.BIGINT, 6L);
        this.checkFieldsCommute((short)Short.MAX_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, 70366596661249L);
        this.checkFieldsCommute((short)2, 3L, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute((short)Short.MAX_VALUE, Long.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute((short)2, new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6"));
        this.checkFieldsCommute((short)2, MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute((short)2, Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute((short)2, 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((short)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (byte)3);
        this.putAndCheckValue((short)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (short)3);
        this.putAndCheckValue((short)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3);
        this.putAndCheckValue((short)2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3L);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testInteger() {
        this.putAndCheckValue(0, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFieldsCommute(2, (byte)3, SqlColumnType.BIGINT, 6L);
        this.checkFieldsCommute(Integer.MAX_VALUE, (byte)127, SqlColumnType.BIGINT, 272730423169L);
        this.checkFieldsCommute(2, (short)3, SqlColumnType.BIGINT, 6L);
        this.checkFieldsCommute(Integer.MAX_VALUE, (short)Short.MAX_VALUE, SqlColumnType.BIGINT, 70366596661249L);
        this.checkFieldsCommute(2, 3, SqlColumnType.BIGINT, 6L);
        this.checkFieldsCommute(Integer.MAX_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, 4611686014132420609L);
        this.checkFieldsCommute(2, 3L, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute(Integer.MAX_VALUE, Long.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(2, new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6"));
        this.checkFieldsCommute(2, MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute(2, Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute(2, 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (byte)3);
        this.putAndCheckValue(2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (short)3);
        this.putAndCheckValue(2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3);
        this.putAndCheckValue(2, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3L);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testBigint() {
        this.putAndCheckValue(0L, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0L, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFieldsCommute(2L, (byte)3, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute(Long.MAX_VALUE, (byte)127, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(2L, (short)3, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute(Long.MAX_VALUE, (short)Short.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(2L, 3, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute(Long.MAX_VALUE, Integer.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(2L, 3L, SqlColumnType.BIGINT, 6L);
        this.checkErrorCommute(Long.MAX_VALUE, Long.MAX_VALUE, 2000, MultiplyOperatorIntegrationTest.overflowError());
        this.checkFieldsCommute(2L, new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6"));
        this.checkFieldsCommute(2L, MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute(2L, Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute(2L, 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(2L, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (byte)3);
        this.putAndCheckValue(2L, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, (short)3);
        this.putAndCheckValue(2L, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3);
        this.putAndCheckValue(2L, this.sql("this", "?"), SqlColumnType.BIGINT, 6L, 3L);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigInteger() {
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFieldsCommute(new BigInteger("2"), (byte)3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigInteger("2"), (short)3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigInteger("2"), 3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigInteger("2"), 3L, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigInteger("2"), new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigInteger("2"), MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute(new BigInteger("2"), Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute(new BigInteger("2"), 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), (byte)3);
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), (short)3);
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), 3);
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), 3L);
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), new BigInteger("3"));
        this.putAndCheckValue(new BigInteger("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"), MultiplyOperatorIntegrationTest.decimal("3.3"));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigDecimal() {
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFieldsCommute(new BigDecimal("2"), (byte)3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigDecimal("2"), (short)3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigDecimal("2"), 3, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigDecimal("2"), 3L, SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigDecimal("2"), new BigInteger("3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6));
        this.checkFieldsCommute(new BigDecimal("2"), MultiplyOperatorIntegrationTest.decimal("3.3"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"));
        this.checkFieldsCommute(new BigDecimal("2"), Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute(new BigDecimal("2"), 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), (byte)3);
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), (short)3);
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), 3);
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), 3L);
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal(6), new BigInteger("3"));
        this.putAndCheckValue(new BigDecimal("2"), this.sql("this", "?"), SqlColumnType.DECIMAL, MultiplyOperatorIntegrationTest.decimal("6.6"), MultiplyOperatorIntegrationTest.decimal("3.3"));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testReal() {
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("this", "null"), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("null", "this"), SqlColumnType.REAL, null, new Object[0]);
        this.checkFieldsCommute(Float.valueOf(2.0f), Float.valueOf(3.0f), SqlColumnType.REAL, Float.valueOf(6.0f));
        this.checkFieldsCommute(Float.valueOf(2.0f), 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), (byte)3);
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), (short)3);
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), 3);
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), 3L);
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), new BigInteger("3"));
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), MultiplyOperatorIntegrationTest.decimal("3"));
        this.putAndCheckValue(Float.valueOf(2.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(6.0f), Float.valueOf(3.0f));
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDouble() {
        this.putAndCheckValue(0.0, this.sql("this", "null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(0.0, this.sql("null", "this"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkFieldsCommute(2.0, 3.0, SqlColumnType.DOUBLE, 6.0);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, (byte)3);
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, (short)3);
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, 3);
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, 3L);
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, new BigInteger("3"));
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, MultiplyOperatorIntegrationTest.decimal("3"));
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, Float.valueOf(3.0f));
        this.putAndCheckValue(2.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 6.0, 3.0);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, MultiplyOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testTemporal() {
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_VAL, SqlColumnType.DATE);
        this.checkUnsupportedForAllTypesCommute(LOCAL_TIME_VAL, SqlColumnType.TIME);
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_TIME_VAL, SqlColumnType.TIMESTAMP);
        this.checkUnsupportedForAllTypesCommute(OFFSET_DATE_TIME_VAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
    }

    @Test
    public void testEquality() {
        MultiplyOperatorIntegrationTest.checkEquals(MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        MultiplyOperatorIntegrationTest.checkEquals(MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        MultiplyOperatorIntegrationTest.checkEquals(MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)100, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testSerialization() {
        MultiplyFunction original = MultiplyFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        MultiplyFunction restored = (MultiplyFunction)MultiplyOperatorIntegrationTest.serializeAndCheck(original, 39);
        MultiplyOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private static String overflowError() {
        return "BIGINT overflow in '*' operator (consider adding explicit CAST to DECIMAL)";
    }
}

