/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.FloorCeilFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class FloorCeilFunctionIntegrationTest
extends ExpressionTestSupport {
    @Parameterized.Parameter
    public boolean floor;

    @Parameterized.Parameters(name="mode: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testColumn() {
        this.checkColumn((byte)1, SqlColumnType.TINYINT, (byte)1);
        this.checkColumn((short)1, SqlColumnType.SMALLINT, (short)1);
        this.checkColumn(1, SqlColumnType.INTEGER, 1);
        this.checkColumn(1L, SqlColumnType.BIGINT, 1L);
        this.checkColumn(Float.valueOf(1.1f), SqlColumnType.REAL, this.floorCeil(Float.valueOf(1.0f), Float.valueOf(2.0f)));
        this.checkColumn(1.1, SqlColumnType.DOUBLE, this.floorCeil(1.0, 2.0));
        this.checkColumn(BigInteger.ONE, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(new BigDecimal("1.1"), SqlColumnType.DECIMAL, this.floorCeil(BigDecimal.ONE, new BigDecimal("2")));
        this.checkColumn(Float.valueOf(Float.POSITIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.checkColumn(Float.valueOf(Float.NEGATIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
        this.checkColumn(Float.valueOf(Float.NaN), SqlColumnType.REAL, Float.valueOf(Float.NaN));
        this.checkColumn(Double.POSITIVE_INFINITY, SqlColumnType.DOUBLE, Double.POSITIVE_INFINITY);
        this.checkColumn(Double.NEGATIVE_INFINITY, SqlColumnType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.checkColumn(Double.NaN, SqlColumnType.DOUBLE, Double.NaN);
        this.put(new ExpressionValue.IntegerVal());
        this.checkValue("field1", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkColumnFailure("bad", 1008, this.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(Character.valueOf('b'), 1008, this.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(true, 1008, this.signatureError(SqlColumnType.BOOLEAN));
        this.checkColumnFailure(LOCAL_DATE_VAL, 1008, this.signatureError(SqlColumnType.DATE));
        this.checkColumnFailure(LOCAL_TIME_VAL, 1008, this.signatureError(SqlColumnType.TIME));
        this.checkColumnFailure(LOCAL_DATE_TIME_VAL, 1008, this.signatureError(SqlColumnType.TIMESTAMP));
        this.checkColumnFailure(OFFSET_DATE_TIME_VAL, 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
        this.checkColumnFailure(OBJECT_VAL, 1008, this.signatureError(SqlColumnType.OBJECT));
    }

    private void checkColumn(Object value, SqlColumnType expectedType, Object expectedResult) {
        this.put(value);
        this.checkValue("this", expectedType, expectedResult, new Object[0]);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkParameter((byte)1, BigDecimal.ONE);
        this.checkParameter((short)1, BigDecimal.ONE);
        this.checkParameter(1, BigDecimal.ONE);
        this.checkParameter(1L, BigDecimal.ONE);
        this.checkParameter(BigInteger.ONE, BigDecimal.ONE);
        this.checkParameter(new BigDecimal("1.1"), this.floorCeil(BigDecimal.ONE, new BigDecimal("2")));
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "1.1");
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), Character.valueOf('1'));
        this.checkValue("?", SqlColumnType.DECIMAL, null, new Object[]{null});
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure("?", 2000, FloorCeilFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private Object floorCeil(Object floorVal, Object ceilVal) {
        return this.floor ? floorVal : ceilVal;
    }

    private void checkParameter(Object param, Object expectedResult) {
        this.checkValue("?", SqlColumnType.DECIMAL, expectedResult, param);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkLiteral(1, SqlColumnType.TINYINT, (byte)1);
        this.checkLiteral("null", SqlColumnType.DECIMAL, null);
        this.checkLiteral("1.1", SqlColumnType.DECIMAL, this.floorCeil(new BigDecimal("1"), new BigDecimal("2")));
        this.checkLiteral("1.1E0", SqlColumnType.DOUBLE, this.floorCeil(1.0, 2.0));
        this.checkFailure("'foo'", 1008, this.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure("true", 1008, this.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
    }

    private String signatureError(SqlColumnType type) {
        return FloorCeilFunctionIntegrationTest.signatureErrorFunction(this.name(), type);
    }

    private void checkLiteral(Object literal, SqlColumnType expectedType, Object expectedResult) {
        String literalString = literal.toString();
        this.checkValue(literalString, expectedType, expectedResult, new Object[0]);
    }

    private void checkValue(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        String sql = "SELECT " + this.name() + "(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, expectedType, expectedValue, params);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT " + this.name() + "(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private String name() {
        return this.floor ? "FLOOR" : "CEIL";
    }

    @Test
    public void testEquals() {
        Expression function = FloorCeilFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)true);
        FloorCeilFunctionIntegrationTest.checkEquals(function, FloorCeilFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)true), true);
        FloorCeilFunctionIntegrationTest.checkEquals(function, FloorCeilFunction.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)true), false);
        FloorCeilFunctionIntegrationTest.checkEquals(function, FloorCeilFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)false), false);
    }

    @Test
    public void testSerialization() {
        Expression original = FloorCeilFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)true);
        Expression restored = (Expression)FloorCeilFunctionIntegrationTest.serializeAndCheck(original, 55);
        FloorCeilFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testSimplification() {
        this.checkSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.TINYINT), (QueryDataType)QueryDataType.TINYINT, (boolean)true));
        this.checkSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.SMALLINT), (QueryDataType)QueryDataType.SMALLINT, (boolean)true));
        this.checkSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT, (boolean)true));
        this.checkSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.BIGINT), (QueryDataType)QueryDataType.BIGINT, (boolean)true));
        this.checkNotSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DECIMAL_BIG_INTEGER), (QueryDataType)QueryDataType.DECIMAL_BIG_INTEGER, (boolean)true));
        this.checkNotSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DECIMAL), (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.REAL), (QueryDataType)QueryDataType.REAL, (boolean)true));
        this.checkNotSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DOUBLE), (QueryDataType)QueryDataType.DOUBLE, (boolean)true));
        this.checkNotSimplified(FloorCeilFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.TINYINT), (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
    }

    private void checkNotSimplified(Expression<?> expression) {
        Assert.assertEquals(FloorCeilFunction.class, expression.getClass());
    }

    private void checkSimplified(Expression<?> expression) {
        Assert.assertEquals(ConstantExpression.class, expression.getClass());
    }
}

