/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ExpressionMathTest {
    @Test
    public void testDecimalMathContext() {
        Assert.assertEquals((long)76L, (long)QueryDataTypeUtils.DECIMAL_MATH_CONTEXT.getPrecision());
        Assert.assertEquals((Object)((Object)RoundingMode.HALF_UP), (Object)((Object)QueryDataTypeUtils.DECIMAL_MATH_CONTEXT.getRoundingMode()));
        BigDecimal r = BigDecimal.valueOf(1L).divide(BigDecimal.valueOf(3L), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
        Assert.assertEquals((long)76L, (long)r.precision());
    }

    @Test
    public void testLongDivideExactly() {
        Assert.assertEquals((long)3L, (long)ExpressionMath.divideExact((long)10L, (long)3L));
        HazelcastTestSupport.assertThrows(ArithmeticException.class, () -> ExpressionMath.divideExact((long)10L, (long)0L));
        HazelcastTestSupport.assertThrows(QueryException.class, () -> ExpressionMath.divideExact((long)Long.MIN_VALUE, (long)-1L));
    }

    @Test
    public void testDoubleDivideExactly() {
        Assert.assertEquals((double)3.3333333333333335, (double)ExpressionMath.divideExact((double)10.0, (double)3.0), (double)0.0);
        HazelcastTestSupport.assertThrows(ArithmeticException.class, () -> ExpressionMath.divideExact((double)10.0, (double)0.0));
    }

    @Test
    public void testFloatDivideExactly() {
        Assert.assertEquals((float)3.3333333f, (float)ExpressionMath.divideExact((float)10.0f, (float)3.0f), (float)0.0f);
        HazelcastTestSupport.assertThrows(ArithmeticException.class, () -> ExpressionMath.divideExact((float)10.0f, (float)0.0f));
    }
}

