/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.DoubleBiFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DoubleBiFunctionIntegrationTest
extends ExpressionTestSupport {
    @Parameterized.Parameter
    public FunctionInfo function;

    @Parameterized.Parameters(name="function: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new FunctionInfo("ATAN2", 1)}, {new FunctionInfo("POWER", 0)});
    }

    @Test
    public void testColumn() {
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), this.sql("field1,  field1"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue((byte)1, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue((short)1, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(1, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(1L, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(1L, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(BigInteger.ONE, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(BigDecimal.ONE, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckValue(1.0, this.sql("this, this"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.putAndCheckFailure(Character.valueOf('1'), this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure("1", this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(true, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, this.sql("this, this"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.OBJECT, SqlColumnType.OBJECT), new Object[0]);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkValue0(this.sql("1, null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(this.sql("null, 1"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(this.sql("null, null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(this.sql("1, 1"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.checkValue0(this.sql("100, 100"), SqlColumnType.DOUBLE, this.function.process(100.0, 100.0), new Object[0]);
        this.checkValue0(this.sql("1.0001, 1.0001"), SqlColumnType.DOUBLE, this.function.process(1.0001, 1.0001), new Object[0]);
        this.checkValue0(this.sql("0.0001, 0.0001"), SqlColumnType.DOUBLE, this.function.process(1.0E-4, 1.0E-4), new Object[0]);
        this.checkValue0(this.sql("1.0, 1E0"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.checkValue0(this.sql("1.0, 1.0"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.checkValue0(this.sql("1E0, 1E0"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), new Object[0]);
        this.checkFailure0(this.sql("false, true"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql("'1', '1'"), 1008, DoubleBiFunctionIntegrationTest.signatureErrorFunction(this.function.name, SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, null, null, null);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), (byte)1, (byte)1);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), (short)1, (short)1);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), 1, 1);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), 1L, 1L);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), BigInteger.ONE, BigInteger.ONE);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), BigDecimal.ONE, BigDecimal.ONE);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), Float.valueOf(1.0f), Float.valueOf(1.0f));
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.0, 1.0), 1.0, 1.0);
        this.checkValue0(this.sql("?, ?"), SqlColumnType.DOUBLE, this.function.process(1.001, 1.001), 1.001, 1.001);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), Character.valueOf('1'), Character.valueOf('1'));
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "1", "1");
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true, false);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL, LOCAL_DATE_VAL);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL, LOCAL_TIME_VAL);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL, LOCAL_DATE_TIME_VAL);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL, OFFSET_DATE_TIME_VAL);
        this.checkFailure0(this.sql("?, ?"), 2000, DoubleBiFunctionIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL, OBJECT_VAL);
    }

    private String sql(String operand) {
        return "SELECT " + this.function.name + "(" + operand + ") FROM map";
    }

    @Test
    public void testEquals() {
        DoubleBiFunction function = DoubleBiFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)this.function.code);
        DoubleBiFunction sameFunction = DoubleBiFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)this.function.code);
        DoubleBiFunction differentFunction = DoubleBiFunction.create((Expression)ConstantExpression.create((Object)0.5, (QueryDataType)QueryDataType.DOUBLE), (Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)this.function.code);
        DoubleBiFunctionIntegrationTest.checkEquals(function, sameFunction, true);
        DoubleBiFunctionIntegrationTest.checkEquals(function, differentFunction, false);
    }

    @Test
    public void testSerialization() {
        DoubleBiFunction original = DoubleBiFunction.create((Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (Expression)ConstantExpression.create((Object)1.0, (QueryDataType)QueryDataType.DOUBLE), (int)this.function.code);
        DoubleBiFunction restored = (DoubleBiFunction)DoubleBiFunctionIntegrationTest.serializeAndCheck(original, 72);
        DoubleBiFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private static final class FunctionInfo {
        public final int code;
        public final String name;

        private FunctionInfo(String name, int code) {
            this.code = code;
            this.name = name;
        }

        public Double process(Double lhs, Double rhs) {
            if (lhs == null || rhs == null) {
                return null;
            }
            switch (this.code) {
                case 0: {
                    return Math.pow(lhs, rhs);
                }
                case 1: {
                    return Math.atan2(lhs, rhs);
                }
            }
            throw new UnsupportedOperationException("Unsupported mode: " + this.code);
        }

        public String toString() {
            return this.name;
        }
    }
}

