/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class JsonQueryFunctionIntegrationTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() {
        JsonQueryFunctionIntegrationTest.initialize((int)2, null);
    }

    @Test
    public void test_string() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"[1,2,3]");
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[*]?(@ > 1)' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[2,3]")));
    }

    @Test
    public void test_hazelcastJsonValue() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonQueryFunctionIntegrationTest.json("[1,2,3]"));
        JsonQueryFunctionIntegrationTest.createMapping("test", "bigint", "json");
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[*]?(@ > 1)' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[2,3]")));
    }

    @Test
    public void test_objectWithJsonField() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)new ObjectWithJson(1L, "[1,2,3]"));
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, ObjectWithJson.class);
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(jsonValue, '$'), id FROM test", JsonQueryFunctionIntegrationTest.rows(2, JsonQueryFunctionIntegrationTest.json("[1,2,3]"), 1L));
    }

    @Test
    public void test_extendedSyntax() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)JsonQueryFunctionIntegrationTest.json(""));
        test.put((Object)2L, (Object)JsonQueryFunctionIntegrationTest.json("[1,2,"));
        JsonQueryFunctionIntegrationTest.createMapping("test", "bigint", "json");
        Assert.assertNull((Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' NULL ON EMPTY) AS c1 FROM test WHERE __key = 1"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' EMPTY ARRAY ON EMPTY) AS c1 FROM test WHERE __key = 1"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("{}"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' EMPTY OBJECT ON EMPTY) AS c1 FROM test WHERE __key = 1"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$' ERROR ON EMPTY) AS c1 FROM test WHERE __key = 1")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_QUERY evaluated to no value");
        Assert.assertNull((Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' NULL ON ERROR) AS c1 FROM test WHERE __key = 2"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' EMPTY ARRAY ON ERROR) AS c1 FROM test WHERE __key = 2"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("{}"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$' EMPTY OBJECT ON ERROR) AS c1 FROM test WHERE __key = 2"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$' ERROR ON ERROR) AS c1 FROM test WHERE __key = 2")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_QUERY failed");
    }

    @Test
    public void test_defaultWrapperBehavior() {
        this.initComplexObject();
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[1,\"2\",3,{\"t\":1}]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[0]') FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("{\"t\":1}"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[1]') FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("3"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[2]') FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("\"foo\""), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[3]') FROM test"));
    }

    @Test
    public void test_noArrayWrapper() {
        this.initComplexObject();
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[1,\"2\",3,{\"t\":1}]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[0]' WITHOUT WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("{\"t\":1}"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[1]' WITHOUT WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("3"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[2]' WITHOUT WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("\"foo\""), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[3]' WITHOUT WRAPPER) FROM test"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]' WITHOUT WRAPPER ERROR ON ERROR) FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("JSON_QUERY evaluated to multiple values");
    }

    @Test
    public void test_conditionalArrayWrapper() {
        this.initComplexObject();
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[1,\"2\",3,{\"t\":1}]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[0]' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("{\"t\":1}"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[1]' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("3"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[2]' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("\"foo\""), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[3]' WITH CONDITIONAL WRAPPER) FROM test"));
    }

    @Test
    public void test_unconditionalArrayWrapper() {
        this.initComplexObject();
        Assert.assertEquals((Object)"[[1,\"2\",3,{\"t\":1}]]", (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[0]' WITH UNCONDITIONAL ARRAY WRAPPER) FROM test").toString());
        Assert.assertEquals((Object)"[{\"t\":1}]", (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[1]' WITH UNCONDITIONAL ARRAY WRAPPER) FROM test").toString());
        Assert.assertEquals((Object)"[3]", (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[2]' WITH UNCONDITIONAL ARRAY WRAPPER ERROR ON ERROR) FROM test").toString());
    }

    @Test
    public void test_invalidJsonPath() {
        this.initComplexObject();
        JsonQueryFunctionIntegrationTest.createMapping("test2", Long.class, ObjectWithJson.class);
        JsonQueryFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test2 (__key, id) VALUES (1, 1)", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '') FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Invalid SQL/JSON path expression: Unexpected token at line 1, column 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$((@@$#229))') FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Invalid SQL/JSON path expression: Unexpected token at line 1, columns 1 to 2");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY('[1,2,3]', jsonValue) FROM test2")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("SQL/JSON path expression cannot be null");
    }

    @Test
    public void when_strictJsonPathMode_then_failNotSupported() {
        this.initComplexObject();
        JsonQueryFunctionIntegrationTest.createMapping("test2", Long.class, ObjectWithJson.class);
        JsonQueryFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test2 (__key, id) VALUES (1, 1)", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, 'strict $[*]') FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Strict SQL/JSON path mode not supported");
    }

    @Test
    public void test_testLaxJsonPathMode() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"[1,2,3]");
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, 'lax $[*]?(@ > 1)' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[2,3]")));
    }

    @Test
    public void test_nullLiteral() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(null, null)")).isInstanceOf(HazelcastSqlException.class)).hasRootCauseMessage("SQL/JSON path expression cannot be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY('foo', null)")).isInstanceOf(HazelcastSqlException.class)).hasRootCauseMessage("SQL/JSON path expression cannot be null");
        Assert.assertNull((Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(null, '$.a')"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("null"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY('{\"a\":null}', '$.a')"));
    }

    @Test
    public void test_arrayIndex() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"[1,2,3]");
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[0 to 2]' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[1,2,3]")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[0 to 1]' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[1,2]")));
    }

    @Test
    public void test_quotedPropName() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"{\"first name\":\"value\"}");
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$.\"first name\"' WITH ARRAY WRAPPER) FROM test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[\"value\"]")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$.[\"first name\"]' WITH ARRAY WRAPPER) FROM test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Invalid SQL/JSON path expression: Line 1, column 2: no viable alternative at input '.['");
    }

    @Test
    public void when_singleQuotedString_then_notSupported() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        test.put((Object)1L, (Object)"{\"a\":\"b\"}");
        JsonQueryFunctionIntegrationTest.createMapping("test", Long.class, String.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$.''a''') from test")).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Line 1, column 2: token recognition error at: '''");
    }

    @Test
    public void test_onEmptyBehavior() {
        this.initComplexObject();
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]') from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY('', '$[4]') from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(null, '$[4]') from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' NULL ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY('', '$[4]' NULL ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(null, '$[4]' NULL ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$[4]' ERROR ON EMPTY) from test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("JSON_QUERY evaluated to no value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY('', '$[4]' ERROR ON EMPTY) from test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("JSON_QUERY evaluated to no value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(null, '$[4]' ERROR ON EMPTY) from test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("JSON_QUERY evaluated to no value");
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' EMPTY OBJECT ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("{}")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY('', '$[4]' EMPTY OBJECT ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("{}")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(null, '$[4]' EMPTY OBJECT ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("{}")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' EMPTY ARRAY ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[]")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY('', '$[4]' EMPTY ARRAY ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[]")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(null, '$[4]' EMPTY ARRAY ON EMPTY) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[]")));
    }

    @Test
    public void test_onErrorBehavior() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        JsonQueryFunctionIntegrationTest.createMapping("test", "bigint", "json");
        test.put((Object)1L, (Object)JsonQueryFunctionIntegrationTest.json("bad json"));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' NULL ON ERROR) from test", JsonQueryFunctionIntegrationTest.rows(1, new Object[]{null}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonQueryFunctionIntegrationTest.query("SELECT JSON_QUERY(this, '$[4]' ERROR ON ERROR) from test")).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Failed to parse JSON document");
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' EMPTY OBJECT ON ERROR) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("{}")));
        JsonQueryFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_QUERY(this, '$[4]' EMPTY ARRAY ON ERROR) from test", JsonQueryFunctionIntegrationTest.rows(1, JsonQueryFunctionIntegrationTest.json("[]")));
    }

    @Test
    public void test_jsonPathLikeRegex() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        JsonQueryFunctionIntegrationTest.createMapping("test", "bigint", "json");
        test.put((Object)1L, (Object)JsonQueryFunctionIntegrationTest.json("[\"alpha\",\"alpha1\",\"beta\",\"BETA\",1,22,\"foo\",\"\\\"quoted \\\"\"]"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[\"alpha\",\"alpha1\"]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"alpha\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("\"alpha\""), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"(alpha)$\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[\"beta\",\"BETA\"]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"(?i)beta\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[\"alpha1\",1,22]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"\\\\d\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("22"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"\\\\d{2}\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("[\"alpha\",\"alpha1\",\"beta\",\"BETA\",1,22,\"foo\",\"\\\"quoted \\\"\"]"), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"\")' WITH CONDITIONAL WRAPPER) FROM test"));
        Assert.assertEquals((Object)JsonQueryFunctionIntegrationTest.json("\"\\\"quoted \\\"\""), (Object)JsonQueryFunctionIntegrationTest.querySingleValue("SELECT JSON_QUERY(this, '$[*]?(@ like_regex \"\\\"quoted\\\\s\\\"\")' WITH CONDITIONAL WRAPPER) FROM test"));
    }

    protected void initComplexObject() {
        IMap test = JsonQueryFunctionIntegrationTest.instance().getMap("test");
        JsonQueryFunctionIntegrationTest.createMapping("test", "bigint", "json");
        test.put((Object)1L, (Object)JsonQueryFunctionIntegrationTest.json("[[1,\"2\",3,{\"t\":1}],{\"t\":1},3,\"foo\"]"));
    }

    public static class ObjectWithJson
    implements Serializable {
        private Long id;
        private String jsonValue;

        public ObjectWithJson() {
        }

        public ObjectWithJson(Long id, String jsonValue) {
            this.id = id;
            this.jsonValue = jsonValue;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getJsonValue() {
            return this.jsonValue;
        }

        public void setJsonValue(String jsonValue) {
            this.jsonValue = jsonValue;
        }
    }
}

