/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.AllTypesValue;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class JsonArrayFunctionIntegrationTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() {
        JsonArrayFunctionIntegrationTest.initialize((int)1, null);
    }

    @Test
    public void test_basicCreation() {
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(1, 2, 3)", this.jsonArrayRow(1, 2, 3));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY('a', 2, 'b', 5.0)", this.jsonArrayRow("a", 2, "b", 5.0));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(1, null, 3 NULL ON NULL)", this.jsonArrayRow(1, null, 3));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY('a', null, 'b', null ABSENT ON NULL)", this.jsonArrayRow("a", "b"));
    }

    @Test
    public void test_creationFromTableColumns() {
        JsonArrayFunctionIntegrationTest.createMapping("test", Long.class, ClassObj.class);
        JsonArrayFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test (__key, id, name, a, b, c) VALUES (1, 1, 'testValue', 1, 2, 3)", new Object[0]);
        JsonArrayFunctionIntegrationTest.instance().getSql().execute("INSERT INTO test (__key, id, a, b) VALUES (2, 2, 1, 2)", new Object[0]);
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(a, b, c) FROM test WHERE __key = 1", this.jsonArrayRow(1, 2, 3));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(id, name, a, b, c) FROM test WHERE __key = 1", this.jsonArrayRow(1L, "testValue", 1L, 2L, 3L));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(id, name, a, b, c NULL ON NULL) FROM test WHERE __key = 2", this.jsonArrayRow(2L, null, 1L, 2L, null));
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(id, name, a, b, c ABSENT ON NULL) FROM test WHERE __key = 2", this.jsonArrayRow(2L, 1L, 2L));
    }

    @Test
    public void test_dateTimeFormats_parameter() {
        LocalTime time = LocalTime.of(13, 0, 0);
        LocalDate date = LocalDate.of(2020, 1, 1);
        LocalDateTime dateTime = LocalDateTime.of(2020, 1, 1, 13, 0, 0);
        OffsetDateTime dateTimeTz = OffsetDateTime.of(dateTime, ZoneOffset.UTC);
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(?, ?, ?, ?)", Arrays.asList(time, date, dateTime, dateTimeTz), this.jsonArrayRow("13:00", "2020-01-01", "2020-01-01T13:00", "2020-01-01T13:00Z"));
    }

    @Test
    public void test_dateTimeFormats_column() {
        JsonArrayFunctionIntegrationTest.createMapping("m", Integer.class, AllTypesValue.class);
        JsonArrayFunctionIntegrationTest.instance().getMap("m").put((Object)42, (Object)AllTypesValue.testValue());
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("SELECT JSON_ARRAY(\"localTime\", \"localDate\", \"localDateTime\", \"date\", \"calendar\", \"instant\", \"zonedDateTime\", \"offsetDateTime\") from m", this.jsonArrayRow("12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", OffsetDateTime.ofInstant(AllTypesValue.testValue().getDate().toInstant(), ZoneId.systemDefault()).toString(), "2020-04-15T12:23:34.200Z", OffsetDateTime.ofInstant(AllTypesValue.testValue().getInstant(), ZoneId.systemDefault()).toString(), "2020-04-15T12:23:34.200Z", "2020-04-15T12:23:34.200Z"));
    }

    @Test
    public void test_nestedJson() {
        JsonArrayFunctionIntegrationTest.assertRowsAnyOrder("select json_array(cast('\"foo\"' as json),cast('42' as json),cast('[1,2,3]' as json))", JsonArrayFunctionIntegrationTest.rows(1, JsonArrayFunctionIntegrationTest.json("[\"foo\",42,[1,2,3]]")));
    }

    private List<SqlTestSupport.Row> jsonArrayRow(Object ... values) {
        return JsonArrayFunctionIntegrationTest.rows(1, JsonArrayFunctionIntegrationTest.json(JsonArrayFunctionIntegrationTest.jsonString(values)));
    }

    public static final class ClassObj
    implements Serializable {
        public Long id;
        public String name;
        public Long a;
        public Long b;
        public Long c;

        public ClassObj() {
        }

        public ClassObj(Long id, String name, Long a, Long b, Long c) {
            this.id = id;
            this.name = name;
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }
}

