/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.PersonId;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlService;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPlanCacheTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlPlanCacheTest.initialize((int)1, null);
        sqlService = SqlPlanCacheTest.instance().getSql();
    }

    @Test
    public void test_tableName() {
        SqlPlanCacheTest.createMapping("map1", "m", "id", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("map2", "m", "id", PersonId.class, "varchar");
        sqlService.execute("DROP MAPPING map1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_mapName() {
        SqlPlanCacheTest.createMapping("map", "m1", "id", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("map", "m2", "id", PersonId.class, "varchar");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_fieldList() {
        SqlPlanCacheTest.createMapping("map", "m", "id1", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("map", "m", "id2", PersonId.class, "varchar");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_keyDescriptor() {
        SqlPlanCacheTest.createMapping("map", "m", "id", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("map", "m", "id", 1, 2, "varchar");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_valueDescriptor() {
        SqlPlanCacheTest.createMapping("map", "m", "id", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("map", "m", "id", PersonId.class, "json-flat");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_conflictingSchemas() {
        SqlPlanCacheTest.createMapping("map", "m", "id", PersonId.class, "varchar");
        sqlService.execute("SELECT * FROM map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.instance().getMap("map").put((Object)1, (Object)"1");
        sqlService.execute("DROP MAPPING map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_index() {
        IMap map = SqlPlanCacheTest.instance().getMap("m");
        SqlPlanCacheTest.createMapping("map", map.getName(), "id", PersonId.class, "varchar");
        String indexName = SqlPlanCacheTest.randomName();
        map.addIndex(new IndexConfig(IndexType.SORTED, new String[]{"__key.id"}).setName(indexName));
        sqlService.execute("SELECT * FROM map ORDER BY id", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.mapContainer(map).getGlobalIndexRegistry().destroyIndexes();
        map.addIndex(new IndexConfig(IndexType.HASH, new String[]{"__key.id"}).setName(indexName));
        SqlPlanCacheTest.assertTrueEventually(() -> Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero());
    }

    @Test
    public void test_dmlCaching() {
        SqlPlanCacheTest.createMapping("map", "m", "id", PersonId.class, "varchar");
        sqlService.execute("INSERT INTO map (id, this) VALUES(0, 'value-0')", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        sqlService.execute("SINK INTO map (id, this) VALUES(0, 'value-0')", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(2);
        sqlService.execute("UPDATE map SET this = 'value-1' WHERE id = 0", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(3);
        sqlService.execute("DELETE FROM map WHERE id = 0", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(4);
        sqlService.execute("DROP MAPPING map", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    private static void createMapping(String name, String mapName, String keyFieldName, Class<?> keyClass, String valueFormat) {
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " EXTERNAL NAME " + mapName + " (" + keyFieldName + " INT EXTERNAL NAME \"__key.id\") TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + keyClass.getName() + "', 'valueFormat'='" + valueFormat + "')", new Object[0]);
    }

    private static void createMapping(String name, String mapName, String keyFieldName, int keyFactoryId, int keyClassId, String valueFormat) {
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " EXTERNAL NAME " + mapName + "(" + keyFieldName + " INT EXTERNAL NAME \"__key.id\") TYPE IMap OPTIONS ( 'keyFormat'='portable', 'keyPortableFactoryId'='" + keyFactoryId + "', 'keyPortableClassId'='" + keyClassId + "', 'valueFormat'='" + valueFormat + "')", new Object[0]);
    }
}

