/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.PersonId;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlResult;
import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlDeleteTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUpClass() {
        SqlDeleteTest.initialize((int)2, null);
    }

    @Test
    public void deleteBySingleKey() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(1);
        this.checkUpdateCount("delete from test_map where __key = 1", 0);
        this.assertMapDoesNotContainKey(1);
        this.put(1);
        this.checkUpdateCount("delete from test_map where 1 = __key", 0);
        this.assertMapDoesNotContainKey(1);
        this.put(1);
        this.checkUpdateCount("delete from test_map where 2 = __key", 0);
        this.assertMapContainsKey(1);
        this.put(1, 1);
        this.checkUpdateCount("delete from test_map where __key = this", 0);
        this.assertMapDoesNotContainKey(1);
    }

    @Test
    public void deleteBySingleKeyExpression() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(2);
        this.checkUpdateCount("delete from test_map where __key = 1 + 1 ", 0);
        this.assertMapDoesNotContainKey(2);
        this.put(1, 1);
        this.checkUpdateCount("delete from test_map where __key = this + 0", 0);
        this.assertMapDoesNotContainKey(1);
    }

    @Test
    public void deleteWithoutKeyInPredicate() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(1, 1);
        this.checkUpdateCount("delete from test_map where this = 1", 0);
        this.assertMapDoesNotContainKey(1);
        this.put(1, 1);
        this.checkUpdateCount("delete from test_map where 1 = this", 0);
        this.assertMapDoesNotContainKey(1);
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Person.class);
        this.put(1, new Person("name", 18));
        this.checkUpdateCount("delete from test_map where name = 'name' and age = 18", 0);
        this.assertMapDoesNotContainKey(1);
    }

    @Test
    public void deleteByKey_andAnotherFields() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Person.class);
        this.put(1, new Person("name1", 18));
        this.checkUpdateCount("delete from test_map where __key = 1 and age = 18", 0);
        this.assertMapDoesNotContainKey(1);
        this.put(1, new Person("name1", 18));
        this.checkUpdateCount("delete from test_map where __key = 1 and age = 50", 0);
        this.assertMapContainsKey(1);
    }

    @Test
    public void deleteWithDisjunctionPredicate_whenOnlyKeysInPredicate() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(1);
        this.put(2);
        this.checkUpdateCount("delete from test_map where __key = 1 or __key = 2", 0);
        this.assertMapDoesNotContainKey(1);
        this.assertMapDoesNotContainKey(2);
    }

    @Test
    public void deleteThatDoesNotCheckKeyForEquality_fails() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(10);
        this.checkUpdateCount("delete from test_map where __key > 1", 0);
        this.assertMapDoesNotContainKey(10);
    }

    @Test
    public void doNotDelete_whenKeyFieldOccursMoreThanOnceWithConjunctionPredicate() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(1);
        this.checkUpdateCount("delete from test_map where __key = 1 and __key = 2", 0);
        this.assertMapContainsKey(1);
    }

    @Test
    public void doNotDelete_whenAlwaysFalsePredicate() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        this.put(1);
        this.checkUpdateCount("delete from test_map where 1 = 2", 0);
        this.assertMapContainsKey(1);
    }

    @Test
    public void explicitMapping() {
        String name = SqlDeleteTest.randomName();
        this.execute("create mapping " + name + " (\n__key INT,\nthis INT\n)\nTYPE imap\nOPTIONS (\n'keyFormat' = 'int',\n'valueFormat' = 'int'\n)", new Object[0]);
        SqlDeleteTest.instance().getMap(name).put((Object)1, (Object)1);
        this.assertMapContainsKey(name, 1);
        this.execute("delete from " + name + " where __key = 1", new Object[0]);
        this.assertMapDoesNotContainKey(name, 1);
        SqlDeleteTest.instance().getMap(name).put((Object)1, (Object)1);
        this.assertMapContainsKey(name, 1);
        this.execute("delete from " + name + " where this = 1", new Object[0]);
        this.assertMapDoesNotContainKey(name, 1);
    }

    @Test
    public void deleteByDynamicParam() {
        SqlDeleteTest.createMapping("test_map", Integer.TYPE, Integer.TYPE);
        IMap map = SqlDeleteTest.instance().getMap("test_map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        this.execute("delete from test_map where __key = ?", 2);
        this.assertMapContainsKey(1);
        this.assertMapDoesNotContainKey(2);
        this.assertMapContainsKey(3);
    }

    @Test
    public void deleteByComplexKey() {
        SqlDeleteTest.createMapping("test_map", PersonId.class, Integer.class);
        IMap map = SqlDeleteTest.instance().getMap("test_map");
        map.put(new PersonId(1), 1);
        SqlDeleteTest.instance().getSql().execute("DELETE FROM test_map WHERE __key = ?", new Object[]{new PersonId(1)});
        Assertions.assertThat((Map)map).isEmpty();
    }

    @Test
    public void when_deleteFromUnknownMapping_then_throws() {
        Assertions.assertThatThrownBy(() -> this.execute("delete from test_map where __key = 1", new Object[0])).hasMessageContaining("Object 'test_map' not found");
    }

    private SqlResult execute(String sql, Object ... arguments) {
        return SqlDeleteTest.instance().getSql().execute(sql, arguments);
    }

    private void checkUpdateCount(String sql, int expected) {
        Assertions.assertThat((long)this.execute(sql, new Object[0]).updateCount()).isEqualTo((long)expected);
    }

    private void put(Object key, Object value) {
        IMap map = SqlDeleteTest.instance().getMap("test_map");
        map.clear();
        map.put(key, value);
    }

    private void put(Object key) {
        this.put(key, key);
    }

    private void assertMapDoesNotContainKey(int key) {
        this.assertMapDoesNotContainKey("test_map", key);
    }

    private void assertMapDoesNotContainKey(String mapName, int key) {
        IMap test_map = SqlDeleteTest.instance().getMap(mapName);
        Assertions.assertThat((boolean)test_map.containsKey((Object)key)).isFalse();
    }

    private void assertMapContainsKey(int key) {
        this.assertMapContainsKey("test_map", key);
    }

    private void assertMapContainsKey(String mapName, int key) {
        IMap test_map = SqlDeleteTest.instance().getMap(mapName);
        Assertions.assertThat((boolean)test_map.containsKey((Object)key)).isTrue();
    }

    public static class Person
    implements Serializable {
        public String name;
        public int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }
}

