/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.TestUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.QueryUtil;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryUtilTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        QueryUtilTest.initialize((int)1, null);
    }

    @Test
    public void when_leftValueIsNull_then_returnsNull() {
        Predicate predicate = QueryUtil.toPredicate((JetSqlRow)new JetSqlRow((SerializationService)TEST_SS, new Object[1]), (int[])new int[]{0}, (int[])new int[]{0}, (QueryPath[])new QueryPath[]{QueryPath.KEY_PATH});
        Assertions.assertThat((Object)predicate).isNull();
    }

    @Test
    public void when_serializedObject_then_deserializedCorrect() {
        AbstractSerializationService service = (AbstractSerializationService)TestUtil.getNode((HazelcastInstance)QueryUtilTest.instance()).getSerializationService();
        ExpressionEvalContext evalContextMock = (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class);
        Mockito.when((Object)evalContextMock.getSerializationService()).thenReturn((Object)((InternalSerializationService)Mockito.mock((Object[])new InternalSerializationService[0])));
        Mockito.when((Object)evalContextMock.getArguments()).thenReturn(Collections.emptyList());
        Mockito.when((Object)evalContextMock.getNodeEngine()).thenReturn((Object)((NodeEngine)Mockito.mock((Object[])new NodeEngine[0])));
        KvRowProjector.Supplier supplier = KvRowProjector.supplier((QueryPath[])new QueryPath[0], (QueryDataType[])new QueryDataType[0], null, null, null, null);
        DataSerializable projection = (DataSerializable)QueryUtil.toProjection((KvRowProjector.Supplier)supplier, (ExpressionEvalContext)evalContextMock);
        Data data = service.toData((Object)projection);
        Object actual = service.toObject((Object)data);
        Assertions.assertThat((Object)actual).usingRecursiveComparison().comparingOnlyFields(new String[]{"arguments"}).isEqualTo((Object)projection);
    }
}

