/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJsonResolver;
import com.hazelcast.jet.sql.impl.extract.JsonQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.JsonUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class KvMetadataJsonResolverTest {
    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveFields(boolean key, String prefix) {
        Stream fields = KvMetadataJsonResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJsonResolverTest.field("field", QueryDataType.INT, prefix + ".field")), Collections.emptyMap(), null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{KvMetadataJsonResolverTest.field("field", QueryDataType.INT, prefix + ".field")});
    }

    @Test
    @Parameters(value={"true", "false"})
    public void when_noKeyOrThisPrefixInExternalName_then_usesValue(boolean key) {
        Object[] objectArray;
        KvMetadata metadata = KvMetadataJsonResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(KvMetadataJsonResolverTest.field("field", QueryDataType.INT, "extField")), Collections.emptyMap(), null);
        ListAssert listAssert = Assertions.assertThat((List)metadata.getFields());
        if (key) {
            Object[] objectArray2 = new MapTableField[1];
            objectArray = objectArray2;
            objectArray2[0] = new MapTableField("__key", QueryDataType.OBJECT, true, QueryPath.KEY_PATH);
        } else {
            MapTableField[] mapTableFieldArray = new MapTableField[2];
            mapTableFieldArray[0] = new MapTableField("field", QueryDataType.INT, false, new QueryPath("extField", false));
            objectArray = mapTableFieldArray;
            mapTableFieldArray[1] = new MapTableField("this", QueryDataType.OBJECT, true, QueryPath.VALUE_PATH);
        }
        listAssert.containsExactly(objectArray);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_duplicateExternalName_then_throws(boolean key, String prefix) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJsonResolver.INSTANCE.resolveAndValidateFields(key, Arrays.asList(KvMetadataJsonResolverTest.field("field1", QueryDataType.INT, prefix + ".field"), KvMetadataJsonResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field")), Collections.emptyMap(), null)).isInstanceOf(QueryException.class)).hasMessageMatching("Duplicate external name: (__key|this).field");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveMetadata(boolean key, String prefix) {
        KvMetadata metadata = KvMetadataJsonResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(KvMetadataJsonResolverTest.field("field", QueryDataType.INT, prefix + ".field")), Collections.emptyMap(), null);
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("field", QueryDataType.INT, false, QueryPath.create((String)(prefix + ".field"))), new MapTableField(prefix, QueryDataType.OBJECT, true, QueryPath.create((String)prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)JsonQueryTargetDescriptor.INSTANCE);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualTo((Object)JsonUpsertTargetDescriptor.INSTANCE);
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }
}

