/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class KvMetadataJavaResolverTest {
    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolvePrimitiveField(boolean key, String path) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Integer.TYPE.getName());
        Stream fields = KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.emptyList(), options, null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{KvMetadataJavaResolverTest.field(path, QueryDataType.INT, QueryPath.create((String)path).toString())});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_renamesPrimitiveField_then_throws(boolean key, String path) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Integer.TYPE.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field("renamed_field", QueryDataType.INT, path)), options, null)).isInstanceOf(QueryException.class)).hasMessageMatching("Cannot rename field: '" + path + "'");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_typeMismatchBetweenPrimitiveDeclaredAndSchemaField_then_throws(boolean key, String path) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Integer.TYPE.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field(path, QueryDataType.VARCHAR, path)), options, null)).isInstanceOf(QueryException.class)).hasMessageMatching("Mismatch between declared and resolved type for field '(__key|this)'");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresPrimitiveAdditionalField_then_throws(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Integer.TYPE.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field("field", QueryDataType.INT, prefix + ".field")), options, null)).isInstanceOf(QueryException.class)).hasMessage("The field '" + prefix + "' is of type INTEGER, you can't map '" + prefix + ".field' too");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolvePrimitiveMetadata(boolean key, String path) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Integer.TYPE.getName());
        KvMetadata metadata = KvMetadataJavaResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(KvMetadataJavaResolverTest.field(path, QueryDataType.INT, path)), options, null);
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField(path, QueryDataType.INT, false, QueryPath.create((String)path))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)GenericQueryTargetDescriptor.DEFAULT);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualTo((Object)PrimitiveUpsertTargetDescriptor.INSTANCE);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveObjectFields(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        Stream fields = KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.emptyList(), options, null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{KvMetadataJavaResolverTest.field("field", QueryDataType.INT, prefix + ".field")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresObjectField_then_itsNameHasPrecedenceOverResolvedOne(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        Stream fields = KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field("renamed_field", QueryDataType.INT, prefix + ".field")), options, null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{KvMetadataJavaResolverTest.field("renamed_field", QueryDataType.INT, prefix + ".field")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresFields_then_fieldsFromClassNotAdded(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        Stream fields = KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field2")), options, null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{KvMetadataJavaResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field2")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_typeMismatchBetweenObjectDeclaredAndSchemaField_then_throws(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(KvMetadataJavaResolverTest.field("field", QueryDataType.VARCHAR, prefix + ".field")), options, null)).isInstanceOf(QueryException.class)).hasMessageContaining("Mismatch between declared and resolved type for field 'field'");
    }

    @Test
    @Parameters(value={"true", "false"})
    public void when_noKeyOrThisPrefixInExternalName_then_usesValue(boolean key) {
        Object[] objectArray;
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Object.class.getName());
        KvMetadata metadata = KvMetadataJavaResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(KvMetadataJavaResolverTest.field("field", QueryDataType.INT, "extField")), options, null);
        ListAssert listAssert = Assertions.assertThat((List)metadata.getFields());
        if (key) {
            Object[] objectArray2 = new MapTableField[1];
            objectArray = objectArray2;
            objectArray2[0] = new MapTableField("__key", QueryDataType.OBJECT, true, QueryPath.KEY_PATH);
        } else {
            MapTableField[] mapTableFieldArray = new MapTableField[2];
            mapTableFieldArray[0] = new MapTableField("field", QueryDataType.INT, false, new QueryPath("extField", false));
            objectArray = mapTableFieldArray;
            mapTableFieldArray[1] = new MapTableField("this", QueryDataType.OBJECT, true, QueryPath.VALUE_PATH);
        }
        listAssert.containsExactly(objectArray);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresObjectDuplicateExternalName_then_throws(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataJavaResolver.INSTANCE.resolveAndValidateFields(key, Arrays.asList(KvMetadataJavaResolverTest.field("field1", QueryDataType.INT, prefix + ".field"), KvMetadataJavaResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field")), options, null)).isInstanceOf(QueryException.class)).hasMessageMatching("Duplicate external name: (__key|this).field");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveMetadata(boolean key, String prefix) {
        Map<String, String> options = Map.of(key ? "keyFormat" : "valueFormat", "java", key ? "keyJavaClass" : "valueJavaClass", Type.class.getName());
        KvMetadata metadata = KvMetadataJavaResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(KvMetadataJavaResolverTest.field("field", QueryDataType.INT, prefix + ".field")), options, null);
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("field", QueryDataType.INT, false, QueryPath.create((String)(prefix + ".field"))), new MapTableField(prefix, QueryDataType.OBJECT, true, QueryPath.create((String)prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)GenericQueryTargetDescriptor.DEFAULT);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualToComparingFieldByField((Object)new PojoUpsertTargetDescriptor(Type.class.getName(), Map.of("field", Integer.TYPE.getName())));
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }

    private static final class Type {
        public int field;

        private Type() {
        }
    }
}

