/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.kafka.HazelcastKafkaAvroDeserializer;
import com.hazelcast.jet.kafka.HazelcastKafkaAvroSerializer;
import com.hazelcast.jet.sql.impl.connector.kafka.PropertiesResolver;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class PropertiesResolverTest {
    private static final String UNKNOWN_FORMAT = "unknown";
    private static final Schema DUMMY_SCHEMA = (Schema)SchemaBuilder.record((String)"jet.sql").fields().endRecord();

    @Test
    public void test_consumerProperties_absentFormat() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Collections.emptyMap())).containsExactlyEntriesOf(Map.of("key.deserializer", ByteArrayDeserializer.class.getCanonicalName()));
    }

    @Test
    public void test_producerProperties_absentFormat() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Collections.emptyMap())).containsExactlyEntriesOf(Map.of("key.serializer", ByteArraySerializer.class.getCanonicalName()));
    }

    @Test
    public void when_consumerProperties_formatIsUnknown_then_itIsIgnored() {
        Map<String, String> keyOptions = Map.of("keyFormat", UNKNOWN_FORMAT);
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(keyOptions)).isEmpty();
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", UNKNOWN_FORMAT);
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(valueOptions)).isEmpty();
    }

    @Test
    public void when_producerProperties_formatIsUnknown_then_itIsIgnored() {
        Map<String, String> keyOptions = Map.of("keyFormat", UNKNOWN_FORMAT);
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(keyOptions)).isEmpty();
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", UNKNOWN_FORMAT);
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(valueOptions)).isEmpty();
    }

    private Object[] consumerValues() {
        return new Object[]{new Object[]{Short.class.getName(), ShortDeserializer.class.getCanonicalName()}, new Object[]{Short.TYPE.getName(), ShortDeserializer.class.getCanonicalName()}, new Object[]{Integer.class.getName(), IntegerDeserializer.class.getCanonicalName()}, new Object[]{Integer.TYPE.getName(), IntegerDeserializer.class.getCanonicalName()}, new Object[]{Long.class.getName(), LongDeserializer.class.getCanonicalName()}, new Object[]{Long.TYPE.getName(), LongDeserializer.class.getCanonicalName()}, new Object[]{Float.class.getName(), FloatDeserializer.class.getCanonicalName()}, new Object[]{Float.TYPE.getName(), FloatDeserializer.class.getCanonicalName()}, new Object[]{Double.class.getName(), DoubleDeserializer.class.getCanonicalName()}, new Object[]{Double.TYPE.getName(), DoubleDeserializer.class.getCanonicalName()}, new Object[]{String.class.getName(), StringDeserializer.class.getCanonicalName()}};
    }

    @Test
    @Parameters(method="consumerValues")
    public void test_consumerProperties_java(String clazz, String deserializer) {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", "java", "keyJavaClass", clazz))).containsExactlyEntriesOf(Map.of("key.deserializer", deserializer));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "java", "valueJavaClass", clazz))).containsExactlyEntriesOf(Map.of("value.deserializer", deserializer));
    }

    private Object[] producerValues() {
        return new Object[]{new Object[]{Short.class.getName(), ShortSerializer.class.getCanonicalName()}, new Object[]{Short.TYPE.getName(), ShortSerializer.class.getCanonicalName()}, new Object[]{Integer.class.getName(), IntegerSerializer.class.getCanonicalName()}, new Object[]{Integer.TYPE.getName(), IntegerSerializer.class.getCanonicalName()}, new Object[]{Long.class.getName(), LongSerializer.class.getCanonicalName()}, new Object[]{Long.TYPE.getName(), LongSerializer.class.getCanonicalName()}, new Object[]{Float.class.getName(), FloatSerializer.class.getCanonicalName()}, new Object[]{Float.TYPE.getName(), FloatSerializer.class.getCanonicalName()}, new Object[]{Double.class.getName(), DoubleSerializer.class.getCanonicalName()}, new Object[]{Double.TYPE.getName(), DoubleSerializer.class.getCanonicalName()}, new Object[]{String.class.getName(), StringSerializer.class.getCanonicalName()}};
    }

    @Test
    @Parameters(method="producerValues")
    public void test_producerProperties_java(String clazz, String serializer) {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", "java", "keyJavaClass", clazz))).containsExactlyEntriesOf(Map.of("key.serializer", serializer));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "java", "valueJavaClass", clazz))).containsExactlyEntriesOf(Map.of("value.serializer", serializer));
    }

    private Object[] classes() {
        return new Object[]{new Object[]{Short.class.getName()}, new Object[]{Short.TYPE.getName()}, new Object[]{Integer.class.getName()}, new Object[]{Integer.TYPE.getName()}, new Object[]{Long.class.getName()}, new Object[]{Long.TYPE.getName()}, new Object[]{Float.class.getName()}, new Object[]{Float.TYPE.getName()}, new Object[]{Double.class.getName()}, new Object[]{Double.TYPE.getName()}, new Object[]{String.class.getName()}};
    }

    @Test
    @Parameters(method="classes")
    public void when_consumerProperties_javaPropertyIsDefined_then_itsNotOverwritten(String clazz) {
        Map<String, String> keyOptions = Map.of("keyFormat", "java", "keyJavaClass", clazz, "key.deserializer", "deserializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(keyOptions)).containsExactlyEntriesOf(Map.of("key.deserializer", "deserializer"));
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "java", "valueJavaClass", clazz, "value.deserializer", "deserializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(valueOptions)).containsExactlyEntriesOf(Map.of("value.deserializer", "deserializer"));
    }

    @Test
    @Parameters(method="classes")
    public void when_producerProperties_javaPropertyIsDefined_then_itsNotOverwritten(String clazz) {
        Map<String, String> keyOptions = Map.of("keyFormat", "java", "keyJavaClass", clazz, "key.serializer", "serializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(keyOptions)).containsExactlyEntriesOf(Map.of("key.serializer", "serializer"));
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "java", "valueJavaClass", clazz, "value.serializer", "serializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(valueOptions)).containsExactlyEntriesOf(Map.of("value.serializer", "serializer"));
    }

    @Test
    public void test_consumerProperties_avro() {
        Assertions.assertThat((Map)PropertiesResolver.resolveConsumerProperties(Map.of("keyFormat", "avro"), (Object)DUMMY_SCHEMA, null)).containsExactlyInAnyOrderEntriesOf(Map.of("key.deserializer", HazelcastKafkaAvroDeserializer.class.getCanonicalName(), "keyAvroSchema", DUMMY_SCHEMA));
        Assertions.assertThat((Map)PropertiesResolver.resolveConsumerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro"), null, (Object)DUMMY_SCHEMA)).containsExactlyInAnyOrderEntriesOf(Map.of("value.deserializer", HazelcastKafkaAvroDeserializer.class.getCanonicalName(), "valueAvroSchema", DUMMY_SCHEMA));
    }

    @Test
    public void test_consumerProperties_avro_schemaRegistry() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", "avro", "schema.registry.url", "http://localhost:8081"))).containsExactlyInAnyOrderEntriesOf(Map.of("key.deserializer", KafkaAvroDeserializer.class.getCanonicalName(), "schema.registry.url", "http://localhost:8081"));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro", "schema.registry.url", "http://localhost:8081"))).containsExactlyInAnyOrderEntriesOf(Map.of("value.deserializer", KafkaAvroDeserializer.class.getCanonicalName(), "schema.registry.url", "http://localhost:8081"));
    }

    @Test
    public void test_producerProperties_avro() {
        Assertions.assertThat((Map)PropertiesResolver.resolveProducerProperties(Map.of("keyFormat", "avro"), (Object)DUMMY_SCHEMA, null)).containsExactlyInAnyOrderEntriesOf(Map.of("key.serializer", HazelcastKafkaAvroSerializer.class.getCanonicalName(), "keyAvroSchema", DUMMY_SCHEMA));
        Assertions.assertThat((Map)PropertiesResolver.resolveProducerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro"), null, (Object)DUMMY_SCHEMA)).containsExactlyInAnyOrderEntriesOf(Map.of("value.serializer", HazelcastKafkaAvroSerializer.class.getCanonicalName(), "valueAvroSchema", DUMMY_SCHEMA));
    }

    @Test
    public void test_producerProperties_avro_schemaRegistry() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", "avro", "schema.registry.url", "http://localhost:8081"))).containsExactlyInAnyOrderEntriesOf(Map.of("key.serializer", KafkaAvroSerializer.class.getCanonicalName(), "schema.registry.url", "http://localhost:8081"));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro", "schema.registry.url", "http://localhost:8081"))).containsExactlyInAnyOrderEntriesOf(Map.of("value.serializer", KafkaAvroSerializer.class.getCanonicalName(), "schema.registry.url", "http://localhost:8081"));
    }

    @Test
    public void when_consumerProperties_avroPropertyIsDefined_then_itsNotOverwritten() {
        Assertions.assertThat((Map)PropertiesResolver.resolveConsumerProperties(Map.of("keyFormat", "avro", "key.deserializer", "deserializer"), (Object)DUMMY_SCHEMA, null)).containsExactlyInAnyOrderEntriesOf(Map.of("key.deserializer", "deserializer", "keyAvroSchema", DUMMY_SCHEMA));
        Assertions.assertThat((Map)PropertiesResolver.resolveConsumerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro", "value.deserializer", "deserializer"), null, (Object)DUMMY_SCHEMA)).containsExactlyInAnyOrderEntriesOf(Map.of("value.deserializer", "deserializer", "valueAvroSchema", DUMMY_SCHEMA));
    }

    @Test
    public void when_producerProperties_avroPropertyIsDefined_then_itsNotOverwritten() {
        Assertions.assertThat((Map)PropertiesResolver.resolveProducerProperties(Map.of("keyFormat", "avro", "key.serializer", "serializer"), (Object)DUMMY_SCHEMA, null)).containsExactlyInAnyOrderEntriesOf(Map.of("key.serializer", "serializer", "keyAvroSchema", DUMMY_SCHEMA));
        Assertions.assertThat((Map)PropertiesResolver.resolveProducerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "avro", "value.serializer", "serializer"), null, (Object)DUMMY_SCHEMA)).containsExactlyInAnyOrderEntriesOf(Map.of("value.serializer", "serializer", "valueAvroSchema", DUMMY_SCHEMA));
    }

    @Test
    public void test_consumerProperties_json() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", "json-flat"))).containsExactlyEntriesOf(Map.of("key.deserializer", ByteArrayDeserializer.class.getCanonicalName()));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "json-flat"))).containsExactlyEntriesOf(Map.of("value.deserializer", ByteArrayDeserializer.class.getCanonicalName()));
    }

    @Test
    public void test_producerProperties_json() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", "json-flat"))).containsExactlyEntriesOf(Map.of("key.serializer", ByteArraySerializer.class.getCanonicalName()));
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "json-flat"))).containsExactlyEntriesOf(Map.of("value.serializer", ByteArraySerializer.class.getCanonicalName()));
    }

    @Test
    public void when_consumerProperties_jsonPropertyIsDefined_then_itsNotOverwritten() {
        Map<String, String> keyOptions = Map.of("keyFormat", "json-flat", "key.deserializer", "deserializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(keyOptions)).containsExactlyEntriesOf(Map.of("key.deserializer", "deserializer"));
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "json-flat", "value.deserializer", "deserializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(valueOptions)).containsExactlyEntriesOf(Map.of("value.deserializer", "deserializer"));
    }

    @Test
    public void when_producerProperties_jsonPropertyIsDefined_then_itsNotOverwritten() {
        Map<String, String> keyOptions = Map.of("keyFormat", "json-flat", "key.serializer", "serializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(keyOptions)).containsExactlyEntriesOf(Map.of("key.serializer", "serializer"));
        Map<String, String> valueOptions = Map.of("keyFormat", UNKNOWN_FORMAT, "valueFormat", "json-flat", "value.serializer", "serializer");
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(valueOptions)).containsExactlyEntriesOf(Map.of("value.serializer", "serializer"));
    }

    private static Properties resolveConsumerProperties(Map<String, String> options) {
        return PropertiesResolver.resolveConsumerProperties(options, null, null);
    }

    private static Properties resolveProducerProperties(Map<String, String> options) {
        return PropertiesResolver.resolveProducerProperties(options, null, null);
    }

    @Test
    public void when_consumerProperties_preferredLocalParallelismPropertyIsDefined_then_itIsIgnored() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveConsumerProperties(Map.of("preferredLocalParallelism", "-1"))).containsExactlyEntriesOf(Map.of("key.deserializer", ByteArrayDeserializer.class.getCanonicalName()));
    }

    @Test
    public void when_producerProperties_preferredLocalParallelismPropertyIsDefined_then_itIsIgnored() {
        Assertions.assertThat((Map)PropertiesResolverTest.resolveProducerProperties(Map.of("preferredLocalParallelism", "-1"))).containsExactlyEntriesOf(Map.of("key.serializer", ByteArraySerializer.class.getCanonicalName()));
    }
}

