/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.oracle;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.jdbc.OracleDatabaseProviderFactory;
import java.sql.SQLException;
import org.assertj.core.util.Lists;
import org.junit.BeforeClass;
import org.junit.Test;

public class OracleTableAndColumnNameTest
extends JdbcSqlTestSupport {
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        OracleTableAndColumnNameTest.initialize(OracleDatabaseProviderFactory.createTestDatabaseProvider());
    }

    @Test
    public void tableNameWithoutQuotes() throws SQLException {
        this.tableName = "MyTable0";
        OracleTableAndColumnNameTest.createTableNoQuote(this.tableName);
        Exception exception = (Exception)OracleTableAndColumnNameTest.assertThrows(HazelcastSqlException.class, () -> OracleTableAndColumnNameTest.createMapping(this.tableName));
        OracleTableAndColumnNameTest.assertContains((String)exception.getMessage(), (String)"Could not execute readDbFields for table");
        OracleTableAndColumnNameTest.createMapping("MYTABLE0");
        OracleTableAndColumnNameTest.execute("INSERT INTO MYTABLE0 VALUES (0, 'name-0')", new Object[0]);
        OracleTableAndColumnNameTest.assertJdbcRowsAnyOrder("MYTABLE0", Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void tableNameWithQuotes() throws SQLException {
        this.tableName = "MyTable1";
        OracleTableAndColumnNameTest.createTable(this.tableName);
        OracleTableAndColumnNameTest.createMapping(this.tableName);
        OracleTableAndColumnNameTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        OracleTableAndColumnNameTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void tableNameUpperCase() throws SQLException {
        this.tableName = "MYTABLE2";
        OracleTableAndColumnNameTest.createTableNoQuote(this.tableName);
        OracleTableAndColumnNameTest.createMapping(this.tableName);
        OracleTableAndColumnNameTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        OracleTableAndColumnNameTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void columnNameWithoutQuotes() throws SQLException {
        this.tableName = "MyTable3";
        OracleTableAndColumnNameTest.createTableNoQuote(databaseProvider.quote(new String[]{this.tableName}), "id INT PRIMARY KEY, name VARCHAR(100)");
        Exception exception = (Exception)OracleTableAndColumnNameTest.assertThrows(HazelcastSqlException.class, () -> OracleTableAndColumnNameTest.createMapping(this.tableName));
        OracleTableAndColumnNameTest.assertContains((String)exception.getMessage(), (String)"Could not resolve field with name");
    }

    @Test
    public void columnNameUpperCase() throws SQLException {
        this.tableName = "MyTable4";
        OracleTableAndColumnNameTest.createTableNoQuote(databaseProvider.quote(new String[]{this.tableName}), "ID INT PRIMARY KEY, NAME VARCHAR(100)");
        OracleTableAndColumnNameTest.execute("CREATE MAPPING " + this.tableName + " ( ID INT,  NAME VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        OracleTableAndColumnNameTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        OracleTableAndColumnNameTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }
}

