/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.jet.sql.impl.connector.jdbc.join.JoinPredicateScanResultSetIterator;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class JoinPredicateScanResultSetIteratorTest {
    private static final H2DatabaseProvider h2DatabaseProvider = new H2DatabaseProvider();
    private static String dbConnectionUrl;
    private static final List<String> EXPECTED_TABLES;

    JoinPredicateScanResultSetIteratorTest() {
    }

    @BeforeAll
    static void beforeAll() {
        dbConnectionUrl = h2DatabaseProvider.createDatabase(JoinPredicateScanResultSetIteratorTest.class.getName());
    }

    @AfterAll
    static void afterAll() {
        h2DatabaseProvider.shutdown();
    }

    @Test
    void testHasNext() throws SQLException {
        try (Connection connection = DriverManager.getConnection(dbConnectionUrl);){
            JoinPredicateScanResultSetIterator<String> iterator = this.createIterator(connection);
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                tableNameList.add((String)iterator.next());
            }
            Assertions.assertThat(tableNameList).containsAll(EXPECTED_TABLES);
            Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            Assertions.assertThatThrownBy(() -> iterator.next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Test
    void testNext() throws SQLException {
        Connection connection = DriverManager.getConnection(dbConnectionUrl);
        try {
            JoinPredicateScanResultSetIterator<String> iterator = this.createIterator(connection);
            ArrayList<String> tableNameList = new ArrayList<String>();
            try {
                while (true) {
                    tableNameList.add((String)iterator.next());
                }
            }
            catch (NoSuchElementException exception) {
                Assertions.assertThat(tableNameList).containsAll(EXPECTED_TABLES);
                Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
                Assertions.assertThatThrownBy(() -> iterator.next()).isInstanceOf(NoSuchElementException.class);
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Test
    void testHasNextAndNext_mixed() throws SQLException {
        try (Connection connection = DriverManager.getConnection(dbConnectionUrl);){
            JoinPredicateScanResultSetIterator<String> iterator = this.createIterator(connection);
            ArrayList<String> tableNameList = new ArrayList<String>();
            int index = 0;
            while (true) {
                if (this.isEven(index)) {
                    if (!iterator.hasNext()) break;
                    tableNameList.add((String)iterator.next());
                } else {
                    try {
                        tableNameList.add((String)iterator.next());
                    }
                    catch (NoSuchElementException exception) {
                        break;
                    }
                }
                ++index;
            }
            Assertions.assertThat(tableNameList).containsAll(EXPECTED_TABLES);
            Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            Assertions.assertThatThrownBy(() -> iterator.next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    private boolean isEven(int value) {
        return value % 2 == 0;
    }

    private JoinPredicateScanResultSetIterator<String> createIterator(Connection connection) {
        return new JoinPredicateScanResultSetIterator(connection, "SELECT * FROM INFORMATION_SCHEMA.TABLES", this::rowMapper, this::preparedStatementSetter);
    }

    private void preparedStatementSetter(PreparedStatement ignored) {
    }

    private String rowMapper(ResultSet resultSet) {
        try {
            String tableName = null;
            if (resultSet.next()) {
                tableName = resultSet.getString("TABLE_NAME");
            }
            return tableName;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EXPECTED_TABLES = List.of("VIEWS", "TABLES", "ROLES", "USERS");
    }
}

