/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class UpdateJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        UpdateJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = UpdateJdbcSqlConnectorTest.randomTableName();
    }

    @Test
    public void updateTable() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "updated"));
    }

    @Test
    public void updateTableWhereId() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE id=0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void updateTableWhereIdUsingQueryParameter() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE id = ?", 0);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void updateTableWhereOnNonPKColumn() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE name='name-0'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void updateTableWhereColumnWithExternalName() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( person_id INT EXTERNAL NAME id,  name VARCHAR) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE person_id = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void updateTableSetColumnWithExternalName() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET fullName = 'updated' WHERE id = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void updateTableSetUsingExpressionWithTableColumn() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated-'||id", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated-0"), new SqlTestSupport.Row(1, "updated-1"));
    }

    @Test
    public void updateTableSetUsingExpressionWithTableColumnNoPushDown() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)", "data VARCHAR(100)");
        UpdateJdbcSqlConnectorTest.executeJdbcWithQuotes("INSERT INTO " + this.tableName + " VALUES(0, 'name-0', '{\"value\":0}')", this.tableName);
        UpdateJdbcSqlConnectorTest.executeJdbcWithQuotes("INSERT INTO " + this.tableName + " VALUES(1, 'name-1', '{\"value\":1}')", this.tableName);
        UpdateJdbcSqlConnectorTest.executeJdbcWithQuotes("INSERT INTO " + this.tableName + " VALUES(2, 'name-2', '{\"value\":2}')", this.tableName);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR,  data VARCHAR) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated-'||id WHERE JSON_QUERY(data, '$.value') = '2'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcQueryRowsAnyOrder("SELECT " + UpdateJdbcSqlConnectorTest.quote("id") + ", " + UpdateJdbcSqlConnectorTest.quote("name") + " FROM " + UpdateJdbcSqlConnectorTest.quote(this.tableName), Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "updated-2"));
    }

    @Test
    public void updateTableSetUsingQueryParameter() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ?", "updated");
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"));
    }

    @Test
    public void updateTableSetUsingTableColumnWithExternalName() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( person_id INT EXTERNAL NAME id,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated-'||person_id", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated-0"), new SqlTestSupport.Row(1, "updated-1"));
    }

    @Test
    public void updateTableWhereOnNonPKColumnWithExternalName() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)", "age INT");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 'name-0', 20)");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 'name-1', 20)");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name, age INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET age = 42 WHERE fullName='name-0'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class}), new SqlTestSupport.Row(0, "name-0", 42), new SqlTestSupport.Row(1, "name-1", 20));
    }

    @Test
    public void updateTableWhereAndSetUsingQueryParameter() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)", "age INT");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 'name-0', 20)");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 'name-1', 20)");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR, age INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET age = ? WHERE name = ?", 42, "name-0");
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class}), new SqlTestSupport.Row(0, "name-0", 42), new SqlTestSupport.Row(1, "name-1", 20));
    }

    @Test
    public void updateTableWhereOnPKAndSetUsingQueryParameter() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)", "age INT");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 'name-0', 20)");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 'name-1', 20)");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR, age INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET age = ?, name = ? WHERE id = ?", 42, "updated", 0);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class}), new SqlTestSupport.Row(0, "updated", 42), new SqlTestSupport.Row(1, "name-1", 20));
    }

    @Test
    public void updateTableWithExternalName() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        String mappingName = "mapping_" + UpdateJdbcSqlConnectorTest.randomName();
        UpdateJdbcSqlConnectorTest.createMapping(this.tableName, mappingName);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + mappingName + " SET name = 'updated'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"), new SqlTestSupport.Row(1, "updated"));
    }

    @Test
    public void updateTableWithMultiplePKColumns() throws Exception {
        UpdateJdbcSqlConnectorTest.createTableNoQuote(UpdateJdbcSqlConnectorTest.quote(this.tableName), UpdateJdbcSqlConnectorTest.quote("id") + " INT", UpdateJdbcSqlConnectorTest.quote("id2") + " INT", UpdateJdbcSqlConnectorTest.quote("name") + " VARCHAR(10)", "PRIMARY KEY(" + UpdateJdbcSqlConnectorTest.quote("id") + ", " + UpdateJdbcSqlConnectorTest.quote("id2") + ")");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 0, 'name-0')");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 0, 'name-1')");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 1, 'name-2')");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  id2 INT,  name VARCHAR) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE id = 0 AND id2 = 1", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.class, String.class}), new SqlTestSupport.Row(0, 0, "name-0"), new SqlTestSupport.Row(1, 0, "name-1"), new SqlTestSupport.Row(0, 1, "updated"));
    }

    @Test
    public void updateTableWithMultiplePKColumnsNoPredicatePushDown() throws Exception {
        UpdateJdbcSqlConnectorTest.createTableNoQuote(UpdateJdbcSqlConnectorTest.quote(this.tableName), UpdateJdbcSqlConnectorTest.quote("id") + " INT", UpdateJdbcSqlConnectorTest.quote("id2") + " INT", UpdateJdbcSqlConnectorTest.quote("name") + " VARCHAR(10)", "PRIMARY KEY(" + UpdateJdbcSqlConnectorTest.quote("id") + ", " + UpdateJdbcSqlConnectorTest.quote("id2") + ")", UpdateJdbcSqlConnectorTest.quote("data") + " VARCHAR(100)");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 0, 'name-0', '{\"value\":0}')");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 0, 'name-1', '{\"value\":1}')");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 1, 'name-2', '{\"value\":2}')");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  id2 INT,  name VARCHAR,  data VARCHAR) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE JSON_QUERY(data, '$.value') = '2'", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcQueryRowsAnyOrder("SELECT " + UpdateJdbcSqlConnectorTest.quote("name") + " FROM " + UpdateJdbcSqlConnectorTest.quote(this.tableName), new SqlTestSupport.Row("name-0"), new SqlTestSupport.Row("name-1"), new SqlTestSupport.Row("updated"));
    }

    @Test
    public void updateTableWithReverseColumnOrder() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "name VARCHAR(10)", "id INT PRIMARY KEY");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('name-0', 0)");
        UpdateJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdateJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('name-1', 1)");
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( name VARCHAR,  id INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE id = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{String.class, Integer.class}), new SqlTestSupport.Row("updated", 0), new SqlTestSupport.Row("name-1", 1));
    }

    @Test
    public void updateMappingWithResolvedFields() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName);
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE id = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"));
    }

    @Test
    public void updateMappingWithQuotedColumnInWhere() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "person-id INT PRIMARY KEY", "name VARCHAR(100)");
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE \"person-id\" = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"));
    }

    @Test
    public void updateMappingWithQuotedColumnInSet() throws Exception {
        UpdateJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "full-name VARCHAR(100)");
        UpdateJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        UpdateJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        UpdateJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET \"full-name\" = 'updated' WHERE id = 0", new Object[0]);
        UpdateJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"));
    }
}

