/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
public class PredicatePushDownJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    protected static String tableName;
    @Parameterized.Parameter
    public String query;

    @Parameterized.Parameters(name="query:{0}")
    public static Object[] parameters() {
        return new Object[]{"SELECT name FROM people WHERE name = 'John Doe'", "SELECT name FROM people WHERE a = 1 AND b = 1", "SELECT name FROM people WHERE a = 1 OR b = 1", "SELECT name FROM people WHERE NOT (c = 1)", "SELECT name FROM people WHERE c != d", "SELECT name FROM people WHERE age < 31", "SELECT name FROM people WHERE age < 31 AND age > 29", "SELECT name FROM people WHERE age <= 30", "SELECT name FROM people WHERE 31 > age", "SELECT name FROM people WHERE 30 >= age", "SELECT name FROM people WHERE age = 30", "SELECT name FROM people WHERE age != 35", "SELECT name FROM people WHERE age <> 35", "SELECT name FROM people WHERE age BETWEEN 29 AND 30", "SELECT name FROM people WHERE age NOT BETWEEN 34 AND 35", "SELECT name FROM people WHERE name LIKE 'John%'", "SELECT name FROM people WHERE name NOT LIKE 'Jane%'", "SELECT name FROM people WHERE id IN (0, 1)", "SELECT name FROM people WHERE age IN (28, 29, 30)", "SELECT name FROM people WHERE name IN ('John Doe', 'something')", "SELECT name FROM people WHERE name NOT IN ('Jane Doe', 'something')", "SELECT name FROM people WHERE nullable_column IS NULL", "SELECT name FROM people WHERE nullable_column_reverse IS NOT NULL", "SELECT name FROM people WHERE a = 1 IS TRUE", "SELECT name FROM people WHERE c = 1 IS FALSE", "SELECT name FROM people WHERE c = 1 IS NOT TRUE", "SELECT name FROM people WHERE a = 1 IS NOT FALSE", "SELECT name FROM people WHERE age + 1 = 31", "SELECT name FROM people WHERE age - 1 = 29", "SELECT name FROM people WHERE age * 2 = 60", "SELECT name FROM people WHERE age / 5 = 6", "SELECT name FROM people WHERE CASE age WHEN 30 THEN TRUE ELSE FALSE END", "SELECT name FROM people WHERE CASE WHEN age = 30 THEN TRUE ELSE FALSE END", "SELECT name FROM people WHERE NULLIF(age, 30) IS NULL", "SELECT name FROM people WHERE COALESCE(nullable_column, nullable_column_reverse) = 'not null reverse'", "SELECT name FROM people WHERE CAST(age AS VARCHAR(100)) = '30'", "SELECT name FROM people WHERE CAST(age AS VARCHAR(100)) = 'not a number' or age = 30", "SELECT name FROM people WHERE 'Hello '||name = 'Hello John Doe'", "SELECT name FROM people WHERE LENGTH(data) = 12", "SELECT name FROM people WHERE LOWER(name) = 'john doe'", "SELECT name FROM people WHERE UPPER(name) = 'JOHN DOE'"};
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        PredicatePushDownJdbcSqlConnectorTest.initializePredicatePushDownTest((TestDatabaseProvider)new H2DatabaseProvider());
    }

    protected static void initializePredicatePushDownTest(TestDatabaseProvider provider) throws SQLException {
        PredicatePushDownJdbcSqlConnectorTest.initialize(provider);
        tableName = "people";
        PredicatePushDownJdbcSqlConnectorTest.createTable(tableName, "id INT PRIMARY KEY", "name VARCHAR(100)", "age INT", "data VARCHAR(100)", "a INT", "b INT", "c INT", "d INT", "nullable_column VARCHAR(100)", "nullable_column_reverse VARCHAR(100)");
        PredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + PredicatePushDownJdbcSqlConnectorTest.quote(tableName) + " VALUES (1, 'John Doe', 30, '{\"value\":42}', 1, 1, 0, 1, null, 'not null reverse')");
        PredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + PredicatePushDownJdbcSqlConnectorTest.quote(tableName) + " VALUES (2, 'Jane Doe', 35, '{\"value\":0}', 0, 0, 1, 1, 'not null', null)");
    }

    @Before
    public void setUp() throws Exception {
        sqlService.execute("CREATE MAPPING " + tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void runQueryExpectSingleResult_and_FullScanPhysicalRel() {
        PredicatePushDownJdbcSqlConnectorTest.assertRowsAnyOrder(this.query, new SqlTestSupport.Row("John Doe"));
        this.assertExplain("EXPLAIN " + this.query, "FullScanPhysicalRel");
    }

    private void assertExplain(String query, String ... rels) {
        try (SqlResult result = sqlService.execute(query, new Object[0]);){
            Iterator it = result.iterator();
            ArrayList<String> rows = new ArrayList<String>();
            while (it.hasNext()) {
                SqlRow next = (SqlRow)it.next();
                String row = (String)next.getObject(0);
                rows.add(row.substring(0, row.indexOf(40)));
            }
            Assertions.assertThat(rows).containsExactly((Object[])rels);
            Assertions.assertThat(rows).hasSameSizeAs((Object)rels);
        }
    }
}

