/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcCrossJoinTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 2;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        JdbcCrossJoinTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = JdbcCrossJoinTest.randomTableName();
        JdbcCrossJoinTest.createTable(this.tableName);
        JdbcCrossJoinTest.insertItems(this.tableName, 2);
        JdbcCrossJoinTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void crossJoinWithOtherJdbc() throws SQLException {
        String otherTableName = JdbcCrossJoinTest.randomTableName();
        JdbcCrossJoinTest.createTable(otherTableName);
        JdbcCrossJoinTest.insertItems(otherTableName, 2);
        JdbcCrossJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcCrossJoinTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " t1 CROSS JOIN " + otherTableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0", 0, "name-0"), new SqlTestSupport.Row(0, "name-0", 1, "name-1"), new SqlTestSupport.Row(1, "name-1", 0, "name-0"), new SqlTestSupport.Row(1, "name-1", 1, "name-1")}));
    }
}

