/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.dataconnection.impl.DataConnectionTestUtil;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DatabaseRule
implements TestRule {
    private TestDatabaseProvider databaseProvider;
    private ConcurrentMemoizingSupplier<String> dbConnectionUrl;

    public String getDbConnectionUrl() {
        return (String)this.dbConnectionUrl.get();
    }

    public DatabaseRule(TestDatabaseProvider databaseProvider) {
        this.databaseProvider = databaseProvider;
        this.dbConnectionUrl = new ConcurrentMemoizingSupplier(() -> this.databaseProvider.createDatabase(DatabaseRule.class.getName()));
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    if (DatabaseRule.this.dbConnectionUrl != null) {
                        DatabaseRule.this.databaseProvider.shutdown();
                        DatabaseRule.this.databaseProvider = null;
                        DatabaseRule.this.dbConnectionUrl = null;
                    }
                }
            }
        };
    }

    public void createTable(String tableName, String ... columns) throws SQLException {
        this.executeJdbc("CREATE TABLE " + tableName + " (" + String.join((CharSequence)", ", columns) + ")");
    }

    public void executeJdbc(String sql) throws SQLException {
        DataConnectionTestUtil.executeJdbc((String)((String)this.dbConnectionUrl.get()), (String)sql);
    }

    public void insertItems(String tableName, int count) throws SQLException {
        for (int i = 0; i < count; ++i) {
            this.executeJdbc(String.format("INSERT INTO " + tableName + " VALUES(%d, 'name-%d')", i, i));
        }
    }
}

