/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.test.Accessors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlInfoSchemaTest
extends SqlTestSupport {
    private static final String LE = System.lineSeparator();
    private static SqlService sqlService;
    private final String mappingName = SqlInfoSchemaTest.randomName();
    private final String viewName = SqlInfoSchemaTest.randomName();
    private final String firstTypeName = SqlInfoSchemaTest.randomName();
    private final String secondTypeName = SqlInfoSchemaTest.randomName();
    private final String mappingExternalName = "my_map";

    @BeforeClass
    public static void initialize() {
        SqlInfoSchemaTest.initialize((int)1, null);
        sqlService = SqlInfoSchemaTest.instance().getSql();
    }

    @Before
    public void setup() {
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(this.mappingName, IMapSqlConnector.class).externalName("my_map").fields(new String[]{"__key INT", "__value VARCHAR EXTERNAL NAME \"this.value\""})).options(new Object[]{"keyFormat", "int", "valueFormat", "java", "valueJavaClass", Value.class.getName()})).create();
        sqlService.executeUpdate("CREATE VIEW " + this.viewName + " AS SELECT * FROM " + this.mappingName, new Object[0]);
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(this.firstTypeName).fields(new String[]{"id BIGINT", "name VARCHAR", "created TIMESTAMP WITH TIME ZONE", "balance DOUBLE"})).create();
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(this.secondTypeName).fields(new String[]{"id BIGINT", "name VARCHAR", "other " + this.firstTypeName})).create();
    }

    @Test
    public void test_tables() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT * FROM information_schema.tables", Arrays.asList(new SqlTestSupport.Row("hazelcast", "public", this.mappingName, "BASE TABLE", null, null, null, null, null, "YES", "NO", null), new SqlTestSupport.Row("hazelcast", "public", this.viewName, "VIEW", null, null, null, null, null, "NO", "NO", null)));
    }

    @Test
    public void test_dataConnections() {
        String type = "DUMMY";
        Accessors.getNodeEngineImpl((HazelcastInstance)SqlInfoSchemaTest.instance()).getDataConnectionService().createConfigDataConnection(new DataConnectionConfig().setName("c_dc").setType(type));
        sqlService.executeUpdate("CREATE DATA CONNECTION sql_default_shared_dc TYPE DUMMY", new Object[0]);
        sqlService.executeUpdate("CREATE DATA CONNECTION sql_shared_dc TYPE DUMMY SHARED", new Object[0]);
        sqlService.executeUpdate("CREATE DATA CONNECTION sql_non_shared_dc TYPE DUMMY NOT SHARED", new Object[0]);
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT * FROM information_schema.dataconnections", Arrays.asList(new SqlTestSupport.Row("hazelcast", "public", "sql_default_shared_dc", type, true, "{}", "SQL"), new SqlTestSupport.Row("hazelcast", "public", "sql_shared_dc", type, true, "{}", "SQL"), new SqlTestSupport.Row("hazelcast", "public", "sql_non_shared_dc", type, false, "{}", "SQL"), new SqlTestSupport.Row("hazelcast", "public", "c_dc", type, true, "{}", "CONFIG")));
    }

    @Test
    public void test_mappings() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT * FROM information_schema.mappings", Collections.singletonList(new SqlTestSupport.Row("hazelcast", "public", this.mappingName, "\"my_map\"", "IMap", "{\"keyFormat\":\"int\",\"valueFormat\":\"java\",\"valueJavaClass\":\"" + Value.class.getName() + "\"}")));
    }

    @Test
    public void test_views() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT * FROM information_schema.views", Collections.singletonList(new SqlTestSupport.Row("hazelcast", "public", this.viewName, "SELECT \"" + this.mappingName + "\".\"__key\", \"" + this.mappingName + "\".\"__value\"" + LE + "FROM \"hazelcast\".\"public\".\"" + this.mappingName + "\" AS \"" + this.mappingName + "\"", "NONE", "NO", "NO")));
    }

    @Test
    public void test_columns() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT * FROM information_schema.columns", Arrays.asList(new SqlTestSupport.Row("hazelcast", "public", this.mappingName, "__key", "__key", 1, "true", "INTEGER"), new SqlTestSupport.Row("hazelcast", "public", this.mappingName, "__value", "this.value", 2, "true", "VARCHAR"), new SqlTestSupport.Row("hazelcast", "public", this.viewName, "__key", null, 1, "true", "INTEGER"), new SqlTestSupport.Row("hazelcast", "public", this.viewName, "__value", null, 2, "true", "VARCHAR")));
    }

    @Test
    public void test_dynamicParameters() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT table_name, UPPER(table_catalog || ?), column_name, data_type FROM information_schema.columns WHERE column_name = ?", Arrays.asList("-p", "__value"), Arrays.asList(new SqlTestSupport.Row(this.mappingName, "HAZELCAST-P", "__value", "VARCHAR"), new SqlTestSupport.Row(this.viewName, "HAZELCAST-P", "__value", "VARCHAR")));
    }

    @Test
    public void when_predicateAndProjectionIsUsed_then_correctRowsAndColumnsAreReturned() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT table_name, UPPER(table_catalog), column_name, data_type FROM information_schema.columns WHERE column_name = '__value'", Arrays.asList(new SqlTestSupport.Row(this.mappingName, "HAZELCAST", "__value", "VARCHAR"), new SqlTestSupport.Row(this.viewName, "HAZELCAST", "__value", "VARCHAR")));
    }

    @Test
    public void test_join() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT table_name, column_name FROM information_schema.mappings JOIN information_schema.columns USING (table_catalog, table_schema, table_name)", SqlInfoSchemaTest.rows(2, this.mappingName, "__key", this.mappingName, "__value"));
    }

    @Test
    public void test_joinAndUnion() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT table_name, column_name FROM (    SELECT table_catalog, table_schema, table_name FROM information_schema.mappings     UNION ALL    SELECT table_catalog, table_schema, table_name FROM information_schema.views ) JOIN information_schema.columns USING (table_catalog, table_schema, table_name)", SqlInfoSchemaTest.rows(2, this.mappingName, "__key", this.mappingName, "__value", this.viewName, "__key", this.viewName, "__value"));
    }

    @Test
    public void test_planCache_mappings() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT table_name FROM information_schema.mappings", Collections.singletonList(new SqlTestSupport.Row(this.mappingName)));
        Assertions.assertThat((int)SqlInfoSchemaTest.planCache(SqlInfoSchemaTest.instance()).size()).isZero();
    }

    @Test
    public void test_planCache_columns() {
        sqlService.execute("SELECT column_name FROM information_schema.columns WHERE ordinal_position = 2", new Object[0]);
        Assertions.assertThat((int)SqlInfoSchemaTest.planCache(SqlInfoSchemaTest.instance()).size()).isZero();
    }

    @Test
    public void test_userDefinedTypes() {
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT user_defined_type_catalog, user_defined_type_schema, user_defined_type_name, user_defined_type_category FROM information_schema.user_defined_types", SqlInfoSchemaTest.rows(4, "hazelcast", "public", this.firstTypeName, "STRUCTURED", "hazelcast", "public", this.secondTypeName, "STRUCTURED"));
    }

    @Test
    public void test_attributes() {
        List<SqlTestSupport.Row> expected = Arrays.asList(new SqlTestSupport.Row("hazelcast", "public", this.firstTypeName, "id", 1, "YES", "BIGINT", null, null, 64, 2, 0, null, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.firstTypeName, "name", 2, "YES", "VARCHAR", Integer.MAX_VALUE, Integer.MAX_VALUE, null, null, null, null, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.firstTypeName, "created", 3, "YES", "TIMESTAMP_WITH_LOCAL_TIME_ZONE", null, null, null, null, null, 9, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.firstTypeName, "balance", 4, "YES", "DOUBLE", null, null, 53, 2, null, null, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.secondTypeName, "id", 1, "YES", "BIGINT", null, null, 64, 2, 0, null, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.secondTypeName, "name", 2, "YES", "VARCHAR", Integer.MAX_VALUE, Integer.MAX_VALUE, null, null, null, null, null, null, null), new SqlTestSupport.Row("hazelcast", "public", this.secondTypeName, "other", 3, "YES", "USER-DEFINED", null, null, null, null, null, null, "hazelcast", "public", this.firstTypeName));
        SqlInfoSchemaTest.assertRowsAnyOrder("SELECT udt_catalog, udt_schema, udt_name, attribute_name, ordinal_position, is_nullable, data_type, character_maximum_length, character_octet_length, numeric_precision, numeric_precision_radix, numeric_scale, datetime_precision, attribute_udt_catalog, attribute_udt_schema, attribute_udt_name FROM information_schema.attributes", expected);
    }

    public static final class Value {
        public String value;
    }
}

