/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlService;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlStreamGeneratorTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlStreamGeneratorTest.initialize((int)1, null);
        sqlService = SqlStreamGeneratorTest.instance().getSql();
    }

    @Test
    public void test_generateStream() {
        SqlStreamGeneratorTest.assertTipOfStream("SELECT * FROM TABLE(GENERATE_STREAM(100))", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L), new SqlTestSupport.Row(2L)));
    }

    @Test
    public void test_generateStreamArgumentExpression() {
        SqlStreamGeneratorTest.assertTipOfStream("SELECT * FROM TABLE(GENERATE_STREAM(CAST(CAST('50' AS INTEGER) + 100 AS INT)))", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L), new SqlTestSupport.Row(2L)));
    }

    @Test
    public void test_generateStreamNamedArguments() {
        SqlStreamGeneratorTest.assertTipOfStream("SELECT * FROM TABLE(GENERATE_STREAM(rate => 50 + 50))", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L), new SqlTestSupport.Row(2L)));
    }

    @Test
    public void test_generateStreamNamedArgumentsAndExplicitNull() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(rate => null))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_STREAM - rate cannot be null");
    }

    @Test
    public void test_generateStreamFilterAndProject() {
        SqlStreamGeneratorTest.assertTipOfStream("SELECT v * 2 FROM TABLE(GENERATE_STREAM(10)) WHERE v > 0 AND v < 5", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateStreamWithDynamicParameters() {
        SqlStreamGeneratorTest.assertRowsEventuallyInAnyOrder("SELECT v * ? FROM TABLE(GENERATE_STREAM(?)) WHERE v > 1 - ? AND v < 5", Arrays.asList(2, 100, 1), Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateStreamWithNamedArgumentsAndDynamicParameters() {
        SqlStreamGeneratorTest.assertRowsEventuallyInAnyOrder("SELECT v * ? FROM TABLE(GENERATE_STREAM(rate => ?)) WHERE v > 1 - ? AND v < 5", Arrays.asList(2, 100, 1), Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateStreamWithDynamicParametersAndArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(?))", new Object[]{"1"})).hasMessageContaining("Parameter at position 0 must be of INTEGER type, but VARCHAR was found");
    }

    @Test
    public void test_generateStreamWithNamedArgumentsDynamicParametersAndArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(rate => ?))", new Object[]{"1"})).hasMessageContaining("Parameter at position 0 must be of INTEGER type, but VARCHAR was found");
    }

    @Test
    public void test_generateEmptyStream() {
        SqlStreamGeneratorTest.assertEmptyResultStream("SELECT * FROM TABLE(GENERATE_STREAM(0))");
    }

    @Test
    public void when_rateIsNegative_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(-1))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_STREAM - rate cannot be less than zero");
    }

    @Test
    public void when_coercionIsRequired_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM('100'))", new Object[0])).hasMessageContaining("consider adding an explicit CAST");
    }

    @Test
    public void test_nullArgument() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(null))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_STREAM - rate cannot be null");
    }

    @Test
    public void when_notInFromClause_then_throws() {
        SqlStreamGeneratorTest.createMapping("m", Integer.TYPE, Integer.TYPE);
        SqlStreamGeneratorTest.instance().getMap("m").put((Object)42, (Object)43);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT GENERATE_STREAM(null) FROM m", new Object[0])).hasMessage("Cannot call table function here: 'GENERATE_STREAM'");
    }

    @Test
    public void when_unknownIdentifier_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(non_existing => 0))", new Object[0])).hasMessageContaining("Unknown argument name 'non_existing'");
    }

    @Test
    public void test_planCache() {
        SqlStreamGeneratorTest.assertTipOfStream("SELECT * FROM TABLE(GENERATE_STREAM(100))", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L)));
        Assertions.assertThat((int)SqlStreamGeneratorTest.planCache(SqlStreamGeneratorTest.instance()).size()).isEqualTo(1);
        SqlStreamGeneratorTest.assertTipOfStream("SELECT * FROM TABLE(GENERATE_STREAM(200))", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(1L)));
        Assertions.assertThat((int)SqlStreamGeneratorTest.planCache(SqlStreamGeneratorTest.instance()).size()).isEqualTo(2);
    }
}

