/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlJsonTest
extends SqlTestSupport {
    private static final String RESOURCES_PATH = Paths.get("src/test/resources", new String[0]).toFile().getAbsolutePath();
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlJsonTest.initialize((int)1, null);
        sqlService = SqlJsonTest.instance().getSql();
    }

    @Test
    public void test_nulls() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (nonExistingField VARCHAR) TYPE File OPTIONS ('format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='file.json')", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_fieldsMapping() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (id TINYINT EXTERNAL NAME byte, name VARCHAR EXTERNAL NAME string) TYPE File OPTIONS ('format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='file.json')", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT id, name FROM " + name, Collections.singletonList(new SqlTestSupport.Row((byte)127, "string")));
    }

    @Test
    public void test_allTypes() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (string VARCHAR, \"boolean\" BOOLEAN, byte TINYINT, short SMALLINT, \"int\" INT, long BIGINT, \"float\" REAL, \"double\" DOUBLE, \"decimal\" DECIMAL, \"time\" TIME, \"date\" DATE, \"timestamp\" TIMESTAMP, timestampTz TIMESTAMP WITH TIME ZONE, object OBJECT) TYPE File OPTIONS ( 'format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='file.json')", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row("string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), Collections.emptyMap())));
    }

    @Test
    public void test_schemaDiscovery() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE File OPTIONS ( 'format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='file.json')", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\", \"null\", object FROM " + name, Collections.singletonList(new SqlTestSupport.Row("string", true, 127.0, 32767.0, 2.147483647E9, 9.223372036854776E18, 1.2345678901E9, 1.234512345678901E14, "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z", null, Collections.emptyMap())));
    }

    @Test
    public void test_tableFunction() {
        SqlJsonTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\", \"null\", object FROM TABLE (JSON_FLAT_FILE ('" + RESOURCES_PATH + "', 'file.json'))", Collections.singletonList(new SqlTestSupport.Row("string", true, 127.0, 32767.0, 2.147483647E9, 9.223372036854776E18, 1.2345678901E9, 1.234512345678901E14, "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z", null, Collections.emptyMap())));
    }

    @Test
    public void when_conversionFails_then_queryFails() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (string INT) TYPE File OPTIONS ( 'format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='file.json')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).hasMessageContaining("Cannot parse VARCHAR value to INTEGER");
    }

    @Test
    public void when_columnsSpecified_then_fileNotAccessed() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (field INT) TYPE File OPTIONS ( 'format'='json-flat', 'path'='/non-existent-directory', 'glob'='foo.json')", new Object[0]);
    }

    @Test
    public void when_fileDoesNotExist_then_fails() {
        String name = SqlJsonTest.randomName();
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING " + name + " TYPE File OPTIONS ( 'format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='foo.json')", new Object[0])).hasMessageContaining("matches no files");
    }

    @Test
    public void when_fileDoesNotExistAndIgnoreFileNotFound_then_returnNoResults() {
        String name = SqlJsonTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (field INT)  TYPE File OPTIONS ( 'format'='json-flat', 'path'='" + RESOURCES_PATH + "', 'glob'='foo.json', 'ignoreFileNotFound'='true')", new Object[0]);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).describedAs("no results from non existing file", new Object[0])).isFalse();
    }

    @Test
    public void when_directoryDoesNotExist_then_tableFunctionThrowsException() {
        String path = SqlJsonTest.hadoopNonExistingPath();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE (json_flat_file (path => '" + path + "'))", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("The directory '" + path + "' does not exist");
    }

    @Test
    public void when_fileDoesNotExist_then_tableFunctionThrowsException() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT *  FROM TABLE (json_flat_file ( path => '" + RESOURCES_PATH + "' , glob => 'foo.json'))", new Object[0])).hasMessageContaining("matches no files");
    }
}

