/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.util.AutoCloseables;

final class FileUtil {
    static final GenericRecord AVRO_RECORD = new GenericRecordBuilder((Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"name").fields().name("string").type().stringType().noDefault().name("boolean").type().booleanType().noDefault().name("byte").type().intType().noDefault().name("short").type().intType().noDefault().name("int").type().intType().noDefault().name("long").type().longType().noDefault().name("float").type().floatType().noDefault().name("double").type().doubleType().noDefault().name("decimal").type().stringType().noDefault().name("time").type().stringType().noDefault().name("date").type().stringType().noDefault().name("timestamp").type().stringType().noDefault().name("timestampTz").type().stringType().noDefault().name("null").type().nullable().record("nul").fields().endRecord()).noDefault().name("object").type().record("object").fields().endRecord()).noDefault().endRecord()).set("string", (Object)"string").set("boolean", (Object)true).set("byte", (Object)127).set("short", (Object)Short.MAX_VALUE).set("int", (Object)Integer.MAX_VALUE).set("long", (Object)Long.MAX_VALUE).set("float", (Object)Float.valueOf(1.234568E9f)).set("double", (Object)1.234512345678901E14).set("decimal", (Object)"9223372036854775.123").set("time", (Object)"12:23:34").set("date", (Object)"2020-04-15").set("timestamp", (Object)"2020-04-15T12:23:34.001").set("timestampTz", (Object)"2020-04-15T12:23:34.200Z").set("null", null).set("object", (Object)new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"object").fields().endRecord()).build()).build();
    static final GenericRecord AVRO_NULLABLE_RECORD = ((GenericRecordBuilder)Util.reduce((Object)new GenericRecordBuilder((Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"name").fields().name("string").type().nullable().stringType().noDefault().name("boolean").type().nullable().booleanType().noDefault().name("byte").type().nullable().intType().noDefault().name("short").type().nullable().intType().noDefault().name("int").type().nullable().intType().noDefault().name("long").type().nullable().longType().noDefault().name("float").type().nullable().floatType().noDefault().name("double").type().nullable().doubleType().noDefault().name("decimal").type().nullable().stringType().noDefault().name("time").type().nullable().stringType().noDefault().name("date").type().nullable().stringType().noDefault().name("timestamp").type().nullable().stringType().noDefault().name("timestampTz").type().nullable().stringType().noDefault().name("null").type().nullable().record("nul").fields().endRecord()).noDefault().name("object").type().nullable().record("object").fields().endRecord()).noDefault().endRecord()), AVRO_RECORD.getSchema().getFields().stream(), (record, field) -> record.set(field, AVRO_RECORD.get(field.pos())))).build();
    static final GenericRecord AVRO_NULL_RECORD = ((GenericRecordBuilder)Util.reduce((Object)new GenericRecordBuilder(AVRO_NULLABLE_RECORD.getSchema()), AVRO_NULLABLE_RECORD.getSchema().getFields().stream(), (record, field) -> record.set(field, null))).build();
    static final GenericRecord AVRO_COMPLEX_TYPES;
    private static final GenericRecord PARQUET_RECORD;

    private FileUtil() {
    }

    static File createAvroFile(GenericRecord avroRecord) {
        try {
            File directory = Files.createTempDirectory("sql-avro-test", new FileAttribute[0]).toFile();
            directory.deleteOnExit();
            File file = new File(directory, "file.avro");
            try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
                writer.create(avroRecord.getSchema(), file);
                writer.append((Object)avroRecord);
            }
            return file;
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] createAvroPayload() {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
                writer.create(AVRO_RECORD.getSchema(), (OutputStream)output);
                writer.append((Object)AVRO_RECORD);
                writer.flush();
                byArray = output.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioe) {
            throw ExceptionUtil.sneakyThrow((Throwable)ioe);
        }
    }

    static void writeParquetPayloadTo(OutputFile file) throws IOException {
        try (ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)file).withRowGroupSize(0x8000000L)).withPageSize(0x100000)).withSchema(PARQUET_RECORD.getSchema()).withConf(new Configuration())).withCompressionCodec(CompressionCodecName.SNAPPY)).withValidation(false)).withDictionaryEncoding(false)).build();){
            writer.write((Object)PARQUET_RECORD);
        }
        catch (AutoCloseables.ParquetCloseResourceException parquetCloseResourceException) {
            // empty catch block
        }
    }

    static {
        Schema mapSchema = (Schema)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("avro.java.string", (Object)GenericData.StringType.String)).values(Schema.create((Schema.Type)Schema.Type.INT));
        Schema recordSchema = (Schema)SchemaBuilder.record((String)"record").fields().requiredInt("field").endRecord();
        Schema arraySchema = (Schema)SchemaBuilder.array().items(Schema.create((Schema.Type)Schema.Type.INT));
        Schema enumSchema = (Schema)SchemaBuilder.enumeration((String)"enum").symbols(new String[]{"symbol"});
        Schema fixedSchema = (Schema)SchemaBuilder.fixed((String)"fixed").size(1);
        AVRO_COMPLEX_TYPES = new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"complex").fields().requiredBytes("bytes").name("map").type(mapSchema).noDefault().name("record").type(recordSchema).noDefault().name("array").type(arraySchema).noDefault().name("enum").type(enumSchema).noDefault().name("fixed").type(fixedSchema).noDefault().endRecord()).set("bytes", (Object)ByteBuffer.wrap(new byte[]{19})).set("map", Map.of("key", 71)).set("record", (Object)new GenericRecordBuilder(recordSchema).set("field", (Object)23).build()).set("array", (Object)new GenericData.Array(arraySchema, List.of(Integer.valueOf(53)))).set("enum", (Object)new GenericData.EnumSymbol(enumSchema, "symbol")).set("fixed", (Object)new GenericData.Fixed(fixedSchema, new byte[]{74})).build();
        PARQUET_RECORD = new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"name").fields().name("string").type().stringType().noDefault().name("boolean").type().booleanType().noDefault().name("byte").type().intType().noDefault().name("short").type().intType().noDefault().name("int").type().intType().noDefault().name("long").type().longType().noDefault().name("float").type().floatType().noDefault().name("double").type().doubleType().noDefault().name("decimal").type().stringType().noDefault().name("time").type().stringType().noDefault().name("date").type().stringType().noDefault().name("timestamp").type().stringType().noDefault().name("timestampTz").type().stringType().noDefault().endRecord()).set("string", (Object)"string").set("boolean", (Object)true).set("byte", (Object)127).set("short", (Object)Short.MAX_VALUE).set("int", (Object)Integer.MAX_VALUE).set("long", (Object)Long.MAX_VALUE).set("float", (Object)Float.valueOf(1.234568E9f)).set("double", (Object)1.234512345678901E14).set("decimal", (Object)"9223372036854775.123").set("time", (Object)"12:23:34").set("date", (Object)"2020-04-15").set("timestamp", (Object)"2020-04-15T12:23:34.001").set("timestampTz", (Object)"2020-04-15T12:23:34.200Z").build();
    }
}

