/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.cache;

import com.hazelcast.config.Config;
import com.hazelcast.jet.sql.impl.cache.PlanCacheTestSupport;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PlanCacheTest
extends PlanCacheTestSupport {
    @BeforeClass
    public static void setUp() {
        PlanCacheTest.initialize((int)1, (Config)PlanCacheTest.smallInstanceConfig());
    }

    @Test
    public void testBasicOperations() {
        PlanCache cache = new PlanCache(10);
        PlanKey key = PlanCacheTest.createKey("sql");
        SqlPlan plan1 = PlanCacheTest.createPlan(key, PART_MAP_1, new int[0]);
        cache.put(key, plan1);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertSame((Object)plan1, (Object)cache.get(key));
        SqlPlan plan2 = PlanCacheTest.createPlan(key, PART_MAP_2, new int[0]);
        cache.put(key, plan2);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertSame((Object)plan2, (Object)cache.get(key));
        cache.invalidate(plan1);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertSame((Object)plan2, (Object)cache.get(key));
        cache.invalidate(plan2);
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNull((Object)cache.get(key));
        cache.put(key, plan1);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertSame((Object)plan1, (Object)cache.get(key));
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNull((Object)cache.get(key));
    }

    @Test
    public void testOverflow() {
        int size = 5;
        PlanCache cache = new PlanCache(size);
        for (int i = 0; i < size; ++i) {
            PlanKey key = PlanCacheTest.createKey(Integer.toString(i));
            cache.put(key, PlanCacheTest.createPlan(key, PART_MAP_1, new int[0]));
            PlanCacheTest.advanceTime();
        }
        Assert.assertEquals((long)size, (long)cache.size());
        PlanKey overflowKey = PlanCacheTest.createKey(Integer.toString(size));
        cache.put(overflowKey, PlanCacheTest.createPlan(overflowKey, PART_MAP_1, new int[0]));
        Assert.assertEquals((long)size, (long)cache.size());
        for (int i = 0; i < size; ++i) {
            PlanKey key = PlanCacheTest.createKey(Integer.toString(i + 1));
            Assert.assertNotNull((Object)cache.get(key));
        }
    }

    @Test
    public void testPlanUsageUpdate() {
        PlanCache cache = new PlanCache(10);
        PlanKey key = PlanCacheTest.createKey("sql");
        SqlPlan plan = PlanCacheTest.createPlan(key, PART_MAP_1, new int[0]);
        cache.put(key, plan);
        long timestamp1 = plan.getPlanLastUsed();
        Assert.assertTrue((timestamp1 > 0L ? 1 : 0) != 0);
        PlanCacheTest.advanceTime();
        cache.put(key, plan);
        long timestamp2 = plan.getPlanLastUsed();
        Assert.assertTrue((timestamp2 > timestamp1 ? 1 : 0) != 0);
        PlanCacheTest.advanceTime();
        cache.get(key);
        long timestamp3 = plan.getPlanLastUsed();
        Assert.assertTrue((timestamp3 > timestamp2 ? 1 : 0) != 0);
    }
}

