/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class SqlStreamingJoinAndAggregationTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        SqlStreamingJoinAndAggregationTest.initialize((int)1, null);
    }

    @Test
    public void test_singleStaged_hop() {
        String stream1 = "stream1";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), SqlStreamingJoinAndAggregationTest.row(1, SqlStreamingJoinAndAggregationTest.timestampTz(1L)), SqlStreamingJoinAndAggregationTest.row(2, SqlStreamingJoinAndAggregationTest.timestampTz(2L)), SqlStreamingJoinAndAggregationTest.row(101, SqlStreamingJoinAndAggregationTest.timestampTz(101L)));
        String stream2 = "stream_a";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(1L), 1), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(2L), 2), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(101L), 101));
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(b), INTERVAL '0.001' SECOND))", new Object[0]);
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_a, DESCRIPTOR(c), INTERVAL '0.001' SECOND))", new Object[0]);
        String sql = "SELECT we1, _sum, _max FROM ( SELECT window_end AS we1, SUM(DISTINCT a) AS _sum FROM     TABLE(HOP(TABLE s1, DESCRIPTOR(b), INTERVAL '0.02' SECOND, INTERVAL '0.01' SECOND))    GROUP BY window_end) st1  JOIN ( SELECT window_end AS we2, MAX(DISTINCT d) AS _max FROM     TABLE(HOP(TABLE s2, DESCRIPTOR(c), INTERVAL '0.02' SECOND, INTERVAL '0.01' SECOND))    GROUP BY window_end) st2 ON st1.we1 = st2.we2";
        SqlStreamingJoinAndAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(10L), 3L, 2), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(20L), 3L, 2)));
    }

    @Test
    public void test_singleStaged_tumble() {
        String stream1 = "stream1";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), SqlStreamingJoinAndAggregationTest.row(1, SqlStreamingJoinAndAggregationTest.timestampTz(1L)), SqlStreamingJoinAndAggregationTest.row(3, SqlStreamingJoinAndAggregationTest.timestampTz(3L)), SqlStreamingJoinAndAggregationTest.row(5, SqlStreamingJoinAndAggregationTest.timestampTz(5L)), SqlStreamingJoinAndAggregationTest.row(5, SqlStreamingJoinAndAggregationTest.timestampTz(7L)), SqlStreamingJoinAndAggregationTest.row(41, SqlStreamingJoinAndAggregationTest.timestampTz(41L)));
        String stream2 = "stream_a";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(0L), 0), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(2L), 2), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(4L), 4), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(6L), 6), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(41L), 41));
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(b), INTERVAL '0.003' SECOND))", new Object[0]);
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_a, DESCRIPTOR(c), INTERVAL '0.003' SECOND))", new Object[0]);
        String sql = "SELECT we1, sum1, max2 FROM ( SELECT window_end AS we1, SUM(DISTINCT a) AS sum1 FROM     TABLE(TUMBLE(TABLE s1, DESCRIPTOR(b), INTERVAL '0.003' SECOND))    GROUP BY window_end) st1  JOIN ( SELECT window_end AS we2, MAX(DISTINCT d) AS max2 FROM     TABLE(TUMBLE(TABLE s2, DESCRIPTOR(c), INTERVAL '0.003' SECOND))    GROUP BY window_end) st2 ON st1.we1 = st2.we2";
        SqlStreamingJoinAndAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(3L), 1L, 2), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(6L), 8L, 4), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(9L), 5L, 6)));
    }

    @Test
    public void test_doubleStaged_hop() {
        String stream1 = "stream1x";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), SqlStreamingJoinAndAggregationTest.row(1, SqlStreamingJoinAndAggregationTest.timestampTz(1L)), SqlStreamingJoinAndAggregationTest.row(2, SqlStreamingJoinAndAggregationTest.timestampTz(2L)), SqlStreamingJoinAndAggregationTest.row(101, SqlStreamingJoinAndAggregationTest.timestampTz(101L)));
        String stream2 = "stream_ax";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(1L), 1), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(2L), 2), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(101L), 101));
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1x, DESCRIPTOR(b), INTERVAL '0.001' SECOND))", new Object[0]);
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_ax, DESCRIPTOR(c), INTERVAL '0.001' SECOND))", new Object[0]);
        String sql = "SELECT we1, _sum, _max FROM ( SELECT window_end AS we1, SUM(a) AS _sum FROM     TABLE(HOP(TABLE s1, DESCRIPTOR(b), INTERVAL '0.02' SECOND, INTERVAL '0.01' SECOND))    GROUP BY window_end) st1  JOIN ( SELECT window_end AS we2, MAX(d) AS _max FROM     TABLE(HOP(TABLE s2, DESCRIPTOR(c), INTERVAL '0.02' SECOND, INTERVAL '0.01' SECOND))    GROUP BY window_end) st2 ON st1.we1 = st2.we2";
        SqlStreamingJoinAndAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(10L), 3L, 2), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(20L), 3L, 2)));
    }

    @Test
    public void test_doubleStaged_tumble() {
        String stream1 = "stream11";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), SqlStreamingJoinAndAggregationTest.row(1, SqlStreamingJoinAndAggregationTest.timestampTz(1L)), SqlStreamingJoinAndAggregationTest.row(3, SqlStreamingJoinAndAggregationTest.timestampTz(3L)), SqlStreamingJoinAndAggregationTest.row(5, SqlStreamingJoinAndAggregationTest.timestampTz(5L)), SqlStreamingJoinAndAggregationTest.row(5, SqlStreamingJoinAndAggregationTest.timestampTz(7L)), SqlStreamingJoinAndAggregationTest.row(41, SqlStreamingJoinAndAggregationTest.timestampTz(41L)));
        String stream2 = "stream_aa";
        TestStreamSqlConnector.create(SqlStreamingJoinAndAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(0L), 0), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(2L), 2), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(4L), 4), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(6L), 6), SqlStreamingJoinAndAggregationTest.row(SqlStreamingJoinAndAggregationTest.timestampTz(41L), 41));
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream11, DESCRIPTOR(b), INTERVAL '0.003' SECOND))", new Object[0]);
        SqlStreamingJoinAndAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_aa, DESCRIPTOR(c), INTERVAL '0.003' SECOND))", new Object[0]);
        String sql = "SELECT we1, sum1, max2 FROM ( SELECT window_end AS we1, SUM(a) AS sum1 FROM     TABLE(TUMBLE(TABLE s1, DESCRIPTOR(b), INTERVAL '0.003' SECOND))    GROUP BY window_end) st1  JOIN ( SELECT window_end AS we2, MAX(d) AS max2 FROM     TABLE(TUMBLE(TABLE s2, DESCRIPTOR(c), INTERVAL '0.003' SECOND))    GROUP BY window_end) st2 ON st1.we1 = st2.we2";
        SqlStreamingJoinAndAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(3L), 1L, 2), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(6L), 8L, 4), new SqlTestSupport.Row(SqlStreamingJoinAndAggregationTest.timestampTz(9L), 5L, 6)));
    }
}

