/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlHopTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() throws IOException {
        SqlHopTest.initialize((int)1, null);
        sqlService = SqlHopTest.instance().getSql();
    }

    @Test
    public void test_validArguments_tinyInt() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.TINYINT, "1", SqlHopTest.row((byte)0), SqlHopTest.row((byte)2));
    }

    @Test
    public void test_validArguments_smallInt() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.SMALLINT, "2", SqlHopTest.row((short)0), SqlHopTest.row((short)2));
    }

    @Test
    public void test_validArguments_int() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.INTEGER, "3", SqlHopTest.row(0), SqlHopTest.row(2));
    }

    @Test
    public void test_validArguments_bigInt() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.BIGINT, "4", SqlHopTest.row(0L), SqlHopTest.row(2L));
    }

    @Test
    public void test_validArguments_time() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.TIME, "INTERVAL '0.005' SECOND", SqlHopTest.row(SqlHopTest.time(0L)), SqlHopTest.row(SqlHopTest.time(2L)));
    }

    @Test
    public void test_validArguments_date() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.DATE, "INTERVAL '6' DAYS", SqlHopTest.row(SqlHopTest.date(0L)), SqlHopTest.row(SqlHopTest.date(2L)));
    }

    @Test
    public void test_validArguments_timestamp() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.TIMESTAMP, "INTERVAL '0.007' SECOND", SqlHopTest.row(SqlHopTest.timestamp(0L)), SqlHopTest.row(SqlHopTest.timestamp(2L)));
    }

    @Test
    public void test_validArguments_timestampTz() {
        SqlHopTest.checkValidArguments(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "INTERVAL '0.008' SECOND", SqlHopTest.row(SqlHopTest.timestampTz(0L)), SqlHopTest.row(SqlHopTest.timestampTz(2L)));
    }

    private static void checkValidArguments(QueryDataTypeFamily orderingColumnType, String size, Object[] ... values) {
        String name = SqlHopTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), values);
        try (SqlResult result = sqlService.execute("SELECT * FROM TABLE(HOP(TABLE " + name + ", DESCRIPTOR(ts), " + size + ", " + size + "))", new Object[0]);){
            Assertions.assertThat((int)result.getRowMetadata().findColumn("window_start")).isEqualTo(1);
            Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(1).getType()).isEqualTo((Object)orderingColumnType.getPublicType());
            Assertions.assertThat((int)result.getRowMetadata().findColumn("window_end")).isEqualTo(2);
            Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(2).getType()).isEqualTo((Object)orderingColumnType.getPublicType());
            Assertions.assertThat((Iterator)result.iterator()).hasNext();
        }
    }

    @Test
    public void test_invalidArguments_tinyInt() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.TINYINT, "INTERVAL '0.001' SECOND");
    }

    @Test
    public void test_invalidArguments_smallInt() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.SMALLINT, "INTERVAL '0.002' SECOND");
    }

    @Test
    public void test_invalidArguments_int() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.INTEGER, "INTERVAL '0.003' SECOND");
    }

    @Test
    public void test_invalidArguments_bigInt() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.BIGINT, "INTERVAL '0.004' SECOND");
    }

    @Test
    public void test_invalidArguments_decimal_interval() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.DECIMAL, "INTERVAL '0.005' SECOND");
    }

    @Test
    public void test_invalidArguments_decimal_number() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.DECIMAL, "6");
    }

    @Test
    public void test_invalidArguments_real_interval() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.REAL, "INTERVAL '0.007' SECOND");
    }

    @Test
    public void test_invalidArguments_real_number() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.REAL, "8");
    }

    @Test
    public void test_invalidArguments_double_interval() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.DOUBLE, "INTERVAL '0.009' SECOND");
    }

    @Test
    public void test_invalidArguments_double_number() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.DOUBLE, "10");
    }

    @Test
    public void test_invalidArguments_time() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.TIME, "11");
    }

    @Test
    public void test_invalidArguments_date() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.DATE, "12");
    }

    @Test
    public void test_invalidArguments_timestamp() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.TIMESTAMP, "13");
    }

    @Test
    public void test_invalidArguments_timestampTz() {
        SqlHopTest.checkInvalidArguments(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "14");
    }

    private static void checkInvalidArguments(QueryDataTypeFamily orderingColumnType, String size) {
        String name = SqlHopTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(HOP(TABLE " + name + ", DESCRIPTOR(ts), " + size + ", " + size + "))", new Object[0])).hasMessageContaining("The descriptor column type").hasMessageContaining("and the interval type").hasMessageContaining("do not match");
    }

    @Test
    public void test_windowBounds() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, name FROM TABLE(HOP(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND))", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(2L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), "Bob"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), "Bob")));
    }

    @Test
    public void test_windowBoundsWithNullDescriptorEvent() {
        String name = SqlHopTest.createTable(SqlHopTest.row(null, "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, name FROM TABLE(HOP(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND))", Arrays.asList(new SqlTestSupport.Row(null, null, "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), "Bob"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), "Bob")));
    }

    @Test
    public void test_projectWindowBounds() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(1000L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2000L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT SIN( CAST( EXTRACT(SECOND FROM window_start) AS DOUBLE)), SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", SqlHopTest.rows(2, Math.sin(0.0), 1L, Math.sin(1.0), 1L));
    }

    @Test
    public void test_groupBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(20L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start/*, window_end*/ FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY 1/*, 2*/", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L))));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, /*window_end,*/ name FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.003' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.006' SECOND  , INTERVAL '0.003' SECOND)) GROUP BY /*window_end,*/ window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-3L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(-3L), null), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), null), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob"), new SqlTestSupport.Row(SqlHopTest.timestampTz(3L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(3L), "Bob")));
    }

    @Test
    public void test_groupByNotSelectedField() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L))));
    }

    @Test
    public void test_groupByExpression() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(7L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name || '-s' AS n FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Alice-s")));
    }

    @Test
    public void test_groupByAliasedExpression() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name || '-s' AS nani FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start, nani", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob-s")));
    }

    @Test
    public void test_groupByWindowBoundWithExpression() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(20L), null, null));
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start + INTERVAL '0.001' SECOND, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start + INTERVAL '0.001' SECOND", new Object[0])).hasRootCauseMessage("In window aggregation, the window_start and window_end fields must be used directly, without any transformation");
    }

    @Test
    public void test_groupByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(7L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), "Alice", 1));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name || '-s' AS n FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start, name HAVING LENGTH(n) > 5", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice-s"), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Alice-s")));
    }

    @Test
    public void test_groupByEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_count() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 2L)));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(*) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 4L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_countDistinct() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(DISTINCT name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_countGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 4L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_countDistinctGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(DISTINCT distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_countGroupedByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(*) c FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING c <> 2", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", 3L)));
    }

    @Test
    public void test_countFilter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", 2L)));
    }

    @Test
    public void test_countEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start, COUNT(*) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_min() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(0L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Joey", 3), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MIN(name), MIN(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 2)));
    }

    @Test
    public void test_minDistinct() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MIN(DISTINCT name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob")));
    }

    @Test
    public void test_minGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 1)));
    }

    @Test
    public void test_minGroupedByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 3), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Alice", 4), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) m FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING m > 1", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 3), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Alice", 3)));
    }

    @Test
    public void test_minFilter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "' GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 3), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 3)));
    }

    @Test
    public void test_minEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start, MIN(name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_max() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(0L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Joey", 3), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MAX(name), MAX(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Joey", 3), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", 3)));
    }

    @Test
    public void test_maxDistinct() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MAX(DISTINCT name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob"), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Joey"), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey")));
    }

    @Test
    public void test_maxGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 2)));
    }

    @Test
    public void test_maxGroupedByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Alice", 0), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) m FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING m < 3", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Alice", 1)));
    }

    @Test
    public void test_maxFilter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "' GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 3), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 3)));
    }

    @Test
    public void test_maxEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start, MAX(name) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_sum() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_sumDistinct() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, SUM(DISTINCT distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 3L)));
    }

    @Test
    public void test_sumGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 4L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 5L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 3L)));
    }

    @Test
    public void test_sumDistinctGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(DISTINCT distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 3L)));
    }

    @Test
    public void test_sumGroupedByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) s FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING s > 1", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", 3L)));
    }

    @Test
    public void test_sumFilter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", 2L)));
    }

    @Test
    public void test_sumEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_avg() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 5), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, AVG(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), new BigDecimal(3)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), new BigDecimal(3)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), new BigDecimal(3))));
    }

    @Test
    public void test_avgDistinct() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, AVG(DISTINCT distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), new BigDecimal("1.5")), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), new BigDecimal("1.5"))));
    }

    @Test
    public void test_avgGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 4), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 2), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 3), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", new BigDecimal(3)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", new BigDecimal(3))));
    }

    @Test
    public void test_avgDistinctGroupedBy() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 2), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(DISTINCT distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", new BigDecimal("1.5")), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", new BigDecimal("1.5"))));
    }

    @Test
    public void test_avgGroupedByHaving() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 3), SqlHopTest.row(SqlHopTest.timestampTz(4L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 4), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) a FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING a > 1", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Bob", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", new BigDecimal(2))));
    }

    @Test
    public void test_avgFilter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 3), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), "Bob", new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Bob", new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), "Joey", new BigDecimal(2)), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), "Joey", new BigDecimal(2))));
    }

    @Test
    public void test_avgEmpty() {
        String name = SqlHopTest.createTable(new Object[0][]);
        SqlHopTest.assertEmptyResultStream("SELECT window_start, AVG(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_noOrdering() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), null, null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start, SUM(distance) FROM TABLE(HOP(TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_withFullProjection() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND  , INTERVAL '0.001' SECOND)) GROUP BY window_start, window_end, ts, name, distance", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1, SqlHopTest.timestampTz(-1L), SqlHopTest.timestampTz(1L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), "Alice", 1, SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L))));
    }

    @Test
    public void test_multipleAggregations() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Bob", 3), SqlHopTest.row(SqlHopTest.timestampTz(5L), "Joey", 5), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(*), MIN(name), MAX(name), SUM(distance), AVG(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 2L, "Alice", "Bob", 2L, new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 3L, "Alice", "Bob", 3L, new BigDecimal(1)), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 3L, "Alice", "Joey", 9L, new BigDecimal(3)), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), 2L, "Bob", "Joey", 8L, new BigDecimal(4))));
    }

    @Test
    public void test_ordering_tinyInt() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.TINYINT, "2", SqlHopTest.row((byte)0), SqlHopTest.row((byte)4));
    }

    @Test
    public void test_ordering_smallInt() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.SMALLINT, "2", SqlHopTest.row((short)0), SqlHopTest.row((short)4));
    }

    @Test
    public void test_ordering_int() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.INTEGER, "2", SqlHopTest.row(0), SqlHopTest.row(4));
    }

    @Test
    public void test_ordering_bigInt() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.BIGINT, "2", SqlHopTest.row(0L), SqlHopTest.row(4L));
    }

    @Test
    public void test_ordering_time() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.TIME, "INTERVAL '0.002' SECOND", SqlHopTest.row(SqlHopTest.time(0L)), SqlHopTest.row(SqlHopTest.time(4L)));
    }

    @Test
    public void test_ordering_date() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.DATE, "INTERVAL '2' DAYS", SqlHopTest.row(SqlHopTest.date(0L)), SqlHopTest.row(SqlHopTest.date(345600000L)));
    }

    @Test
    public void test_ordering_timestamp() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.TIMESTAMP, "INTERVAL '0.002' SECOND", SqlHopTest.row(SqlHopTest.timestamp(0L)), SqlHopTest.row(SqlHopTest.timestamp(4L)));
    }

    @Test
    public void test_ordering_timestampTz() {
        SqlHopTest.checkOrdering(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "INTERVAL '0.002' SECOND", SqlHopTest.row(SqlHopTest.timestampTz(0L)), SqlHopTest.row(SqlHopTest.timestampTz(4L)));
    }

    private static void checkOrdering(QueryDataTypeFamily orderingColumnType, String size, Object[] ... values) {
        String name = SqlHopTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), values);
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT COUNT(*) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), " + size + ")))  , DESCRIPTOR(ts)  , " + size + "  , " + size + ")) GROUP BY window_start", Collections.singletonList(new SqlTestSupport.Row(1L)));
    }

    @Test
    public void test_nested_filter() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 3), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_start_inner, name, COUNT(name) FROM TABLE(HOP(   (SELECT ts, name, window_start AS window_start_inner FROM      TABLE(HOP(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.004' SECOND           , INTERVAL '0.002' SECOND       )) WHERE ts > '" + String.valueOf(SqlHopTest.timestampTz(0L)) + "'    )   , DESCRIPTOR(ts)   , INTERVAL '0.004' SECOND   , INTERVAL '0.002' SECOND)) GROUP BY window_start, window_start_inner, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_nested_project() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, wsi, wei, name, COUNT(name) FROM TABLE(HOP(   (SELECT ts, name, window_start AS wsi, window_end AS wei FROM       TABLE(HOP(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND           , INTERVAL '0.001' SECOND       ))   )   , DESCRIPTOR(ts)   , INTERVAL '0.004' SECOND   , INTERVAL '0.002' SECOND)) GROUP BY window_start, window_end, wsi, wei, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(-1L), SqlHopTest.timestampTz(1L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L), "Alice", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(1L), SqlHopTest.timestampTz(3L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(-1L), SqlHopTest.timestampTz(1L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L), "Alice", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(1L), SqlHopTest.timestampTz(3L), "Alice", 2L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(4L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(4L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(3L), SqlHopTest.timestampTz(5L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(1L), SqlHopTest.timestampTz(3L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(4L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(4L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(3L), SqlHopTest.timestampTz(5L), "Bob", 1L)));
    }

    @Test
    public void test_nested_aggregate() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_end, window_end_inner, name, COUNT(name) FROM TABLE(HOP(   (SELECT name, window_end AS window_end_inner FROM        TABLE(HOP(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND           , INTERVAL '0.001' SECOND       )) GROUP BY name, window_end_inner   )   , DESCRIPTOR(window_end_inner)   , INTERVAL '0.004' SECOND   , INTERVAL '0.002' SECOND)) GROUP BY window_end, window_end_inner, name", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(1L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(1L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(2L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(3L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(4L), SqlHopTest.timestampTz(3L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(2L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(3L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(3L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(4L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(4L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(6L), SqlHopTest.timestampTz(5L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(8L), SqlHopTest.timestampTz(4L), "Alice", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(8L), SqlHopTest.timestampTz(4L), "Bob", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(8L), SqlHopTest.timestampTz(5L), "Bob", 1L)));
    }

    @Test
    public void test_nested_join() {
        SqlHopTest.createMapping("map", OffsetDateTime.class, String.class);
        SqlHopTest.instance().getMap("map").put((Object)SqlHopTest.timestampTz(0L), (Object)"value-0");
        SqlHopTest.instance().getMap("map").put((Object)SqlHopTest.timestampTz(1L), (Object)"value-1");
        SqlHopTest.instance().getMap("map").put((Object)SqlHopTest.timestampTz(2L), (Object)"value-2");
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(1L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Joey", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_start_inner, this, COUNT(*) FROM TABLE(HOP(   (SELECT ts, window_start window_start_inner, name, this FROM        TABLE(HOP(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND           , INTERVAL '0.001' SECOND       )) JOIN map ON ts = __key   )   , DESCRIPTOR(ts)   , INTERVAL '0.004' SECOND   , INTERVAL '0.002' SECOND)) GROUP BY window_start, window_start_inner, this", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(-1L), "value-0", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(0L), "value-0", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(0L), "value-1", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(1L), "value-1", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(-1L), "value-0", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(0L), "value-0", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(0L), "value-1", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(1L), "value-1", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(1L), "value-2", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(2L), "value-2", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(1L), "value-2", 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(2L), "value-2", 1L)));
    }

    @Test
    public void test_namedParameters() {
        String name = SqlHopTest.createTable(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice", 1), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob", 1), SqlHopTest.row(SqlHopTest.timestampTz(10L), null, null));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, /*window_end,*/ COUNT(name) FROM TABLE(HOP(   time_col => DESCRIPTOR(ts)   , window_size => INTERVAL '0.004' SECOND   , slide_size =>  INTERVAL '0.002' SECOND   , input => (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND))))) GROUP BY window_start/*, window_end*/", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_groupByWithoutOrdering() {
        String name = SqlHopTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start FROM TABLE(HOP(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND, INTERVAL '0.002' SECOND)) GROUP BY window_start", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_aggregationWithoutGrouping() {
        String name = SqlHopTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(HOP(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND, INTERVAL '0.002' SECOND)) GROUP BY window_start", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_aggregationWithoutOrderingAndGrouping() {
        String name = SqlHopTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(HOP(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND, INTERVAL '0.002' SECOND))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_noGroupBy() {
        String name = SqlHopTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_groupByNonWindowBound() {
        String name = SqlHopTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start, SUM(distance) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start + INTERVAL '0.001' SECOND", new Object[0])).hasMessageContaining("Expression 'window_start' is not being grouped");
    }

    @Test
    public void test_batchSource() {
        String name = SqlHopTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), TestBatchSqlConnector.valuesToString(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice"), SqlHopTest.row(SqlHopTest.timestampTz(1L), null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice"), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob")));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, COUNT(name) FROM TABLE(HOP(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start, window_end", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-2L), SqlHopTest.timestampTz(2L), 1L), new SqlTestSupport.Row(SqlHopTest.timestampTz(0L), SqlHopTest.timestampTz(4L), 3L), new SqlTestSupport.Row(SqlHopTest.timestampTz(2L), SqlHopTest.timestampTz(6L), 2L)));
    }

    @Test
    public void test_batchSource_noGroupBy() {
        String name = SqlHopTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "id"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), TestBatchSqlConnector.valuesToString(SqlHopTest.row(SqlHopTest.timestampTz(2L), 1), SqlHopTest.row(SqlHopTest.timestampTz(4L), 2), SqlHopTest.row(SqlHopTest.timestampTz(6L), 3)));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT SUM(id) FROM TABLE(HOP(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.2' SECOND  , INTERVAL '0.1' SECOND))", Collections.singletonList(new SqlTestSupport.Row(12L)));
    }

    @Test
    public void test_batchSource_groupByNonWindowBound() {
        String name = SqlHopTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), TestBatchSqlConnector.valuesToString(SqlHopTest.row(SqlHopTest.timestampTz(0L), "Alice"), SqlHopTest.row(SqlHopTest.timestampTz(1L), null), SqlHopTest.row(SqlHopTest.timestampTz(2L), "Alice"), SqlHopTest.row(SqlHopTest.timestampTz(3L), "Bob")));
        SqlHopTest.assertRowsEventuallyInAnyOrder("SELECT window_start + INTERVAL '0.001' SECOND FROM TABLE(HOP(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.004' SECOND  , INTERVAL '0.002' SECOND)) GROUP BY window_start + INTERVAL '0.001' SECOND", Arrays.asList(new SqlTestSupport.Row(SqlHopTest.timestampTz(-1L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(1L)), new SqlTestSupport.Row(SqlHopTest.timestampTz(3L))));
    }

    private static String createTable(Object[] ... values) {
        String name = SqlHopTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Arrays.asList("ts", "name", "distance"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), values);
        return name;
    }
}

